<?php
/**
 * Description of StocksModel
 *
 * @author Kelvin Benard
 * @email kelvin@lockminds.com
 */

class ExpensesBudgetsModelOld extends MY_Model{

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    function getBalance($budget){
        return $this->getBalanceTransactions($budget) - $this->getTotalExpenditure($budget);
    }

    function getBalanceTransactions($budget){
        $this->db->where('budget_key',$budget);
        $this->db->join('expense_budget_transactions','expense_budget_transactions.bg_budget=budget_key','left');
        $this->db->select_sum('bg_deposit','total_deposit');
        $this->db->select_sum('bg_withdraw','total_withdraw');
        $this->db->group_by('budget_key');
        $query = $this->db->get("expense_budgets");
        $transBalance =  $query->num_rows()>0 ? $query->row()->total_deposit - $query->row()->total_withdraw : 0;
        return $transBalance;
    }
    function getTotalExpenditure($budget){
        $this->db->select('SUM(DISTINCT expense_amount) as total');
        $this->db->where('expense_budget',$budget);
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->row()->total : 0;
    }



    function details($budget){
        $this->db->select('*');
        $this->db->where('budget_key',$budget);
        $this->db->select('DATE_FORMAT(budget_created_at, "%m/%d/%Y") as budget_date', FALSE);
        $this->db->join('expense_budget_transactions','expense_budget_transactions.bg_budget=budget_key','left');
        $this->db->select_sum('bg_deposit','total_deposit');
        $this->db->select_sum('bg_withdraw','total_withdraw');
        $this->db->group_by('budget_key');
        $query = $this->db->get("expense_budgets");
        return $query->num_rows()>0 ? $query->row() : false;
    }

    function budgets($when = ''){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('budget_created_at >=',$dates['start']);
            $this->db->where('budget_created_at <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->where('budget_branch',$this->branch);
        $this->db->select('DATE_FORMAT(budget_created_at, "%m/%d/%Y") as budget_date', FALSE);
        $this->db->join('expense_budget_transactions','expense_budget_transactions.bg_budget=budget_key','left');
        $this->db->select_sum('bg_deposit','total_deposit');
        $this->db->select_sum('bg_withdraw','total_withdraw');
        $this->db->group_by('budget_key');
        $query = $this->db->get('expense_budgets');
        return $query->num_rows()>0 ? $query->result_array() : false;
    }

    function transactions($budget,$when = ''){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('bg_date >=',$dates['start']);
            $this->db->where('bg_date <=',$dates['end']);
        }

        $this->db->join('users_details ud','ud.user_key=expense_budget_transactions.bg_user','left');
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS user');
        $this->db->select('DATE_FORMAT(bg_date, "%m/%d/%Y") as bg_date', FALSE);
        $this->db->select('DATE_FORMAT(bg_timestamp, "%m/%d/%Y") as bg_posted_date', FALSE);
        $this->db->where('bg_budget',$budget);
        $query = $this->db->get('expense_budget_transactions');
        return $query->num_rows()>0 ? $query->result_array() : false;
    }

    function deposits($budget,$when = ''){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('bg_date >=',$dates['start']);
            $this->db->where('bg_date <=',$dates['end']);
        }

        $this->db->join('users_details ud','ud.user_key=bg_user','left');
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS user');
        $this->db->select('DATE_FORMAT(bg_date, "%m/%d/%Y") as bg_date', FALSE);
        $this->db->select('DATE_FORMAT(bg_timestamp, "%m/%d/%Y") as bg_posted_date', FALSE);
        $this->db->where('bg_budget',$budget);
        $this->db->where('bg_deposit >',0);
        $query = $this->db->get('expense_budget_transactions');
        return $query->num_rows()>0 ? $query->result_array() : false;
    }

    function withdraws($budget,$when = ''){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('bg_date >=',$dates['start']);
            $this->db->where('bg_date <=',$dates['end']);
        }

        $this->db->join('users_details ud','ud.user_key=bg_user','left');
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS user');
        $this->db->select('DATE_FORMAT(bg_date, "%m/%d/%Y") as bg_date', FALSE);
        $this->db->select('DATE_FORMAT(bg_timestamp, "%m/%d/%Y") as bg_posted_date', FALSE);
        $this->db->where('bg_budget',$budget);
        $this->db->where('bg_withdraw >',0);
        $query = $this->db->get('expense_budget_transactions');
        return $query->num_rows()>0 ? $query->result_array() : false;
    }

    function expendicture($budget,$when = ''){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_at >=',$dates['start']);
            $this->db->where('expense_created_at <=',$dates['end']);
        }

        $this->db->join('users_details ud','ud.user_key=expense_creator','left');
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS user');
        $this->db->select('DATE_FORMAT(expense_created_at, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->where('expense_budget',$budget);
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->result_array() : false;
    }

    public function budgetKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'budget_key', $random_unique_int )
            ->get_where( 'expense_budgets' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->budgetKey();
        }

        return $random_unique_int;
    }
}
