<?php

require_once APPPATH.'models/BMS_Model.php';

class ExpensesModel extends BMS_Model {
    protected $branch_field = "expense_branch";
    protected $branch;
    protected $business_field = 'expense_business';
    protected $business;

    protected $filterable_date_field = 'expense_date';

    protected $table_name   = 'expenses';
    protected $key          = 'expense_key';
    protected $primary_key  = 'expense_key';
    protected $soft_deletes = TRUE;
    protected $date_format  = 'datetime';
    protected $log_user     = TRUE;

    public    $selectable_fields = array('expense_amount','firstname','lastname','category_title','type_title','budget_title','expense_is_posted','expense_payee','expense_debit_account','expense_credit_account','expense_id','expense_key','expense_details','expense_date','expense_status','expense_type','expense_branch','expense_business','expense_created_by','expense_modified_by','expense_date','expense_modified_on','expense_deleted','expense_deleted_by',
                                         'budget_key','budget_title','expense_freight_ref');

    protected $set_created  = TRUE;
    protected $created_field    = 'expense_created_on';
    protected $created_by_field = 'expense_created_by';

    protected $set_modified     = TRUE;
    protected $modified_field   = 'expense_modified_on';
    protected $modified_by_field = 'expense_modified_by';

    protected $soft_delete_key    = 'expense_deleted';
    protected $deleted_by_field = 'expense_deleted_by';

    // Observers
    protected $before_insert    = array('set_key','set_ownership');
    protected $after_insert     = array('publish_event');
    protected $before_update    = array();
    protected $after_update     = array('publish_event');
    protected $before_find      = array('set_selectable_fields','set_join','set_select_dates','set_ownership_select','set_limit_offset');
    protected $after_find       = array();
    protected $before_delete    = array();
    protected $after_delete     = array('publish_event');

    protected $return_type      = 'array';
    protected $protected_attributes   = array();

    protected $validation_rules         = array();
    protected $insert_validation_rules  = array();
    protected $skip_validation          = true;

    public function __construct(&$write_db = null, &$read_db = null)
    {
        parent::__construct($write_db, $read_db);
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    protected function set_key($row){

        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( $this->key, $random_unique_int )
            ->get_where( $this->table_name );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->taxClassKey();
        }

        if (!array_key_exists($this->key, $row))
        {
            $row[$this->key] = $random_unique_int;
        }

        return $row;
    }

    protected function set_ownership($row){

        if(!empty($this->business)){
            $row[$this->business_field] = $this->business;
        }

        if(!empty($this->branch)){
            $row[$this->branch_field] = $this->branch;
        }

        return $row;
    }

    protected function set_created_by($row)
    {
        if (!array_key_exists($this->created_by_field, $row))
        {
            $row[$this->created_by_field] = config_item("auth_user_id");
        }

        return $row;
    }

    protected function set_deleted_by($id)
    {
        $this->dbw->where($this->primary_key, $id);
        $this->db->update($this->table_name, [$this->deleted_by_field => config_item("auth_user_id")]);
    }

    protected function set_modified_by($row)
    {
        if (!array_key_exists($this->modified_by_field, $row))
        {
            $row[$this->modified_by_field] = config_item("auth_user_id");
        }

        return $row;
    }

    protected function set_modified_on($row)
    {
        if (!array_key_exists($this->modified_field, $row))
        {
            $row[$this->modified_field] = date('Y-m-d H:m:i');
        }

        return $row;
    }

    protected function set_selectable_fields()
    {
        if(!empty($this->selectable_fields)){
            $this->db->select($this->selectable_fields);
        }

    }

    protected function set_select_dates(){
        if(!empty($when = $this->input->get("when"))){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where($this->filterable_date_field.'>=',$dates['start']);
            $this->db->where($this->filterable_date_field.'<=',$dates['end']);
        }
    }

    protected function set_join(){
        $this->db->join('expense_categories ec','ec.category_key=expense_category','left');
        $this->db->join('expense_types et','et.type_key=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_key=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_created_by','left');
    }

    protected function set_ownership_select(){
        $this->db->where($this->business_field,$this->business);
        $this->db->where($this->branch_field,$this->branch);
    }

    protected function publish_event(){
        publishEventFlash('data-table-refresh');
    }

    protected function set_limit_offset(){
        if(!empty($when = $this->input->get("when"))){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where($this->filterable_date_field.'>=',$dates['start']);
            $this->db->where($this->filterable_date_field.'<=',$dates['end']);
        }
    }


    /*
     * -------------------------------------------------------------------------------------
     */
    function expenseTypes($type,$when){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_date >=',$dates['start']);
            $this->db->where('expense_date <=',$dates['end']);
        }
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_date, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_id=expense_category','left');
        $this->db->join('expense_types et','et.type_id=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_id=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $this->db->where('expense_type',$type);
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }

    function expenseCategories($category,$when){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_date >=',$dates['start']);
            $this->db->where('expense_date <=',$dates['end']);
        }
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_date, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_id=expense_category','left');
        $this->db->join('expense_types et','et.type_id=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_id=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $this->db->where('expense_category',$category);
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }

    function expenseBudgets($budget,$when){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_date >=',$dates['start']);
            $this->db->where('expense_date <=',$dates['end']);
        }
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_date, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_id=expense_category','left');
        $this->db->join('expense_types et','et.type_id=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_id=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $this->db->where('expense_budget',$budget);
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }

    function  expenseDocs($expense){
        $this->db->where('doc_expense',$expense);
        $query = $this->db->get('expense_docs');
        return $query->num_rows()>0 ? $query->result_array() : false;
    }

    function expenseEmployees($employee,$when){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_date >=',$dates['start']);
            $this->db->where('expense_date <=',$dates['end']);
        }
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_date, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_id=expense_category','left');
        $this->db->join('expense_types et','et.type_id=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_id=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $this->db->where('expense_creator',$employee);
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }

    function expenseBudgetDetails($budget){
        $this->db->where('budget_id',$budget);
        $query = $this->db->get('expense_budgets');
        return $query->num_rows()>0 ? $query->row() : false;
    }


    function expenseTypeDetails($type){
        $this->db->where('type_id',$type);
        $query = $this->db->get('expense_types');
        return $query->num_rows()>0 ? $query->row() : false;
    }
    /*
     * -------------------------------------------------------------------------------------
     */
    function expensesCancelRequests($when = ''){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_date >=',$dates['start']);
            $this->db->where('expense_date <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_date, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_id=expense_category','left');
        $this->db->join('expense_types et','et.type_id=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_id=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $this->db->where('expense_cancel_request',1);
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }


    function expensesPartials($when = ''){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_date >=',$dates['start']);
            $this->db->where('expense_date <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_date, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_id=expense_category','left');
        $this->db->join('expense_types et','et.type_id=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_id=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $this->db->where('`expense_amount` < `expense_amount`');
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }

    function expenses(){

        if(!empty($when = $this->input->get("when"))){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_date >=',$dates['start']);
            $this->db->where('expense_date <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->where('expense_branch', $this->branch);
        $this->db->where('expense_business', $this->business);
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_date, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_key=expense_category','left');
        $this->db->join('expense_types et','et.type_key=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_key=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }

    function expensescashier($when = ''){
        $cashier = profile()->user_id;
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_date >=',$dates['start']);
            $this->db->where('expense_date <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->where('expense_creator',$cashier);
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_date, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_id=expense_category','left');
        $this->db->join('expense_types et','et.type_id=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_id=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }

    function details($expense){
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_date, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_key=expense_category','left');
        $this->db->join('expense_types et','et.type_key=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_key=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $this->db->where('expense_key',$expense);
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->row() : false;
    }

    function expenseDetails($expense){
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_date, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_key=expense_category','left');
        $this->db->join('expense_types et','et.type_key=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_key=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $this->db->where('expense_key',$expense);
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->row() : false;
    }

    function expenseTotalType($type,$dates=''){

        if(!empty($dates)){
            $dates = array();
            $rawdates = datesWhen();
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_date >=',$dates['start']);
            $this->db->where('expense_date <=',$dates['end']);
        }

        $this->db->where('expense_type',$type);
        $this->db->where('expense_status',1);
        $this->db->select_sum('expense_amount','total');
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->row()->total : 0;
    }

    function expenseTotalCategory($type,$when=''){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_date >=',$dates['start']);
            $this->db->where('expense_date <=',$dates['end']);
        }

        $this->db->where('expense_category',$type);
        $this->db->where('expense_status',1);
        $this->db->select_sum('expense_amount','total');
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->row()->total : 0;
    }

    function expenseTotalBudget($type,$when=''){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_date >=',$dates['start']);
            $this->db->where('expense_date <=',$dates['end']);
        }

        $this->db->where('expense_budget',$type);
        $this->db->where('expense_status',1);
        $this->db->select_sum('expense_amount','total');
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->row()->total : 0;
    }

    function expenseTotalEmployee($type,$when=''){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_date >=',$dates['start']);
            $this->db->where('expense_date <=',$dates['end']);
        }

        $this->db->where('expense_creator',$type);
        $this->db->where('expense_status',1);
        $this->db->select_sum('expense_amount','total');
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->row()->total : 0;
    }


    public function expense_settings(){
        $this->db->where("setting_business",$this->business);
        $this->db->where("setting_branch",$this->branch);
        $query = $this->db->get("expense_settings");
        return $query->num_rows()>0 ? $query->row() : false;
    }

    function expenseTotal($when=''){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_date >=',$dates['start']);
            $this->db->where('expense_date <=',$dates['end']);
        }

        $this->db->where('expense_status','approved');
        $this->db->select_sum('expense_amount','total');
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->row()->total : 0;
    }
}