<?php
/**
 * Description of StocksModel
 *
 * @author Kelvin Benard
 * @email kelvin@lockminds.com
 */

class ExpensesModelOld extends MY_Model{

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }
    
    function create($data){
        $this->db->insert('expense_categories',$data);
         return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

    function save($id,$data){
        $this->db->where('category_id',$id);
        $this->db->update('expense_categories',$data);
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

    function categories(){
        $query = $this->db->get('expense_categories');
        return $query->num_rows()>0 ? $query->result_array() : false;
    }


    function removeCategory($id){
        $this->db->where('category_id',$id);
        $this->db->delete('expense_categories');
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }


    /*
     * -------------------------------------------------------------------------------------
     */

    function createType($data){
        $this->db->insert('expense_types',$data);
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

    function removeType($id){
        $this->db->where('type_id',$id);
        $this->db->delete('expense_types');
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

    function saveType($id,$data){
        $this->db->where('type_id',$id);
        $this->db->update('expense_types',$data);
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

    /*
     * -------------------------------------------------------------------------------------
     */

    function createBudget($data){
        $this->db->insert('expense_budgets',$data);
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }


    function removeBudget($id){
        $this->db->where('budget_id',$id);
        $this->db->delete('expense_budgets');
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

    function saveBudget($id,$data){
        $this->db->where('budget_id',$id);
        $this->db->update('expense_budgets',$data);
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

    function totalExpenses(){
        return 0;
    }


    /*
     * -------------------------------------------------------------------------------------
     */
    function expenseTypes($type,$when){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_at >=',$dates['start']);
            $this->db->where('expense_created_at <=',$dates['end']);
        }
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_created_at, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_id=expense_category','left');
        $this->db->join('expense_types et','et.type_id=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_id=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $this->db->where('expense_type',$type);
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }

    function expenseCategories($category,$when){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_at >=',$dates['start']);
            $this->db->where('expense_created_at <=',$dates['end']);
        }
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_created_at, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_id=expense_category','left');
        $this->db->join('expense_types et','et.type_id=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_id=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $this->db->where('expense_category',$category);
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }

    function expenseBudgets($budget,$when){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_at >=',$dates['start']);
            $this->db->where('expense_created_at <=',$dates['end']);
        }
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_created_at, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_id=expense_category','left');
        $this->db->join('expense_types et','et.type_id=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_id=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $this->db->where('expense_budget',$budget);
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }

    function  expenseDocs($expense){
        $this->db->where('doc_expense',$expense);
        $query = $this->db->get('expense_docs');
        return $query->num_rows()>0 ? $query->result_array() : false;
    }

    function expenseEmployees($employee,$when){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_at >=',$dates['start']);
            $this->db->where('expense_created_at <=',$dates['end']);
        }
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_created_at, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_id=expense_category','left');
        $this->db->join('expense_types et','et.type_id=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_id=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $this->db->where('expense_creator',$employee);
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }

    function expenseBudgetDetails($budget){
        $this->db->where('budget_id',$budget);
        $query = $this->db->get('expense_budgets');
        return $query->num_rows()>0 ? $query->row() : false;
    }


    function expenseTypeDetails($type){
        $this->db->where('type_id',$type);
        $query = $this->db->get('expense_types');
        return $query->num_rows()>0 ? $query->row() : false;
    }
    /*
     * -------------------------------------------------------------------------------------
     */
    function expensesCancelRequests($when = ''){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_at >=',$dates['start']);
            $this->db->where('expense_created_at <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_created_at, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_id=expense_category','left');
        $this->db->join('expense_types et','et.type_id=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_id=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $this->db->where('expense_cancel_request',1);
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }


    function expensesPartials($when = ''){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_at >=',$dates['start']);
            $this->db->where('expense_created_at <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_created_at, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_id=expense_category','left');
        $this->db->join('expense_types et','et.type_id=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_id=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $this->db->where('`expense_paid` < `expense_amount`');
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }

    function expenses($when = ''){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_at >=',$dates['start']);
            $this->db->where('expense_created_at <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->where('expense_branch', $this->branch);
        $this->db->where('expense_business', $this->business);
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_created_at, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_key=expense_category','left');
        $this->db->join('expense_types et','et.type_key=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_key=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }

function expensescashier($when = ''){
    $cashier = profile()->user_id;
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_at >=',$dates['start']);
            $this->db->where('expense_created_at <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->where('expense_creator',$cashier);
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_created_at, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_id=expense_category','left');
        $this->db->join('expense_types et','et.type_id=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_id=expense_budget','left');
       $this->db->join('users_details u','u.user_key=expense_creator','left');
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }

    function details($expense){
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_created_at, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_key=expense_category','left');
        $this->db->join('expense_types et','et.type_key=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_key=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $this->db->where('expense_key',$expense);
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->row() : false;
    }

    function expenseDetails($expense){
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->order_by('expense_id','ASC');
        $this->db->select('DATE_FORMAT(expense_created_at, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->join('expense_categories ec','ec.category_key=expense_category','left');
        $this->db->join('expense_types et','et.type_key=expense_type','left');
        $this->db->join('expense_budgets eb','eb.budget_key=expense_budget','left');
        $this->db->join('users_details u','u.user_key=expense_creator','left');
        $this->db->where('expense_key',$expense);
        $query = $this->db->get('expenses');
        return $query->num_rows() >0 ? $query->row() : false;
    }

    function expenseTotalType($type,$dates=''){

        if(!empty($dates)){
            $dates = array();
            $rawdates = datesWhen();
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_at >=',$dates['start']);
            $this->db->where('expense_created_at <=',$dates['end']);
        }

        $this->db->where('expense_type',$type);
        $this->db->where('expense_status',1);
        $this->db->select_sum('expense_paid','total');
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->row()->total : 0;
    }

    function expenseTotalCategory($type,$when=''){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_at >=',$dates['start']);
            $this->db->where('expense_created_at <=',$dates['end']);
        }

        $this->db->where('expense_category',$type);
        $this->db->where('expense_status',1);
        $this->db->select_sum('expense_paid','total');
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->row()->total : 0;
    }

    function expenseTotalBudget($type,$when=''){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_at >=',$dates['start']);
            $this->db->where('expense_created_at <=',$dates['end']);
        }

        $this->db->where('expense_budget',$type);
        $this->db->where('expense_status',1);
        $this->db->select_sum('expense_paid','total');
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->row()->total : 0;
    }

    function expenseTotalEmployee($type,$when=''){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_at >=',$dates['start']);
            $this->db->where('expense_created_at <=',$dates['end']);
        }

        $this->db->where('expense_creator',$type);
        $this->db->where('expense_status',1);
        $this->db->select_sum('expense_paid','total');
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->row()->total : 0;
    }


    public function expense_settings(){
        $this->db->where("setting_business",$this->business);
        $this->db->where("setting_branch",$this->branch);
        $query = $this->db->get("expense_settings");
        return $query->num_rows()>0 ? $query->row() : false;
    }

    function expenseTotal($when=''){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_at >=',$dates['start']);
            $this->db->where('expense_created_at <=',$dates['end']);
        }

        $this->db->where('expense_status',1);
        $this->db->select_sum('expense_paid','total');
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->row()->total : 0;
    }

    public function expenseKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'expense_key', $random_unique_int )
            ->get_where( 'expenses' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->expenseKey();
        }

        return $random_unique_int;
    }
    

}
