<?php
/**
 * Description of StocksModel
 *
 * @author Kelvin Benard
 * @email kelvin@lockminds.com
 */

require_once APPPATH.'models/BMS_Model.php';
class ExpensesTypesModel extends BMS_Model {

    protected $branch_field = "type_branch";
    protected $branch;
    protected $business_field = 'type_business';
    protected $business; 

    protected $filterable_date_field = 'type_date';

    protected $table_name   = 'expense_types';
    protected $key          = 'type_key';
    protected $primary_key  = 'type_key';
    protected $soft_deletes = TRUE;
    protected $date_format  = 'datetime';
    protected $log_user     = TRUE;

    public    $selectable_fields = array('type_key','type_title','type_details','type_category','type_max','type_reference','type_status','type_date','type_created_on','type_created_by','type_modified_on','type_modified_by',
        'category_title','account_key','account_name','expense_date','expense_payee','expense_details','expense_status','expense_amount','expense_debit_account');

    protected $set_created  = TRUE;
    protected $created_field    = 'type_created_on';
    protected $created_by_field = 'type_created_by';

    protected $set_modified     = TRUE;
    protected $modified_field   = 'type_modified_on';
    protected $modified_by_field = 'type_modified_by';

    protected $soft_delete_key    = 'type_deleted';
    protected $deleted_by_field = 'type_deleted_by';

    // Observers
    protected $before_insert    = array('set_key','set_ownership');
    protected $after_insert     = array('publish_event');
    protected $before_update    = array();
    protected $after_update     = array('publish_event');
    protected $before_find      = array('set_selectable_fields','set_join','set_select_dates','set_ownership_select','set_limit_offset');
    protected $after_find       = array();
    protected $before_delete    = array();
    protected $after_delete     = array('publish_event');

    protected $return_type      = 'array';
    protected $protected_attributes   = array();

    protected $validation_rules         = array();
    protected $insert_validation_rules  = array();
    protected $skip_validation          = true;

    public function __construct(&$write_db = null, &$read_db = null) {
        parent::__construct($write_db, $read_db);
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    protected function set_key($row){

        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( $this->key, $random_unique_int )
            ->get_where( $this->table_name );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->taxClassKey();
        }

        if (!array_key_exists($this->key, $row))
        {
            $row[$this->key] = $random_unique_int;
        }

        return $row;
    }

    protected function set_ownership($row){

        if(!empty($this->business)){
            $row[$this->business_field] = $this->business;
        }

        if(!empty($this->branch)){
            $row[$this->branch_field] = $this->branch;
        }
        return $row;
    }

    protected function set_created_by($row)
    {
        if (!array_key_exists($this->created_by_field, $row))
        {
            $row[$this->created_by_field] = config_item("auth_user_id");
        }
        return $row;
    }

    protected function set_deleted_by($id)
    {
        $this->dbw->where($this->primary_key, $id);
        $this->db->update($this->table_name, [$this->deleted_by_field => config_item("auth_user_id")]);
    }

    protected function set_modified_by($row)
    {
        if (!array_key_exists($this->modified_by_field, $row))
        {
            $row[$this->modified_by_field] = config_item("auth_user_id");
        }

        return $row;
    }

    protected function set_modified_on($row)
    {
        if (!array_key_exists($this->modified_field, $row))
        {
            $row[$this->modified_field] = date('Y-m-d H:m:i');
        }

        return $row;
    }

    protected function set_selectable_fields()
    {
        if(!empty($this->selectable_fields)){
            $this->db->select($this->selectable_fields);
        }

    }

    protected function set_select_dates(){
        if(!empty($when = $this->input->get("when"))){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where($this->filterable_date_field.'>=',$dates['start']);
            $this->db->where($this->filterable_date_field.'<=',$dates['end']);
        }
    }

    protected function set_join(){
        $this->db->join('expenses','expense_type=type_key','left');
        $this->db->join('expense_categories cat','cat.category_key=expense_types.type_category','left');
        $this->db->join('accounting_accounts ac','ac.account_key=expenses.expense_debit_account','left');
    }

    protected function set_ownership_select(){
        $this->db->where($this->business_field,$this->business);
        $this->db->where($this->branch_field,$this->branch);
    }

    protected function publish_event(){
        publishEventFlash('data-table-refresh');
    }

    protected function set_limit_offset(){
        if(!empty($when = $this->input->get("when"))){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where($this->filterable_date_field.'>=',$dates['start']);
            $this->db->where($this->filterable_date_field.'<=',$dates['end']);
        }
    }

    function details($type){
        $this->db->select('*');
        $this->db->where('type_key',$type);
        $this->db->join('expenses exp','exp.expense_type=type_key','left');
        $this->db->select_sum('exp.expense_amount','type_spent');
        $this->db->select('DATE_FORMAT(type_created_on, "%m/%d/%Y") as type_date', FALSE);
        $query = $this->db->get("expense_types");
        return $query->num_rows()>0 ? $query->row() : false;
    }

    function types($when = ''){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('type_created_at >=',$dates['start']);
            $this->db->where('type_created_at <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->group_by('type_key');
        $this->db->select('DATE_FORMAT(type_created_on, "%m/%d/%Y") as type_date', FALSE);
        $this->db->join('expenses','expense_type=type_key','left');
        $this->db->join('expense_categories cat','cat.category_key=type_category','left');
        $this->db->select('SUM(DISTINCT expense_amount) as type_spent');
        $this->db->where('type_branch',$this->branch);
        $query = $this->db->get('expense_types');
        return $query->num_rows()>0 ? $query->result_array() : false;
    }


    function expendicture($type,$when = ''){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_on >=',$dates['start']);
            $this->db->where('expense_created_on <=',$dates['end']);
        }
        $this->db->join('users_details ud','ud.user_key=expense_created_by','left');
        $this->db->join('accounting_accounts ac','ac.account_key=expenses.expense_debit_account','left');
        $this->db->join('expense_types et','et.type_key=expense_type','left');
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS user');
        $this->db->select('DATE_FORMAT(expense_created_on, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->where('expense_type',$type);
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->result_array() : false;
    }

    function totalExpenditure($type){
        $this->db->select('SUM(DISTINCT expense_amount) as total');
        $this->db->where('expense_type',$type);
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->row()->total : 0;
    }


}