<?php

class Employees extends MY_Model {

 public function __construct() {
    parent::__construct();
    $this->branch = runningBranch()->branch_key;
    $this->business = runningBusiness()->business_key;
  }

  public function employeeUpdatePayroll($key,$salary,$taxes,$variables) {
    $this->db->trans_start();

    $this->db->where('user_key',$key);
    $this->db->update('users_details',$salary);

    $this->db->where('ev_employee_key',$key);
    $this->db->delete('employee_variables');
    if(!empty($variables)){
      foreach ($variables as $v => $variable) {
        $dataVariable['ev_variable_key'] = $variable['ev_variable_key'];
        $dataVariable['ev_overide_value'] = $variable['ev_overide_value'];
        $dataVariable['ev_employee_key'] = $key;
        $this->db->insert('employee_variables',$dataVariable);
      }
   }


     $this->db->where('et_employee_key',$key);
     $this->db->delete('employee_taxes');

   if(!empty($taxes)){
      foreach ($taxes as $t => $tax) {
        $dataTax['et_tax_key'] = $tax['et_tax_key'];
        $dataTax['et_overide_value'] = $tax['et_overide_value'];
        $dataTax['et_employee_key'] = $key;
        $this->db->insert('employee_taxes',$dataTax);
      }
    }

    $this->db->trans_complete();
    return $this->db->trans_status();
   }

  public function registerEmployee($primary,$security,$variables,$roles,$hlw) {
   $this->db->trans_start();

   $security['user_id'] = $this->unused_user_id();
   $security['created_at'] = date('Y-m-d H:i:s');
   $this->db->insert('users',$security);

   $primary['user_key'] = $security['user_id'];
   $this->db->insert('users_details',$primary,$hlw);

   if(!empty($roles)){
       foreach ($roles as $r => $role) {
           $roleData['action_id'] = $role['action_id'];
           $roleData['user_id'] = $security['user_id'];
           $roleData['branch'] = $security['user_branch'];
           $roleData['business'] = $security['user_business'];
           $this->db->insert('acl',$roleData);
       }
   }

   if(!empty($variables)){
       foreach ($variables as $v => $variable) {
           $dataVariable['ev_variable_key'] = $variable['ev_variable_key'];
           $dataVariable['ev_overide_value'] = $variable['ev_overide_value'];
           $dataVariable['ev_employee_key'] = $security['user_id'];
           $this->db->insert('employee_variables',$dataVariable);
       }
   }

   if(!empty($basic_salary = $this->input->get('basic_salary'))){
       $data['payroll_employee'] = $security['user_id'];
       $data['payroll_basic_salary'] = to_dollar(toNumber($this->input->get('basic_salary')));
       $data['payroll_gross_salary'] = to_dollar(toNumber($this->input->get('payroll_gross_salary')));
       $data['payroll_taxable_salary'] = to_dollar(toNumber($this->input->get('payroll_taxable_salary')));
       $data['payroll_net_salary'] = to_dollar(toNumber($this->input->get('payroll_net_salary')));
       $data['payroll_paye'] = to_dollar(toNumber($this->input->get('payroll_paye')));

       $sessions = !empty($_SESSION['allowances']) ? $_SESSION['allowances']: false;
       if(!empty($sessions)){
           $dedus = array();
           foreach ($sessions as $key => $session){
               $dedus['allowance_value'] = $session['allowance_value'];
               $dedus['allowance_value_amount'] = $session['allowance_value'];
               $dedus['allowance_key'] = $session['allowance_key'];
               $dedus['allowance_employee'] = $security['user_id'];
               $dedus['allowance_branch'] = $this->branch;
               $dedus['allowance_business'] = $this->business;
               $this->db->insert('employees_allowances',$dedus);
           }
       }

       $sessions = !empty($_SESSION['benefits']) ? $_SESSION['benefits']: false;
       if(!empty($sessions)){
           $dedus = array();
           foreach ($sessions as $key => $session){
               $dedus['benefit_value'] = $session['benefit_value'];
               $dedus['benefit_key'] = $session['benefit_key'];
               $dedus['benefit_employee'] = $security['user_id'];
               $dedus['benefit_branch'] = $this->branch;
               $dedus['benefit_business'] = $this->business;
               $this->db->insert('employees_benefits',$dedus);
           }
       }

       $sessions = !empty($_SESSION['insurance']) ? $_SESSION['insurance']: false;
       if(!empty($sessions)){
           $flag = $data['payroll_basic_salary'];
           $dedus = array();
           foreach ($sessions as $key => $session){
               $percent = $session['employee_cost']/100;
               $value = $data['payroll_gross_salary'] * $percent;
               $percentC = $session['company_cost']/100;
               $valueC = $data['payroll_gross_salary'] * $percentC;
               $flag = $flag - $value;
               $dedus['insurance_key'] = $session['insurer'];
               $dedus['insurance_employee'] = $security['user_id'];
               $dedus['employee_cost'] = $session['employee_cost'];
               $dedus['employee_cost_amount'] = $value;
               $dedus['company_cost'] = $session['company_cost'];
               $dedus['company_cost_amount'] = $valueC;
               $dedus['insurance_branch'] = $this->branch;
               $dedus['insurance_business'] = $this->business;
               $this->db->insert('employees_insurance',$dedus);
           }
       }

       $sessions = !empty($_SESSION['deductions']) ? $_SESSION['deductions']: false;
       if(!empty($sessions)){
           $deductions = 0;
           $dedus = array();
           foreach ($sessions as $key => $session){

               if($session['deduction_type'] == 'percent'){
                   $percent = $session['deduction_value']/100;
                   $dedus['deduction_employee'] = $security['user_id'];
                   $dedus['deduction_key'] = $session['deduction_key'];
                   $dedus['deduction_value'] = $session['deduction_value'];
                   $dedus['deduction_value_amount'] = $data['payroll_gross_salary'] * $percent;
               }else{
                   $dedus['deduction_employee'] = $security['user_id'];
                   $dedus['deduction_key'] = $session['deduction_key'];
                   $dedus['deduction_value'] = $session['deduction_value'];
                   $dedus['deduction_value_amount'] = $session['deduction_value'];
               }
               $dedus['deduction_branch'] = $this->branch;
               $dedus['deduction_business'] = $this->business;
               $this->db->insert('employees_deductions',$dedus);

           }
       }
       $data['payroll_branch'] = $this->branch;
       $data['payroll_business'] = $this->business;
       $this->db->insert('employees_payroll',$data);
   }

   $this->db->trans_complete();
   return $this->db->trans_status();
  }

  public function employees($when='') {
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            //$dates['start'] = $rawdates['start'];
           // $dates['end'] = $rawdates['end'];
            //$this->db->where('created_at >=',$dates['start']);
            //$this->db->where('created_at <=',$dates['end']);
        }
        $this->db->select('*');
        $this->db->order_by('id','DESC');
        //$this->db->where('user_branch',$this->branch);
        //$this->db->where('user_business',$this->business);
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS employee');
        $this->db->select('DATE_FORMAT(created_at, "%m/%d/%Y") as joined', FALSE);
        $query = $this->db->where('auth_level','8')
            //->join('users_details','users_details.user_key=users.user_id','left')
            ->join('users','users.user_id=users_details.user_key','left')
            ->join('user_roles','user_roles.role_user=users_details.user_key','left')
            ->join('departments','departments.department_key=users_details.user_department_key','left')
            ->join('acl_categories','acl_categories.category_key=users.user_title','left')
            ->get('users_details');
        return $query->result_array();
    }

  public function employee($key) {
      $this->db->where('user_business',$this->business);
      $query = $this->db->where('user_key',$key)
       //->join('users_details d','d.user_key=users.user_id','left')
       ->join('branches','branches.branch_key=users_details.details_branch','left')
       ->join('departments','departments.department_key=users_details.user_department_key','left')
       ->join('users','users.user_id=users_details.user_key','left')
       ->join('user_roles','user_roles.role_user=users_details.user_key','left')
       ->join('acl_categories','acl_categories.category_key=users.user_title','left')
       ->get('users_details' );
     return $query->num_rows()>0 ? $query->row() : FALSE;
   }

   //-------------------- WORK STATUS---------------------//

  public function employee_hlw($key){
        $this->db->join('hrm_holiday_schemes','hrm_holiday_schemes.hrm_holiday_schemes_key=users_details.holiday_scheme_key','left');
        $this->db->join('hrm_leave_schemes','hrm_leave_schemes.hrm_leave_schemes_key=users_details.leave_scheme_key','left');
        $this->db->join('hrm_workdays_schemes','hrm_workdays_schemes.hrm_workdays_scheme_key=users_details.workday_scheme_key','left');
        $query = $this->db->select('*')
            ->where('user_key',$key)
            ->get('users_details');
        return $query->row();
  }

  public function workstatusUpdate($userKey,$data){
        $this->db->where('details_business',$this->business);
      $this->db->where('details_branch',$this->branch);
        $this->db->limit(1)
            ->where('user_key=',$userKey)
            ->update('users_details',$data );
        return ($this->db->affected_rows()== 1)? TRUE :FALSE;
    }

  //---------------------Documents Function-------------//
   function documents($key){
       $query = $this->db->where('doc_user_key',$key)->get('user_documents');
       return ($query->num_rows()>0) ? $query->result_array() : false;
   }

  function educationLevel(){
      return $this->db->get('education_levels')->result_array();
  }

  public function createDocument($docs) {
     $docs['doc_business_key'] = $this->business;
     $docs['doc_branch_key'] = $this->branch;
      $docs['doc_key'] = $this->doc_key();
     $this->db->limit(1)
        ->insert('user_documents',$docs);
     return ($this->db->affected_rows()==1)? TRUE : FALSE;
  }

  public function documentRegister($docs) {
      $docs['doc_key'] = $this->doc_key();
      $this->db->limit(1)
            ->insert('user_documents',$docs);
       return ($this->db->affected_rows()==1)? TRUE : FALSE;
  }

    public function documentDelete($key) {
        $this->db->where('doc_branch_key',$this->branch);
        $this->db->where('doc_business_key',$this->business);
        $this->db->limit(1)
            ->where('doc_key=',$key)
            ->delete('user_documents');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    //------------------EDUCATION-----------//
    function employee_education($key){
        $query = $this->db->where('user_edu_user_key',$key)->get('user_education');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function education_employee($key=''){
        $this->db->join('users_details','users_details.user_key=user_education.user_edu_user_key','left');
        $query = $this->db->where('user_edu_user_key',$key)->get('user_education');
        return $query->num_rows() ? $query->result_array() : false;
    }

    public function updateEducation($edu) {
        $edu['user_edu_business_key'] = $this->business;
        $edu['user_edu_branch_key'] = $this->branch;
        $edu['user_edu_key'] = $this->education_key();
        $this->db->limit(1)
            ->insert('user_education',$edu);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function deleteEducation($key) {
        $this->db->where('user_edu_business_key',$this->business);
        $this->db->limit(1)
            ->where('user_edu_key=',$key)
            ->delete('user_education');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    //------------------FAMILY-----------//
    function employee_family($key){
        $query = $this->db->where('user_fam_user_key',$key)->get('user_family');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function family_employee($key=''){
        $this->db->join('users_details','users_details.user_key=user_family.user_fam_user_key','left');
        $query = $this->db->where('user_fam_user_key',$key)->get('user_family');
        return $query->num_rows() ? $query->result_array() : false;
    }

    public function updateFamily($family) {
        $family['user_fam_business'] = $this->business;
        $family['user_fam_branch'] = $this->branch;
        $family['user_fam_key'] = $this->family_key();
        $this->db->limit(1)
            ->insert('user_family',$family);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function familyMore($key) {
        $this->db->where('user_fam_branch',$this->branch);
        $this->db->where('user_fam_business',$this->business);
        $query = $this->db->select( '*' )
            ->where('user_fam_key',$key)->get('user_family');
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

    public function deleteFamily($key) {
        $this->db->where('user_fam_business',$this->business);
        $this->db->limit(1)
            ->where('user_fam_key=',$key)
            ->delete('user_family');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    //------------------EXPERIENCE-----------//

    function employee_experience($key){
        $query = $this->db->where('user_exp_user_key',$key)->get('users_experience');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function experience_employee($key=''){
        $this->db->join('users_details','users_details.user_key=users_experience.user_exp_user_key','left');
        $query = $this->db->where('user_exp_user_key',$key)->get('users_experience');
        return $query->num_rows() ? $query->result_array() : false;
    }

    public function updateExperience($exp) {
        $exp['user_exp_business'] = $this->business;
        $exp['user_exp_branch'] = $this->branch;
        $exp['user_exp_key'] = $this->experience_key();
        $this->db->limit(1)
            ->insert('users_experience',$exp);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function deleteExperience($key) {
        $this->db->where('user_exp_business',$this->business);
        $this->db->limit(1)
            ->where('user_exp_key=',$key)
            ->delete('users_experience');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    //------------------ATTENDANCE-----------//
    function employee_attendance($key){
        $query = $this->db->where('att_user_id',$key)->get('attendance');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function attendance_employee($key=''){
        $this->db->join('users_details','users_details.user_key=attendance.att_user_id','left');
        $query = $this->db->where('att_user_id',$key)->get('attendance');
        return $query->num_rows() ? $query->result_array() : false;
    }

    public function deleteAttendance($key) {
        $this->db->where('att_business',$this->business);
        $this->db->limit(1)
            ->where('att_key=',$key)
            ->delete('attendance');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    //------------------TASK-----------//
    function employee_task($key){
        $query = $this->db->where('task_employee_user_id',$key)->get('task_employee');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function task_employee($key=''){
        $this->db->join('users_details','users_details.user_key=task_employee.task_employee_user_id','left');
        $this->db->join('tasks','tasks.task_key=task_employee.task_employee_task_key','left');
        $query = $this->db->where('task_employee_user_id',$key)->get('task_employee');
        return $query->num_rows() ? $query->result_array() : false;
    }

    public function deleteTask($key) {
        $this->db->limit(1)
            ->where('task_employee_id=',$key)
            ->delete('task_employee');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    //------------------MEDICAL-----------//
    function employee_medical($key){
        $query = $this->db->where('medical_user_id',$key)->get('users_medical');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function medical_employee($key=''){
        $this->db->join('users_details','users_details.user_key=users_medical.medical_user_id','left');
        $query = $this->db->where('medical_user_id',$key)->get('users_medical');
        return $query->num_rows() ? $query->result_array() : false;
    }

    public function updateMedical($medical) {
        $medical['medical_business'] = $this->business;
        $medical['medical_branch'] = $this->branch;
        $medical['medical_key'] = $this->medicalKey();
        $this->db->limit(1)
            ->insert('users_medical',$medical);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function deleteMedical($key) {
        $this->db->where('medical_business',$this->business);
        $this->db->where('medical_branch',$this->branch);
        $this->db->limit(1)
            ->where('medical_key=',$key)
            ->delete('users_medical');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    //------------------CONTACT-----------//
    function employee_contact($key){
        $query = $this->db->where('user_key',$key)->get('users_details');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }



  public function employeeDetails($key) {
       $this->db->where('user_key',$key);
       $this->db->where('details_business',$this->business);
       $query = $this->db->get( 'users_details' );
      return $query->num_rows()>0 ? $query->row() : FALSE;
    }

  public function employeeRoles($key) {
       $this->db->where('role_user',$key);
       $this->db->where('role_branch',$this->branch);
       $this->db->where('role_business',$this->business);
       $query = $this->db->get( 'user_roles' );
      return $query->num_rows()>0 ? $query->row() : FALSE;
    }

  public function employeeUpdateSecurity($key,$details) {
      $this->db->where('user_id',$key);
      //$this->db->where('user_branch',$this->branch);
      $this->db->where('user_business',$this->business);
      $this->db->update('users',$details);
     return $this->db->affected_rows();
    }

  public function employeeUpdatePrimary($key,$details) {
 if($this->employeeDetails($key)){
   $this->db->where('user_key',$key);
   $this->db->where('details_business',$this->business);
   $this->db->update('users_details',$details);
 }else{
   $details['user_key'] = $key;
   $details['details_branch'] = $this->branch;
   $details['details_business'] = $this->business;
   $this->db->insert('users_details',$details);
 }
  return $this->db->affected_rows();
}

  public function employeeUpdateRoles($key,$roles) {
 if($this->employeeRoles($key)){
   $this->db->where('role_user',$key);
   $this->db->where('role_branch',$this->branch);
   $this->db->where('role_business',$this->business);
   $this->db->update('user_roles',$roles);
 }else{
   $roles['role_user'] = $key;
   $roles['role_branch'] = $this->branch;
   $roles['role_business'] = $this->business;
   $this->db->insert('user_roles',$roles);
 }

if($this->db->affected_rows()>0){
    return TRUE;
  }else{
    return FALSE;
}

}

  public function employee_delete($key) {
      $this->db->trans_start();
      $this->db->where('user_id',$key)
          ->delete( 'users' );
      $this->db->where('user_key',$key)
          ->delete( 'users_details' );
      $this->db->trans_complete();
      if($this->db->trans_status() == true){
          return true;
      }else{
          return  false;
      }
 }

 public function adddept($key,$details) {
   $details['id_key'] = $this->employees_internal_depts_key();
     $details['id_branch'] = $this->branch;
     $details['id_business'] = $this->business;
     $details['id_actions'] = optionActionsSingle($details['id_key']);
     $this->db->insert('employees_internal_depts',$details);
    return $this->db->affected_rows();
 }

 function employee_depts($employee){
   $this->db->where('id_business',$this->business);
   $this->db->where('id_branch',$this->branch);
   $this->db->where('id_employee',$employee);
   $query = $this->db->get('employees_internal_depts');
   return $query->num_rows()>0 ? $query->result_array() : false;
 }

 function employeeinternaldeptupdate($employee,$dept,$data){
   $this->db->where('id_business',$this->business);
   $this->db->where('id_branch',$this->branch);
   $this->db->where('id_employee',$employee);
   $this->db->where('id_key',$dept);
   $this->db->update('employees_internal_depts',$data);
   return $this->db->affected_rows();
 }

 function employeedeptdetails($employee,$dept){
   $this->db->where('id_business',$this->business);
   $this->db->where('id_branch',$this->branch);
   $this->db->where('id_employee',$employee);
   $this->db->where('id_key',$dept);
   $query = $this->db->get('employees_internal_depts');
   return $query->num_rows()>0 ? $query->row() : false;
 }

function employeedeptspaidtotal($employee){
   $this->db->select_sum('dp_amount','total');
   $this->db->where('dp_business',$this->business);
   $this->db->where('dp_branch',$this->branch);
   $query = $this->db->where('dp_employee',$employee)
   ->get( 'employees_internal_depts_paid' );
   return $query->num_rows()>0 ? $query->row()->total : 0;
}

function employeedeptspaid($employee){
   $this->db->where('dp_business',$this->business);
   $this->db->where('dp_branch',$this->branch);
   $query = $this->db->where('dp_employee',$employee)
   ->get( 'employees_internal_depts_paid' );
   return $query->num_rows()>0 ? $query->result_array(): false;
}

public function deletedept($key) {
          $this->db->where('id_business',$this->business);
          $this->db->where('id_branch',$this->branch);
          $this->db->where('id_key',$key)
            ->delete( 'employees_internal_depts' );
        return $this->db->affected_rows();
      }

public function employeetotaldept($employee) {
    $this->db->select_sum('id_amount','total');
   $this->db->where('id_business',$this->business);
   $this->db->where('id_branch',$this->branch);
   $query = $this->db->where('id_employee',$employee)
   ->get( 'employees_internal_depts' );
   return $query->num_rows()>0 ? $query->row()->total : 0;
 }

public function employeemonthdept($employee) {
    $dates = month_start_end(date('Y-m-d'));
    $this->db->select_sum('id_amount','total');
    $this->db->where('id_date >=',$dates['start']);
    $this->db->where('id_date <=',$dates['end']);
    $this->db->where('id_business',$this->business);
    $this->db->where('id_branch',$this->branch);
    $query = $this->db->where('id_employee',$employee)
    ->get( 'employees_internal_depts' );
    return $query->num_rows()>0 ? $query->row()->total : 0;
  }

function employeesallaryadvancepaid($employee){
     $this->db->where('pad_business',$this->business);
     $this->db->where('pad_branch',$this->branch);
     $query = $this->db->where('pad_employee',$employee)
     ->get( 'employees_sallary_advances_paid' );
     return $query->num_rows()>0 ? $query->result_array(): false;
  }

  function employeesallaryadvancepaidtotal($employee){
     $this->db->select_sum('dp_amount','total');
     $this->db->where('dp_business',$this->business);
     $this->db->where('dp_branch',$this->branch);
     $query = $this->db->where('dp_employee',$employee)
     ->get( 'employees_internal_depts_paid' );
     return $query->num_rows()>0 ? $query->row()->total : 0;
  }

  function employeesallaryadvanceupdate($employee,$dept,$data){
    $this->db->where('ad_business',$this->business);
    $this->db->where('ad_branch',$this->branch);
    $this->db->where('ad_employee',$employee);
    $this->db->where('ad_key',$dept);
    $this->db->update('employees_sallary_advances',$data);
    return $this->db->affected_rows();
  }

  function employeesallaryadvancedetails($employee,$dept){
    $this->db->where('ad_business',$this->business);
    $this->db->where('ad_branch',$this->branch);
    $this->db->where('ad_employee',$employee);
    $this->db->where('ad_key',$dept);
    $query = $this->db->get('employees_sallary_advances');
    return $query->num_rows()>0 ? $query->row() : false;
  }

public function deletesallaryadvance($key) {
            $this->db->where('ad_business',$this->business);
            $this->db->where('ad_branch',$this->branch);
            $this->db->where('ad_key',$key)
              ->delete( 'employees_sallary_advances' );
          return $this->db->affected_rows();
        }

public function employeetotalsallaryadvace($employee) {
      $this->db->select_sum('ad_amount','total');
     $this->db->where('ad_business',$this->business);
     $this->db->where('ad_branch',$this->branch);
     $query = $this->db->where('ad_employee',$employee)
     ->get( 'employees_sallary_advances' );
     return $query->num_rows()>0 ? $query->row()->total : 0;
   }

public function employeemonthsallaryadvance($employee) {
     $dates = month_start_end(date('Y-m-d'));
     $this->db->select_sum('ad_amount','total');
     $this->db->where('ad_date >=',$dates['start']);
     $this->db->where('ad_date <=',$dates['end']);
     $this->db->where('ad_business',$this->business);
     $this->db->where('ad_branch',$this->branch);
     $query = $this->db->where('ad_employee',$employee)
     ->get( 'employees_sallary_advances' );
     return $query->num_rows()>0 ? $query->row()->total : 0;
   }

public function addsallaryadvance($key,$details) {
  $details['ad_key'] = $this->employees_sallary_advances_key();
   $details['ad_branch'] = $this->branch;
   $details['ad_business'] = $this->business;
   $details['ad_actions'] = optionActionsSingle($details['ad_key']);
   $this->db->insert('employees_sallary_advances',$details);
  return $this->db->affected_rows();
}

function employeesallaryadvances($employee){
 $this->db->where('ad_business',$this->business);
 $this->db->where('ad_branch',$this->branch);
 $this->db->where('ad_employee',$employee);
 $query = $this->db->get('employees_sallary_advances');
 return $query->num_rows()>0 ? $query->result_array() : false;
}

function updateEmployeeStatus($emp,$data){
    $this->db->where('user_id',$emp);
    $this->db->update('users',$data);
    if($this->db->affected_rows()>0){
        return true;
    }
    return false;
}

public function unused_user_id()
    {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'user_id', $random_unique_int )
            ->get_where( 'users');

        if( $query->num_rows() > 0 )
        {
            $query->free_result();
            // If the random user_id is already in use, try again
            return $this->unused_user_id();
        }

        return $random_unique_int;
    }

    function employees_internal_depts_key(){
  // Create a random user id between 1200 and 4294967295
  $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

  // Make sure the random user_id isn't already in use
  $query = $this->db->where( 'id_key', $random_unique_int )
      ->get_where( 'employees_internal_depts');

  if( $query->num_rows() > 0 )
  {
      $query->free_result();
      // If the random user_id is already in use, try again
      return $this->employees_internal_depts_key();
  }

  return $random_unique_int;
}

    function employees_sallary_advances_key(){
  // Create a random user id between 1200 and 4294967295
  $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

  // Make sure the random user_id isn't already in use
  $query = $this->db->where( 'ad_key', $random_unique_int )
      ->get_where( 'employees_sallary_advances');

  if( $query->num_rows() > 0 )
  {
      $query->free_result();
      // If the random user_id is already in use, try again
      return $this->employees_sallary_advances_key();
  }

  return $random_unique_int;
}

    public function doc_key() {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'doc_key', $random_unique_int )
            ->get_where( 'user_documents');

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->doc_key();
        }

        return $random_unique_int;
    }

    public function education_key() {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'user_edu_key', $random_unique_int )
            ->get_where( 'user_education');
        if( $query->num_rows() > 0 ) {
            $query->free_result();
            // If the random user_id is already in use, try again
            return $this->education_key();
        }
        return $random_unique_int;
    }

    public function family_key() {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'user_fam_key', $random_unique_int )
            ->get_where( 'user_family');
        if( $query->num_rows() > 0 ) {
            $query->free_result();
            // If the random user_id is already in use, try again
            return $this->family_key();
        }
        return $random_unique_int;
    }

    public function experience_key() {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'user_exp_key', $random_unique_int )
            ->get_where( 'users_experience');
        if( $query->num_rows() > 0 ) {
            $query->free_result();
            // If the random user_id is already in use, try again
            return $this->experience_key();
        }
        return $random_unique_int;
    }

    public function medicalKey() {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'medical_key', $random_unique_int )
            ->get_where( 'users_medical');
        if( $query->num_rows() > 0 ) {
            $query->free_result();
            // If the random user_id is already in use, try again
            return $this->medicalKey();
        }
        return $random_unique_int;
    }

}