<?php

class WorkDaySchemes extends MY_Model {
    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function allWorkDaySchemes() {
        $this->db->order_by('hrm_workdays_scheme_id');
        $this->db->where('hrm_workdays_scheme_business_key',$this->business)
            ->join('business','business.business_key=hrm_workdays_schemes.hrm_workdays_scheme_business_key','left')
            ->join('users_details','users_details.user_key=hrm_workdays_schemes.hrm_workdays_scheme_created_by','left');
        $query = $this->db->get('hrm_workdays_schemes');
        return $query->result_array();
    }

    public function allWorkDaySchemesbox() {
        $this->db->order_by('hrm_workdays_scheme_id');
        $this->db->where('hrm_workdays_scheme_business_key',$this->business)
            ->join('business','business.business_key=hrm_workdays_schemes.hrm_workdays_scheme_business_key','left')
            ->join('users_details','users_details.user_key=hrm_workdays_schemes.hrm_workdays_scheme_created_by','left');
        $query = $this->db->get('hrm_workdays_schemes');
        return $query->result_array();
    }

    function day_scheme($key){
        $query = $this->db->where('hrm_workdays_scheme_days_workdays_schemes_key',$key)->get('hrm_workdays_schemes_days');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    function create_workday_scheme($data){
        $data['hrm_workdays_scheme_key'] = $this->unused_workday_scheme();
        $data['hrm_workdays_scheme_business_key'] = $this->business;
        $this->db->limit(1)
            ->insert('hrm_workdays_schemes',$data);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function workdayU($key) {
        $this->db->where('hrm_workdays_scheme_business_key',$this->business)
             ->join('users_details','users_details.user_key=hrm_workdays_schemes.hrm_workdays_scheme_created_by','left');
        $query = $this->db->select( '*' )
            ->where('hrm_workdays_scheme_key',$key)->get('hrm_workdays_schemes');
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

    public function workdayUpdate($key,$data){
        $this->db->where('hrm_workdays_scheme_business_key',$this->business);
        $this->db->limit(1)
            ->where('hrm_workdays_scheme_key=',$key)
            ->update('hrm_workdays_schemes',$data );
        return ($this->db->affected_rows()== 1)? TRUE :FALSE;
    }

    public function deleteWorkday($key) {
        $this->db->where('hrm_workdays_scheme_business_key',$this->business);
        $this->db->limit(1)
            ->where('hrm_workdays_scheme_key=',$key)
            ->delete('hrm_workdays_schemes');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }




          //--------- Workday Scheme Day-----------//
    public function workdaySchemeDay() {
        $this->db->order_by('hrm_workdays_schemes_days_id');
        $this->db->where('hrm_workdays_schemes_days_business_key',$this->business)
            ->join('hrm_workdays_schemes','hrm_workdays_schemes.hrm_workdays_scheme_key=hrm_workdays_schemes_days.hrm_workdays_scheme_days_workdays_schemes_key','left')
            ->join('business','business.business_key=hrm_workdays_schemes_days.hrm_workdays_schemes_days_business_key','left');
        $query = $this->db->get('hrm_workdays_schemes_days');
        return $query->result_array();
    }

    function create_workday_scheme_day($data){
        $data['hrm_workdays_schemes_days_key'] = $this->unused_workday_scheme_day();
        $data['hrm_workdays_schemes_days_business_key'] = $this->business;
        $this->db->limit(1)
            ->insert('hrm_workdays_schemes_days',$data);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function workdaySchemeU($key) {
        $this->db->where('hrm_workdays_schemes_days_business_key',$this->business);
        $this->db->join('hrm_workdays_schemes','hrm_workdays_schemes.hrm_workdays_scheme_key=hrm_workdays_schemes_days.hrm_workdays_scheme_days_workdays_schemes_key','left');
        $query = $this->db->select( '*' )
            ->where('hrm_workdays_schemes_days_key',$key)->get('hrm_workdays_schemes_days');
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

    public function workdaySchemeUpdate($key,$data){
        $this->db->where('hrm_workdays_schemes_days_business_key',$this->business);
        $this->db->limit(1)
            ->where('hrm_workdays_schemes_days_key=',$key)
            ->update('hrm_workdays_schemes_days',$data);
        return ($this->db->affected_rows()== 1)? TRUE :FALSE;
    }

    public function deleteWorkdaySchemeDay($key) {
        $this->db->where('hrm_workdays_schemes_days_business_key',$this->business);
        $this->db->limit(1)
            ->where('hrm_workdays_schemes_days_key=',$key)
            ->delete('hrm_workdays_schemes_days');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }



    public function unused_workday_scheme(){
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        $query = $this->db->where( 'hrm_workdays_scheme_key', $random_unique_int )->get_where( 'hrm_workdays_schemes');
        if( $query->num_rows() > 0 )
        {
            $query->free_result();
            return $this->unused_workday_scheme();
        }
        return $random_unique_int;
    }

    public function unused_workday_scheme_day(){
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        $query = $this->db->where( 'hrm_workdays_schemes_days_key', $random_unique_int )->get_where( 'hrm_workdays_schemes_days');
        if( $query->num_rows() > 0 )
        {
            $query->free_result();
            return $this->unused_workday_scheme_day();
        }
        return $random_unique_int;
    }

}