<?php


class AttendanceModel extends MY_Model {
    public $branch;
    public $business;

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function attendance() {
        $this->db->order_by('att_id');
        //$this->db->where('att_branch',$this->branch);
        $this->db->where('att_business',$this->business);
        $this->db->where('date_format(att_date,"%Y-%m-%d")', 'CURDATE()', FALSE);
        $this->db->join('business','business.business_key=attendance.att_business','left')
                 ->join('users_details','users_details.user_key=attendance.att_user_id');
        $query = $this->db->get( 'attendance' );
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    public function createAttendance($data) {
        $data['att_key'] = $this->attendanceKey();
        $data['att_business'] = $this->business;
        $this->db->limit(1)
            ->insert('attendance',$data);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function select_one_attendance($key){
        $this->db->join('business','business.business_key=attendance.att_business','left')
            ->join('users_details','users_details.user_key=attendance.att_user_id');
        $query = $this->db->where('att_key', $key)->from('attendance')->get();
        return $query->row();
    }

    public function attendanceUpdate($key,$data){
        $this->db->where('att_business',$this->business);
        $this->db->limit(1)
            ->where('att_key=',$key)
            ->update('attendance',$data );
        return ($this->db->affected_rows()== 1)? TRUE :FALSE;
    }


    public function show_all_data() {
        $this->db->select('*');
        $this->db->where('att_business',$this->business);
        $this->db->join('business','business.business_key=attendance.att_business','left')
            ->join('users_details','users_details.user_key=attendance.att_user_id');
        $this->db->from('attendance');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }

    public function show_data_by_id($id) {
        $condition = "att_user_id =" . "'" . $id . "'";
        $this->db->select('*');
        $this->db->where('att_business',$this->business);
        $this->db->join('business','business.business_key=attendance.att_business','left')
            ->join('users_details','users_details.user_key=attendance.att_user_id');
        $this->db->from('attendance');
        $this->db->where($condition);
        $this->db->limit(1);
        $query = $this->db->get();

        if ($query->num_rows() == 1) {
            return $query->result();
        } else {
            return false;
        }
    }

    public function show_data_by_date($date) {
        $condition = "att_date =" . "'" . $date . "'";
        $this->db->select('*');
        $this->db->where('att_business',$this->business);
        $this->db->join('business','business.business_key=attendance.att_business','left')
            ->join('users_details','users_details.user_key=attendance.att_user_id');
        $this->db->from('attendance');
        $this->db->where($condition);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }

    public function show_data_by_date_range($data) {
        $condition = "att_date BETWEEN " . "'" . $data['date1'] . "'" . " AND " . "'" . $data['date2'] . "'";
        $this->db->select('*');
        $this->db->where('att_business',$this->business);
        $this->db->join('business','business.business_key=attendance.att_business','left')
            ->join('users_details','users_details.user_key=attendance.att_user_id');
        $this->db->from('attendance');
        $this->db->where($condition);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }

    public function attendanceKey(){
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        $query = $this->db->where( 'att_key', $random_unique_int )->get_where('attendance');
        if( $query->num_rows() > 0 ) {
            $query->free_result();
            return $this->attendanceKey();
        }
        return $random_unique_int;
    }

}