<?php

class DepartmentsModel extends MY_Model {

    public $branch;
    public $business;

 public function __construct() {
     parent::__construct();
     $this->branch = runningBranch()->branch_key;
     $this->business = runningBusiness()->business_key;
    }

  public function departments() {
    $this->db->order_by('department_id');
    $this->db->where('department_branch',$this->branch);
    $this->db->where('department_business',$this->business);
    $this->db->join('users_details','users_details.user_key=departments.department_hod','left');
    $query = $this->db->get( 'departments' );
    return $query->num_rows()>0 ? $query->result_array() : FALSE;
   }

 public function department($key) {
   $this->db->where('department_branch',$this->branch);
   $this->db->where('department_business',$this->business);
  // $this->db->join('users_details','users_details.user_key=departments.department_hod','left');
      $query = $this->db->select( '*' )
        ->where('department_key',$key)->get('departments');
    return ($query->num_rows()>0)? $query->row() : FALSE;
  }

  public function departmentUpdate($key,$data) {
    $this->db->where('department_branch',$this->branch);
    $this->db->where('department_business',$this->business);
      $this->db->limit(1)
        ->where('department_key=',$key)
        ->update('departments',$data );
      return ($this->db->affected_rows()== 1)? TRUE :FALSE;
  }

  public function departmentRegister($department) {
    $department['department_key'] = $this->department_key();
    $department['department_branch'] = $this->branch;
    $department['department_business'] = $this->business;
      $this->db->limit(1)
        ->insert('departments',$department);
      return ($this->db->affected_rows()==1)? TRUE : FALSE;
  }

  public function deleteDepartment($key) {
    $this->db->where('department_branch',$this->branch);
    $this->db->where('department_business',$this->business);
      $this->db->limit(1)
        ->where('department_key=',$key)
        ->delete('departments');
      return ($this->db->affected_rows()==1)? TRUE :FALSE;
  }

  public function department_update($key,$data) {
      $this->db->limit(1)
        ->where('department_key',$key)
        ->update('departments',$data );
      return ($this->db->affected_rows()==1)? TRUE : FALSE;
  }

    function department_more($key){
        return $this->db->where('department_key',$key)->get('departments')->row();
    }

    function user_department($key){
        $query = $this->db->where('user_department_key',$key)->get('users_details');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

 public function department_key() {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'department_key', $random_unique_int )
            ->get_where( 'departments');

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->department_key();
        }

        return $random_unique_int;
    }

}
