<?php


class DeviceModel extends MY_Model {
    public $branch;
    public $business;

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function devices() {
        $this->db->order_by('device_id');
        //$this->db->where('device_branch',$this->branch);
        $this->db->where('device_business',$this->business);
        $this->db->join('business','business.business_key=devicefinger.device_business','left');
        $query = $this->db->get( 'devicefinger' );
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    public function createDevice($data) {
        $data['device_key'] = $this->deviceKey();
        $data['device_business'] = $this->business;
        $this->db->limit(1)
            ->insert('devicefinger',$data);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function select_one_device($key){
        $query = $this->db->where('device_key', $key)->from('devicefinger')->get();
        return $query->row();
    }

    public function deviceUpdate($key,$data){
        $this->db->where('device_business',$this->business);
        $this->db->limit(1)
            ->where('device_key=',$key)
            ->update('devicefinger',$data );
        return ($this->db->affected_rows()== 1)? TRUE :FALSE;
    }

    function activateDevice($device,$data){
        $this->db->where('device_key',$device);
        $this->db->update('devicefinger',$data);
        if($this->db->affected_rows()>0){
            return true;
        }
        return false;
    }

    function deactivateDevice($device,$data){
        $this->db->where('device_key',$device);
        $this->db->update('devicefinger',$data);
        if($this->db->affected_rows()>0){
            return true;
        }
        return false;
    }

    function putonlineDevice($device,$data){
        $this->db->where('device_key',$device);
        $this->db->update('devicefinger',$data);
        if($this->db->affected_rows()>0){
            return true;
        }
        return false;
    }

    function putofflineDevice($device,$data){
        $data['device_mode'] = 'Inactive';
        $this->db->where('device_key',$device);
        $this->db->update('devicefinger',$data);
        if($this->db->affected_rows()>0){
            return true;
        }
        return false;
    }

    public function deleteDevice($key) {
        $this->db->where('device_business',$this->business);
        $this->db->limit(1)
            ->where('device_key=',$key)
            ->delete('devicefinger');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }
    public function deviceKey(){
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        $query = $this->db->where( 'device_key', $random_unique_int )->get_where( 'devicefinger');
        if( $query->num_rows() > 0 ) {
            $query->free_result();
            return $this->deviceKey();
        }
        return $random_unique_int;
    }

}