<?php

class HolidaySchemesModel extends MY_Model {

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function holidaySchemes() {
        $this->db->order_by('hrm_holiday_schems_id');
        $this->db->where('hrm_holiday_schemes_business_key',$this->business)
            ->join('business','business.business_key=hrm_holiday_schemes.hrm_holiday_schemes_business_key','left')
            ->join('users_details','users_details.user_key=hrm_holiday_schemes.hrm_holiday_schemes_created_by','left');
        $query = $this->db->get('hrm_holiday_schemes');
        return $query->result_array();
    }

    public function create_holiday_scheme($data) {
        $data['hrm_holiday_schemes_key'] = $this->unused_holiday_scheme();
        $data['hrm_holiday_schemes_business_key'] = $this->business;
        $this->db->limit(1)
            ->insert('hrm_holiday_schemes',$data);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function holidayU($key) {
        $this->db->where('hrm_holiday_schemes_business_key',$this->business);
        $query = $this->db->select( '*' )
            ->where('hrm_holiday_schemes_key',$key)->get('hrm_holiday_schemes');
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

    public function schemeUpdate($key,$data){
        $this->db->where('hrm_holiday_schemes_business_key',$this->business);
        $this->db->limit(1)
            ->where('hrm_holiday_schemes_key=',$key)
            ->update('hrm_holiday_schemes',$data );
        return ($this->db->affected_rows()== 1)? TRUE :FALSE;
    }




    //--------------------Holiday Here--------------//
    public function holidaySchemeDates() {
        $this->db->order_by('hrm_holiday_schemes_dates_id');
        $this->db->join('business','business.business_key=hrm_holiday_schemes_dates.hrm_holiday_schemes_dates_business_key','left');
        $this->db->join('hrm_holiday_schemes','hrm_holiday_schemes.hrm_holiday_schemes_key=hrm_holiday_schemes_dates.hrm_holiday_schemes_dates_holiday_schemes_key','left');
        $this->db->join('users_details','users_details.user_key=hrm_holiday_schemes_dates.hrm_holiday_schemes_dates_created_by','left');
        $this->db->where('hrm_holiday_schemes_dates_business_key',$this->business);
        $query = $this->db->get('hrm_holiday_schemes_dates');
        return $query->result_array();
    }

    function holiday_dates($key){
        $query = $this->db->where('hrm_holiday_schemes_dates_holiday_schemes_key',$key)->get('hrm_holiday_schemes_dates');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }


    public function create_holiday_scheme_date($data) {
        $data['hrm_holiday_schemes_key'] = $this->unused_holiday_scheme_date();
        $data['hrm_holiday_schemes_dates_business_key'] = $this->business;
        $this->db->limit(1)
            ->insert('hrm_holiday_schemes_dates',$data);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function holidaySchemeU($key) {
        $this->db->where('hrm_holiday_schemes_dates_business_key',$this->business);
        $this->db->join('hrm_holiday_schemes','hrm_holiday_schemes.hrm_holiday_schemes_key=hrm_holiday_schemes_dates.hrm_holiday_schemes_dates_holiday_schemes_key','left');
        $query = $this->db->select( '*' )
            ->where('hrm_holiday_schemes_dates_key',$key)->get('hrm_holiday_schemes_dates');
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

    public function holidayUpdate($key,$data){
        $this->db->where('hrm_holiday_schemes_dates_business_key',$this->business);
        $this->db->limit(1)
            ->where('hrm_holiday_schemes_dates_key=',$key)
            ->update('hrm_holiday_schemes_dates',$data );
        return ($this->db->affected_rows()== 1)? TRUE :FALSE;
    }


    public function leaveSchemes() {
        $this->db->order_by('hrm_leave_schemes_id');
        $this->db->where('hrm_leave_schemes_business_key',$this->business)
            ->join('business','business.business_key=hrm_leave_schemes.hrm_leave_schemes_business_key','left');
        $query = $this->db->get('hrm_leave_schemes');
        return $query->result_array();
    }

    public function unused_holiday_scheme(){
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        $query = $this->db->where( 'hrm_holiday_schemes_key', $random_unique_int )->get_where( 'hrm_holiday_schemes');
        if( $query->num_rows() > 0 )
        {
            $query->free_result();
            return $this->unused_holiday_scheme();
        }
        return $random_unique_int;
    }

    public function unused_holiday_scheme_date(){
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        $query = $this->db->where( 'hrm_holiday_schemes_dates_key', $random_unique_int )->get_where( 'hrm_holiday_schemes_dates');
        if( $query->num_rows() > 0 ) {
            $query->free_result();
            return $this->unused_holiday_scheme_date();
        }
        return $random_unique_int;
    }

}