<?php

class LeaveModel extends MY_Model {
    public $branch;
    public $business;

 public function __construct() {
     parent::__construct();
     $this->branch = runningBranch()->branch_key;
     $this->business = runningBusiness()->business_key;
    }

    public function leaves() {
        $this->db->order_by('hrm_leave_schemes_id');
        $this->db->where('hrm_leave_schemes_business_key',$this->business)
            ->join('business','business.business_key=hrm_leave_schemes.hrm_leave_schemes_business_key','left');
        $query = $this->db->get('hrm_leave_schemes');
        return $query->result_array();
    }

    public function create_leave($data) {
        $data['hrm_leave_schemes_key'] = $this->unused_leave_key();
        $data['hrm_leave_schemes_business_key'] = $this->business;
        $this->db->limit(1)
            ->insert('hrm_leave_schemes',$data);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function leaveUpdate($key,$data){
        $this->db->where('hrm_leave_schemes_business_key',$this->business);
        $this->db->limit(1)
            ->where('hrm_leave_schemes_key=',$key)
            ->update('hrm_leave_schemes',$data );
        return ($this->db->affected_rows()== 1)? TRUE :FALSE;
    }

    public function leaveU($key) {
        $this->db->where('hrm_leave_schemes_business_key',$this->business);
        $query = $this->db->select( '*' )
            ->where('hrm_leave_schemes_key',$key)->get('hrm_leave_schemes');
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

    public function deleteLeave($key) {
        $this->db->where('hrm_leave_schemes_business_key',$this->business);
        $this->db->limit(1)
            ->where('hrm_leave_schemes_key=',$key)
            ->delete('hrm_leave_schemes');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

        //-----------Leave scheme Here-------------//
    public function leaveScheme() {
        $this->db->order_by('hrm_leave_schemes_titles_id');
        $this->db->where('hrm_leave_schemes_titles_business_key',$this->business)
            ->join('business','business.business_key=hrm_leave_schemes_titles.hrm_leave_schemes_titles_business_key','left')
            ->join('hrm_leave_schemes','hrm_leave_schemes.hrm_leave_schemes_key=hrm_leave_schemes_titles.hrm_leave_schemes_titles_leave_schemes_key','left');
        $query = $this->db->get('hrm_leave_schemes_titles');
        return $query->result_array();
    }

    function leave_dates($key){
        $query = $this->db->where('hrm_leave_schemes_titles_leave_schemes_key',$key)->get('hrm_leave_schemes_titles');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    function create_leaveScheme($data){
        $data['hrm_leave_schemes_titles_key'] = $this->unused_leave_scheme_key();
        $data['hrm_leave_schemes_titles_business_key'] = $this->business;
        $this->db->limit(1)
            ->insert('hrm_leave_schemes_titles',$data);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function leaveSchemeUpdate($key,$data){
        $this->db->where('hrm_leave_schemes_titles_business_key',$this->business);
        $this->db->limit(1)
            ->where('hrm_leave_schemes_titles_key=',$key)
            ->update('hrm_leave_schemes_titles',$data );
        return ($this->db->affected_rows()== 1)? TRUE :FALSE;
    }

    public function leaveSchemeU($key) {
        $this->db->where('hrm_leave_schemes_titles_business_key',$this->business);
        $this->db->join('hrm_leave_schemes','hrm_leave_schemes.hrm_leave_schemes_key=hrm_leave_schemes_titles.hrm_leave_schemes_titles_leave_schemes_key','left');
        $query = $this->db->select( '*' )
            ->where('hrm_leave_schemes_titles_key',$key)->get('hrm_leave_schemes_titles');
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

    public function deleteLeaveScheme($key) {
        $this->db->where('hrm_leave_schemes_titles_business_key',$this->business);
        $this->db->limit(1)
            ->where('hrm_leave_schemes_titles_key=',$key)
            ->delete('hrm_leave_schemes_titles');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

   //----------Leave request here------------//

    public function leavesrequest() {
        $this->db->order_by('leave_request_id');
        $this->db->where('leave_request_business_key',$this->business)
            ->join('business','business.business_key=hrm_leave_request.leave_request_business_key','left')
            ->join('users_details','users_details.user_key=hrm_leave_request.leave_request_user_id','left')
            ->join('hrm_leave_schemes_titles','hrm_leave_schemes_titles.hrm_leave_schemes_titles_key=hrm_leave_request.leave_request_leave_key','left');
        $query = $this->db->get('hrm_leave_request');
        return $query->result_array();
    }

    function create_leaveRequest($data){
        $data['leave_request_key'] = $this->unused_request_key();
        $data['leave_request_business_key'] = $this->business;
        $this->db->limit(1)
            ->insert('hrm_leave_request',$data);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function leaveRequestU($key) {
        $this->db->where('leave_request_business_key',$this->business);
        $this->db->join('users_details','users_details.user_key=hrm_leave_request.leave_request_user_id','left');
        $query = $this->db->select( '*' )
            ->where('leave_request_key',$key)->get('hrm_leave_request');
        return ($query->num_rows()>0)? $query->row() : FALSE;
    }

    function updateRequest($leave,$data){
        $this->db->where('leave_request_key',$leave);
        $this->db->update('hrm_leave_request',$data);
        if($this->db->affected_rows()>0){
            return true;
        }
        return false;
    }

    function rejectRequest($key){
        $data['leave_request_business_key'] = $this->business;
        $data['leave_request_status'] = 'Rejected';
        //$data['leave_request_processed_by'] = $this->auth_user_id;
        $this->db->where('leave_request_key',$key);
        $this->db->update('hrm_leave_request',$data);
        if($this->db->affected_rows()>0){
            return true;
        }
        return false;
    }

    public function deleteLeaveRequest($key) {
        $this->db->where('leave_request_business_key',$this->business);
        $this->db->limit(1)
            ->where('leave_request_key=',$key)
            ->delete('hrm_leave_request');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    public function unused_leave_key(){
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        $query = $this->db->where( 'hrm_leave_schemes_key', $random_unique_int )->get_where( 'hrm_leave_schemes');
        if( $query->num_rows() > 0 ) {
            $query->free_result();
            return $this->unused_leave_key();
        }
        return $random_unique_int;
    }

    public function unused_leave_scheme_key(){
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        $query = $this->db->where( 'hrm_leave_schemes_titles_key', $random_unique_int )->get_where( 'hrm_leave_schemes_titles');
        if( $query->num_rows() > 0 )
        {
            $query->free_result();
            return $this->unused_leave_scheme_key();
        }
        return $random_unique_int;
    }

    public function unused_request_key(){
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        $query = $this->db->where( 'leave_request_key', $random_unique_int )->get_where( 'hrm_leave_request');
        if( $query->num_rows() > 0 ) {
            $query->free_result();
            return $this->unused_leave_key();
        }
        return $random_unique_int;
    }



}