<?php

class InsuranceModel extends My_model {

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function insurances() {
        $this->db->order_by('pr_insurance_id','DESC');
        $this->db->where('pr_insurance_business',$this->business);
        $this->db->where('pr_insurance_branch',$this->branch);
        $query = $this->db->get('payroll_insurance');
        return ($query->num_rows()>0)? $query->result_array(): FALSE;
    }

    public function newInsurance($insurance) {
        $insurance['pr_insurance_key'] = $this->insuranceKey();
        $insurance['pr_insurance_branch'] = $this->branch;
        $insurance['pr_insurance_business'] = $this->business;
        $this->db->limit(1)
            ->insert('payroll_insurance',$insurance);
        return ($this->db->affected_rows()>0)? TRUE : FALSE;
    }

    public function updateInsurance($insuranceKey,$insurance) {
        $this->db->where('pr_insurance_key',$insuranceKey);
        $this->db->where('pr_insurance_key',$insuranceKey);
        $this->db->where('pr_insurance_branch',$this->branch);
        $this->db->limit(1)
            ->update('payroll_insurance',$insurance);
        return ($this->db->affected_rows()>0)? TRUE : FALSE;
    }

    public function insuranceDetails($insuranceKey) {
        $this->db->where('pr_insurance_key',$insuranceKey);
        $this->db->where('pr_insurance_key',$insuranceKey);
        $this->db->where('pr_insurance_branch',$this->branch);
        $query = $this->db->get('payroll_insurance');
        return ($query->num_rows()>0)? $query->row(): FALSE;
    }

    public function deleteInsurance($insuranceKey) {
        $this->db->where('pr_insurance_key',$insuranceKey);
        $this->db->where('pr_insurance_business',$this->business);
        $this->db->where('pr_insurance_branch',$this->branch);
        $this->db->delete('payroll_insurance');
        return ($this->db->affected_rows()>0)? TRUE : FALSE;
    }


    public function insuranceKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'pr_insurance_key', $random_unique_int )
            ->get_where( 'payroll_insurance' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->insuranceKey();
        }

        return $random_unique_int;
    }


}
