<?php

class VariablesModel extends My_model {

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function variables() {
      $this->db->order_by('variable_id','DESC');
      $this->db->where('variable_business',$this->business);
      $this->db->where('variable_branch',$this->branch);
      $query = $this->db->get('payroll_variables');
      return ($query->num_rows()>0)? $query->result_array(): FALSE;
    }

    public function newVariable($variable) {
      $variable['variable_key'] = $this->variableKey();
      $variable['variable_branch'] = $this->branch;
      $variable['variable_business'] = $this->business;
        $this->db->limit(1)
          ->insert('payroll_variables',$variable);
        return ($this->db->affected_rows()>0)? TRUE : FALSE;
    }

    public function updateVariable($variableKey,$variable) {
      $this->db->where('variable_key',$variableKey);
      $this->db->where('variable_key',$variableKey);
      $this->db->where('variable_branch',$this->branch);
        $this->db->limit(1)
          ->update('payroll_variables',$variable);
        return ($this->db->affected_rows()>0)? TRUE : FALSE;
    }

    public function variableDetails($variableKey) {
      $this->db->where('variable_key',$variableKey);
      $this->db->where('variable_key',$variableKey);
      $this->db->where('variable_branch',$this->branch);
      $query = $this->db->get('payroll_variables');
      return ($query->num_rows()>0)? $query->row(): FALSE;
    }

    public function deleteVariable($variableKey) {
      $this->db->where('variable_key',$variableKey);
      $this->db->where('variable_business',$this->business);
      $this->db->where('variable_branch',$this->branch);
      $this->db->delete('payroll_variables');
      return ($this->db->affected_rows()>0)? TRUE : FALSE;
    }


    public function variableKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'variable_key', $random_unique_int )
            ->get_where( 'payroll_variables' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->variableKey();
        }

        return $random_unique_int;
    }


}
