<?php

class ProfileModel extends MY_Model {

 public function __construct() {
    parent::__construct();
    $this->branch = runningBranch()->branch_key;
    $this->business = runningBusiness()->business_key;
  }

  public function updateAccount($key,$details) {

        $this->db->where('user_id',$key);
        $this->db->update('users',$details);

        if($this->db->affected_rows()>0){
            return true;
        }else{
            return false;
        }
    }

  public function userUpdate($key,$data){
        $this->db->where('user_key',$key);
        $this->db->where('details_business',$this->business);
        $this->db->update('users_details',$data);

        if($this->db->affected_rows()>0){
            return true;
        }else{
            $data['user_key'] = $key;
            $data['details_business'] = $this->business;
            $data['details_branch'] = $this->branch;
            $this->db->insert('users_details',$data);
            if($this->db->affected_rows()>0){
                return true;
            }else{
                return false;
            }
        }
    }

  public function updatePersonalData($user_id,$data) {
        if($this->db->affected_rows()>0){
            return true;
        }else{
            $data['details_business'] = $this->business;
            $data['details_branch'] = $this->branch;
            $this->db->where('user_key',$user_id);
            $this->db->update('users_details',$data);
            if($this->db->affected_rows()>0){
                return true;
            }else{
                return false;
            }
        }
    }

   public function updatepersonaldata1($key,$details) {
    $this->db->where('user_key',$key);
    $this->db->where('details_business',$this->business);
    $this->db->update('users_details',$details);

    if($this->db->affected_rows()>0){
        return true;
    }else{
        $details['user_key'] = $key;
        $details['details_business'] = $this->business;
        $details['details_branch'] = $this->branch;
        $this->db->insert('users_details',$details);
        if($this->db->affected_rows()>0){
            return true;
        }else{
            return false;
        }
    }
}

  public function employeeUpdatePayroll($key,$salary,$taxes,$variables) {
    $this->db->trans_start();

    $this->db->where('user_key',$key);
    $this->db->update('users_details',$salary);

    $this->db->where('ev_employee_key',$key);
    $this->db->delete('employee_variables');
    if(!empty($variables)){
      foreach ($variables as $v => $variable) {
        $dataVariable['ev_variable_key'] = $variable['ev_variable_key'];
        $dataVariable['ev_overide_value'] = $variable['ev_overide_value'];
        $dataVariable['ev_employee_key'] = $key;
        $this->db->insert('employee_variables',$dataVariable);
      }
   }


     $this->db->where('et_employee_key',$key);
     $this->db->delete('employee_taxes');

   if(!empty($taxes)){
      foreach ($taxes as $t => $tax) {
        $dataTax['et_tax_key'] = $tax['et_tax_key'];
        $dataTax['et_overide_value'] = $tax['et_overide_value'];
        $dataTax['et_employee_key'] = $key;
        $this->db->insert('employee_taxes',$dataTax);
      }
    }

    $this->db->trans_complete();
    return $this->db->trans_status();
   }

 public function registerEmployee($primary,$security,$taxes,$variables,$roles) {
   $this->db->trans_start();

   $security['user_id'] = $this->unused_user_id();
   $security['created_at'] = date('Y-m-d H:i:s');
   $this->db->insert('users',$security);

   $primary['user_key'] = $security['user_id'];
   $this->db->insert('users_details',$primary);

   if(!empty($variables)){
     foreach ($variables as $v => $variable) {
       $dataVariable['ev_variable_key'] = $variable['ev_variable_key'];
       $dataVariable['ev_overide_value'] = $variable['ev_overide_value'];
       $dataVariable['ev_employee_key'] = $security['user_id'];
       $this->db->insert('employee_variables',$dataVariable);
     }
  }

  if(!empty($roles)){
    foreach ($roles as $r => $role) {
      $roleData['action_id'] = $role['action_id'];
      $roleData['user_id'] = $security['user_id'];
      $roleData['branch'] = $security['user_branch'];
      $roleData['business'] = $security['user_business'];
      $this->db->insert('acl',$roleData);
    }
  }

  if(!empty($taxes)){
     foreach ($taxes as $t => $tax) {
       $dataTax['et_tax_key'] = $tax['et_tax_key'];
       $dataTax['et_overide_value'] = $tax['et_overide_value'];
       $dataTax['et_employee_key'] = $security['user_id'];
       $this->db->insert('employee_taxes',$dataTax);
     }
   }

   $this->db->trans_complete();
   return $this->db->trans_status();
  }

 public function employees() {
   $this->db->order_by('id');
   $this->db->where('user_branch',$this->branch);

  $this->db->where('user_business',$this->business);
   $query = $this->db->where('auth_level >',1)
        ->join('users_details','users_details.user_key=users.user_id','left')
        ->join('acl_categories','acl_categories.category_key=users.user_title','left')
        ->get( 'users' );
    return $query->result_array();
  }

  public function employee($key) {
      $this->db->where('auth_level >',1);
      //$this->db->where('user_branch',$this->branch);
      $this->db->where('user_business',$this->business);
      $query = $this->db->where('user_id',$key)
       ->join('users_details d','d.user_key=users.user_id','left')
       ->join('user_roles','user_roles.role_user=users.user_id','left')
       ->join('acl_categories','acl_categories.category_key=users.user_title','left')
       ->get( 'users' );
     return $query->num_rows()>0 ? $query->row() : FALSE;
   }

  public function account($userId) {
       $this->db->where('user_id',$userId);
       $query = $this->db->where('user_business',$this->business)
       ->join('users_details d','d.user_key=users.user_id','left')
       ->join('user_roles','user_roles.role_user=users.user_id','left')
       ->join('acl_categories','acl_categories.category_key=users.user_title','left')
       ->get( 'users' );
      return $query->num_rows()>0 ? $query->row() : FALSE;
    }

  public function profile($userId) {
        $this->db->where('user_id',$userId);
        $query = $this->db->where('user_business',$this->business)
            ->join('users_details d','d.user_key=users.user_id','left')
            ->join('user_roles','user_roles.role_user=users.user_id','left')
            ->join('acl_categories','acl_categories.category_key=users.user_title','left')
            ->get( 'users' );
        if(!empty($query) && $query->num_rows()>0){
           return $query->row();
        }else{
            return false;
        }
    }

  public function employeeRoles($key) {
       $this->db->where('role_user',$key);
       $this->db->where('role_branch',$this->branch);
       $this->db->where('role_business',$this->business);
       $query = $this->db->get( 'user_roles' );
      return $query->num_rows()>0 ? $query->row() : FALSE;
    }

  public function employeeUpdateSecurity($key,$details) {
      $this->db->where('user_id',$key);
      //$this->db->where('user_branch',$this->branch);
      $this->db->where('user_business',$this->business);
      $this->db->update('users',$details);
     return $this->db->affected_rows();
    }

   public function employeeUpdatePrimary($key,$details) {
     if($this->employeeDetails($key)){
       $this->db->where('user_key',$key);
       $this->db->where('details_business',$this->business);
       $this->db->update('users_details',$details);
     }else{
       $details['user_key'] = $key;
       $details['details_branch'] = $this->branch;
       $details['details_business'] = $this->business;
       $this->db->insert('users_details',$details);
     }
      return $this->db->affected_rows();
   }

   public function employeeUpdateRoles($key,$roles) {
     if($this->employeeRoles($key)){
       $this->db->where('role_user',$key);
       $this->db->where('role_branch',$this->branch);
       $this->db->where('role_business',$this->business);
       $this->db->update('user_roles',$roles);
     }else{
       $roles['role_user'] = $key;
       $roles['role_branch'] = $this->branch;
       $roles['role_business'] = $this->business;
       $this->db->insert('user_roles',$roles);
     }

    if($this->db->affected_rows()>0){
        return TRUE;
      }else{
        return FALSE;
    }

  }

   public function employee_delete($key) {
         $this->db->where('user_id',$key)
           ->delete( 'users' );
       return $this->db->affected_rows();
     }

   public function adddept($key,$details) {
       $details['id_key'] = $this->employees_internal_depts_key();
         $details['id_branch'] = $this->branch;
         $details['id_business'] = $this->business;
         $details['id_actions'] = optionActionsSingle($details['id_key']);
         $this->db->insert('employees_internal_depts',$details);
        return $this->db->affected_rows();
     }

   function employee_depts($employee){
       $this->db->where('id_business',$this->business);
       $this->db->where('id_branch',$this->branch);
       $this->db->where('id_employee',$employee);
       $query = $this->db->get('employees_internal_depts');
       return $query->num_rows()>0 ? $query->result_array() : false;
     }

     function employeeinternaldeptupdate($employee,$dept,$data){
       $this->db->where('id_business',$this->business);
       $this->db->where('id_branch',$this->branch);
       $this->db->where('id_employee',$employee);
       $this->db->where('id_key',$dept);
       $this->db->update('employees_internal_depts',$data);
       return $this->db->affected_rows();
     }

     function employeedeptdetails($employee,$dept){
       $this->db->where('id_business',$this->business);
       $this->db->where('id_branch',$this->branch);
       $this->db->where('id_employee',$employee);
       $this->db->where('id_key',$dept);
       $query = $this->db->get('employees_internal_depts');
       return $query->num_rows()>0 ? $query->row() : false;
     }

function employeedeptspaidtotal($employee){
   $this->db->select_sum('dp_amount','total');
   $this->db->where('dp_business',$this->business);
   $this->db->where('dp_branch',$this->branch);
   $query = $this->db->where('dp_employee',$employee)
   ->get( 'employees_internal_depts_paid' );
   return $query->num_rows()>0 ? $query->row()->total : 0;
}

function employeedeptspaid($employee){
   $this->db->where('dp_business',$this->business);
   $this->db->where('dp_branch',$this->branch);
   $query = $this->db->where('dp_employee',$employee)
   ->get( 'employees_internal_depts_paid' );
   return $query->num_rows()>0 ? $query->result_array(): false;
}

public function deletedept($key) {
          $this->db->where('id_business',$this->business);
          $this->db->where('id_branch',$this->branch);
          $this->db->where('id_key',$key)
            ->delete( 'employees_internal_depts' );
        return $this->db->affected_rows();
      }

public function employeetotaldept($employee) {
    $this->db->select_sum('id_amount','total');
   $this->db->where('id_business',$this->business);
   $this->db->where('id_branch',$this->branch);
   $query = $this->db->where('id_employee',$employee)
   ->get( 'employees_internal_depts' );
   return $query->num_rows()>0 ? $query->row()->total : 0;
 }

public function employeemonthdept($employee) {
    $dates = month_start_end(date('Y-m-d'));
    $this->db->select_sum('id_amount','total');
    $this->db->where('id_date >=',$dates['start']);
    $this->db->where('id_date <=',$dates['end']);
    $this->db->where('id_business',$this->business);
    $this->db->where('id_branch',$this->branch);
    $query = $this->db->where('id_employee',$employee)
    ->get( 'employees_internal_depts' );
    return $query->num_rows()>0 ? $query->row()->total : 0;
  }

function employeesallaryadvancepaid($employee){
     $this->db->where('pad_business',$this->business);
     $this->db->where('pad_branch',$this->branch);
     $query = $this->db->where('pad_employee',$employee)
     ->get( 'employees_sallary_advances_paid' );
     return $query->num_rows()>0 ? $query->result_array(): false;
  }

  function employeesallaryadvancepaidtotal($employee){
     $this->db->select_sum('dp_amount','total');
     $this->db->where('dp_business',$this->business);
     $this->db->where('dp_branch',$this->branch);
     $query = $this->db->where('dp_employee',$employee)
     ->get( 'employees_internal_depts_paid' );
     return $query->num_rows()>0 ? $query->row()->total : 0;
  }

  function employeesallaryadvanceupdate($employee,$dept,$data){
    $this->db->where('ad_business',$this->business);
    $this->db->where('ad_branch',$this->branch);
    $this->db->where('ad_employee',$employee);
    $this->db->where('ad_key',$dept);
    $this->db->update('employees_sallary_advances',$data);
    return $this->db->affected_rows();
  }

  function employeesallaryadvancedetails($employee,$dept){
    $this->db->where('ad_business',$this->business);
    $this->db->where('ad_branch',$this->branch);
    $this->db->where('ad_employee',$employee);
    $this->db->where('ad_key',$dept);
    $query = $this->db->get('employees_sallary_advances');
    return $query->num_rows()>0 ? $query->row() : false;
  }

public function deletesallaryadvance($key) {
            $this->db->where('ad_business',$this->business);
            $this->db->where('ad_branch',$this->branch);
            $this->db->where('ad_key',$key)
              ->delete( 'employees_sallary_advances' );
          return $this->db->affected_rows();
        }

public function employeetotalsallaryadvace($employee) {
      $this->db->select_sum('ad_amount','total');
     $this->db->where('ad_business',$this->business);
     $this->db->where('ad_branch',$this->branch);
     $query = $this->db->where('ad_employee',$employee)
     ->get( 'employees_sallary_advances' );
     return $query->num_rows()>0 ? $query->row()->total : 0;
   }

public function employeemonthsallaryadvance($employee) {
     $dates = month_start_end(date('Y-m-d'));
     $this->db->select_sum('ad_amount','total');
     $this->db->where('ad_date >=',$dates['start']);
     $this->db->where('ad_date <=',$dates['end']);
     $this->db->where('ad_business',$this->business);
     $this->db->where('ad_branch',$this->branch);
     $query = $this->db->where('ad_employee',$employee)
     ->get( 'employees_sallary_advances' );
     return $query->num_rows()>0 ? $query->row()->total : 0;
   }

   public function addsallaryadvance($key,$details) {
      $details['ad_key'] = $this->employees_sallary_advances_key();
       $details['ad_branch'] = $this->branch;
       $details['ad_business'] = $this->business;
       $details['ad_actions'] = optionActionsSingle($details['ad_key']);
       $this->db->insert('employees_sallary_advances',$details);
      return $this->db->affected_rows();
   }

   function employeesallaryadvances($employee){
     $this->db->where('ad_business',$this->business);
     $this->db->where('ad_branch',$this->branch);
     $this->db->where('ad_employee',$employee);
     $query = $this->db->get('employees_sallary_advances');
     return $query->num_rows()>0 ? $query->result_array() : false;
   }

    public function unused_user_id()
    {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'user_id', $random_unique_int )
            ->get_where( 'users');

        if( $query->num_rows() > 0 )
        {
            $query->free_result();
            // If the random user_id is already in use, try again
            return $this->unused_user_id();
        }

        return $random_unique_int;
    }

function employees_internal_depts_key(){
  // Create a random user id between 1200 and 4294967295
  $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

  // Make sure the random user_id isn't already in use
  $query = $this->db->where( 'id_key', $random_unique_int )
      ->get_where( 'employees_internal_depts');

  if( $query->num_rows() > 0 )
  {
      $query->free_result();
      // If the random user_id is already in use, try again
      return $this->employees_internal_depts_key();
  }

  return $random_unique_int;
}

function employees_sallary_advances_key(){
  // Create a random user id between 1200 and 4294967295
  $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

  // Make sure the random user_id isn't already in use
  $query = $this->db->where( 'ad_key', $random_unique_int )
      ->get_where( 'employees_sallary_advances');

  if( $query->num_rows() > 0 )
  {
      $query->free_result();
      // If the random user_id is already in use, try again
      return $this->employees_sallary_advances_key();
  }

  return $random_unique_int;
}
}
