<?php

class FinancialReportsModel extends My_model {

  public function __construct() {
        parent::__construct();
      $this->business = runningBusiness()->business_key;
      $this->branch = runningBranch()->branch_key;
    }

  public function bsLoanOutstandingPrincipal(){
    return $this->loansSummaryModel->totalPrincipalOutstanding();
  }

  public function bsLoanOutstandingInterest(){
    return $this->loansSummaryModel->totalInterestOutstanding();
  }

  public function bsLoanOutstandingCharges(){
    return $this->loansSummaryModel->totalChargesOutstanding();
  }

  public function bsLoanOutstandingTotal(){
    return $this->bsLoanOutstandingCharges() + $this->bsLoanOutstandingInterest() + $this->bsLoanOutstandingPrincipal();
  }

public function bsTotalCurrenctassets(){
  return $this->bsLoanOutstandingTotal();
}
  function bsAssets(){
    $query = $this->db->select( '*' )
      ->order_by( 'asset_id','DESC' )
      ->where('asset_store',$this->store)
      ->where('asset_business',$this->business)
      ->join('asset_types','asset_types.asset_type_key=assets.asset_type','left')
      ->from('assets')
      ->get();
  return $query->result_array();
  }

  function bsAssetsCategories(){
    $query = $this->db->select( '*' )
      ->group_by( 'category_key')
      ->where('asset_store',$this->store)
      ->where('asset_business',$this->business)
      ->join('asset_types','asset_types.asset_type_key=assets.asset_type','both')
      ->join('asset_categories','asset_categories.category_key=assets.asset_category','both')
      ->get('assets');
  return $query->result_array();
  }

function bsCustomerSavings(){
  return $this->accountTransTotalNoOrigin($this->store,379022439);
}

function loanPortifolioAccounts(){
    $this->db->select('loan_portifolio,app_key');
    $this->db->where('app_store',$this->store);
    $this->db->where('app_business',$this->business);
    $this->db->join('loans ln','ln.loan_key =app_loan','both');
    $query = $this->db->get( 'loan_applications' );
    return $query->num_rows()>0 ? $query->result_array() : FALSE;
  }

  function loanInterestAccounts(){
    $this->db->select('loan_interest_receivable,app_key');
    $this->db->where('app_store',$this->store);
    $this->db->where('app_business',$this->business);
    $this->db->join('loans ln','ln.loan_key =app_loan','both');
    $query = $this->db->get( 'loan_applications' );
    return $query->num_rows()>0 ? $query->result_array() : FALSE;
  }

  function loanChargesAccounts(){
    $this->db->select('loan_fees_receivable,app_key');
    $this->db->where('app_store',$this->store);
    $this->db->where('app_business',$this->business);
    $this->db->join('loans ln','ln.loan_key =app_loan','both');
    $query = $this->db->get( 'loan_applications' );
    return $query->num_rows()>0 ? $query->result_array() : FALSE;
  }

function transactionTotal($origin,$account){
  return $this->accountTransTotal($this->store,$origin,$account);
}

}
