<?php
/**
 * Description of Taxes Model
 *
 * @author Kelvin Benard
 * @email kelvin@lockminds.com
 */

class TaxesModel extends MY_Model{

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    function createTaxClass($data){
        $this->db->insert('tax_classes',$data);
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

    function createTax($data){
        $this->db->insert('taxes',$data);
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

    function deleteTaxClass($key){
        $this->db->where('tax_class_branch', $this->branch);
        $this->db->where('tax_class_business', $this->business);
        $this->db->where('tax_class_key',$key);
        $this->db->limit(1);
        $this->db->delete('tax_classes');
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

    function updateTaxClass($key,$data){
        $this->db->where('tax_class_branch', $this->branch);
        $this->db->where('tax_class_business', $this->business);
        $this->db->where('tax_class_key',$key);
        $this->db->update('tax_classes',$data);
        $this->db->limit(1);
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

    function deleteTax($key){
        $this->db->where('tax_branch', $this->branch);
        $this->db->where('tax_business', $this->business);
        $this->db->where('tax_key',$key);
        $this->db->limit(1);
        $this->db->delete('taxes');
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

    function updateTax($key,$data){
        $this->db->where('tax_branch', $this->branch);
        $this->db->where('tax_business', $this->business);
        $this->db->where('tax_key',$key);
        $this->db->update('taxes',$data);
        $this->db->limit(1);
        return $this->db->affected_rows()>0 ? TRUE : FALSE;
    }

    function taxes($when = ''){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('tax_created_at >=',$dates['start']);
            $this->db->where('tax_created_at <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->where('tax_branch', $this->branch);
        $this->db->where('tax_business', $this->business);
        $this->db->order_by('tax_id','ASC');
        $this->db->select('DATE_FORMAT(tax_created_at, "%m/%d/%Y") as date', FALSE);
        $this->db->join('tax_classes tc','tc.tax_class_key=tax_class','left');
        $query = $this->db->get('taxes');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }

    function taxClasses($when = ''){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('tax_class_created >=',$dates['start']);
            $this->db->where('tax_class_created <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->where('tax_class_branch', $this->branch);
        $this->db->where('tax_class_business', $this->business);
        $this->db->order_by('tax_class_id','ASC');
        $this->db->select('DATE_FORMAT(tax_class_created, "%m/%d/%Y") as date', FALSE);
        $query = $this->db->get('tax_classes');
        return $query->num_rows() >0 ? $query->result_array() : false;
    }


    function taxDetails($tax){
        $this->db->where('tax_branch', $this->branch);
        $this->db->where('tax_business', $this->business);
        $this->db->join('tax_classes tc','tc.tax_class_key=tax_class','left');
        $this->db->where('tax_key',$tax);
        $query = $this->db->get('taxes');
        return $query->num_rows() >0 ? $query->row() : false;
    }

    function taxClassDetails($class){
        $this->db->where('tax_class_branch', $this->branch);
        $this->db->where('tax_class_business', $this->business);
        $this->db->where('tax_class_key',$class);
        $query = $this->db->get('tax_classes');
        return $query->num_rows() >0 ? $query->row() : false;
    }


    public function taxKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'tax_key', $random_unique_int )
            ->get_where( 'taxes' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->taxKey();
        }

        return $random_unique_int;
    }

    public function taxClassKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'tax_class_key', $random_unique_int )
            ->get_where( 'tax_classes' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->taxClassKey();
        }

        return $random_unique_int;
    }
    

}
