    "use strict";

    // Class Definition
    let KTLoginGeneral = function() {

        const baseUrl = location.protocol.concat("//").concat(window.location.hostname)

        let login = $('#kt_login');

        let showErrorMsg = function(form, type, msg) {
            let alert = $('<div class="alert alert-' + type + ' alert-dismissible" role="alert">\
                <div class="alert-text">'+msg+'</div>\
                <div class="alert-close">\
                    <i class="flaticon2-cross kt-icon-sm" data-dismiss="alert"></i>\
                </div>\
            </div>');

            form.find('.alert').remove();
            alert.prependTo(form);
            KTUtil.animateClass(alert[0], 'fadeIn animated');
            alert.find('span').html(msg);
        }

        // Private Functions
        let displaySignUpForm = function() {
            login.removeClass('kt-login--forgot');
            login.removeClass('kt-login--signin');

            login.addClass('kt-login--signup');
            KTUtil.animateClass(login.find('.kt-login__signup')[0], 'flipInX animated');
        }

        let displaySignInForm = function() {
            login.removeClass('kt-login--forgot');
            login.removeClass('kt-login--signup');

            login.addClass('kt-login--signin');
            KTUtil.animateClass(login.find('.kt-login__signin')[0], 'flipInX animated');
        }

        let displayForgotForm = function() {
            login.removeClass('kt-login--signin');
            login.removeClass('kt-login--signup');

            login.addClass('kt-login--forgot');
            KTUtil.animateClass(login.find('.kt-login__forgot')[0], 'flipInX animated');

        }

        let handleFormSwitch = function() {
            $('#kt_login_forgot').click(function(e) {
                e.preventDefault();
                displayForgotForm();
            });

            $('#kt_login_forgot_cancel').click(function(e) {
                e.preventDefault();
                displaySignInForm();
            });

            $('#kt_login_signup').click(function(e) {
                e.preventDefault();
                displaySignUpForm();
            });

            $('#kt_login_signup_cancel').click(function(e) {
                e.preventDefault();
                displaySignInForm();
            });
        }

        let handleSignInFormSubmit = function() {
            $('#kt_login_signin_submit').click(function(e)
            {
                e.preventDefault();
                let btn = $(this);
                let form = $(this).closest('form');
                let signInFormData = form.serialize();
                form.validate({
                    rules: {
                        email: {
                            required: true,
                            email: true
                        },
                        password: {
                            required: true
                        }
                    }
                });
                if (!form.valid()) {
                    return;
                }
                btn.addClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', true);
                form.ajaxSubmit({
                    type: 'post',
                    cache: false,
                    data: signInFormData,
                    dataType: 'json',
                    url: baseUrl + '/app/ajax_login',
                    success: function(response, status, xhr, $form) {
                        $('[name="'+ response.login_token_name +'"]').val( response.token );
                        if(response.status == 1){
                            window.location.href = baseUrl + '/' + response.role + '/dashboard';
                            return;
                        }

                        if(response.status == 0){
                            btn.removeClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', false);
                            showErrorMsg(form, 'danger', response.message);
                            return;
                        }
                    }
            });
            });
        }

        let handleSignUpFormSubmit = function() {
            $('#kt_login_signup_submit').click(function(e) {
                e.preventDefault();

                let btn = $(this);
                let form = $(this).closest('form');
                let signUpFormaData = form.serialize();
                form.validate({
                    rules: {
                        company: {
                            required: true
                        },
                        email: {
                            required: true,
                            email: true
                        },
                        password: {
                            required: true
                        },
                        rpassword: {
                            required: true
                        },
                        agree: {
                            required: true
                        }
                    }
                });

                if (!form.valid()) {
                    return;
                }

                btn.addClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', true);

                form.ajaxSubmit({
                    type: 'post',
                    cache: false,
                    data:signUpFormaData,
                    dataType: 'json',
                    url: baseUrl + '/app/register',
                    success: function(response, status, xhr, $form) {
                    $('[name="'+ response.login_token_name +'"]').val( response.token );
                    let signInForm = login.find('.kt-login__signin form');
                    if(response.status == 1){
                        btn.removeClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', false);
                        signInForm.clearForm();
                        signInForm.validate().resetForm();
                        form.clearForm();
                        form.validate().resetForm();
                        displaySignInForm();
                        showErrorMsg(signInForm, 'success', response.message);
                        Swal.fire("",response.message,"success");
                        return;
                    }

                    if(response.status == 0){
                        btn.removeClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', false);
                        showErrorMsg(form, 'danger', response.message);
                        Swal.fire("",response.message,"warning");
                        return;
                    }

                }
            });
            });
        }

        let handleForgotFormSubmit = function() {
            $('#kt_login_forgot_submit').click(function(e) {
                e.preventDefault();

                let btn = $(this);
                let form = $(this).closest('form');

                form.validate({
                    rules: {
                        email: {
                            required: true,
                            email: true
                        }
                    }
                });

                if (!form.valid()) {
                    return;
                }

                btn.addClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', true);

                form.ajaxSubmit({
                    url: '',
                    success: function(response, status, xhr, $form) {
                        // similate 2s delay
                        setTimeout(function() {
                            btn.removeClass('kt-spinner kt-spinner--right kt-spinner--sm kt-spinner--light').attr('disabled', false); // remove
                            form.clearForm(); // clear form
                            form.validate().resetForm(); // reset validation states

                            // display signup form
                            displaySignInForm();
                            let signInForm = login.find('.kt-login__signin form');
                            signInForm.clearForm();
                            signInForm.validate().resetForm();

                            showErrorMsg(signInForm, 'success', 'Cool! Password recovery instruction has been sent to your email.');
                        }, 2000);
                    }
                });
            });
        }

        let handleFormInput = function() {
            $("#phonenumber").inputmask('+ 999 999 999999', {
                numericInput: true
            });
        }

        // Public Functions
        return {
            // public functions
            init: function() {
                handleFormSwitch();
                handleSignInFormSubmit();
                handleSignUpFormSubmit();
                handleForgotFormSubmit();
                handleFormInput();
            }
        };
    }();

    // Class Initialization
    jQuery(document).ready(function() {
        KTLoginGeneral.init();
    });

    function checkpassword(){
        let password = document.getElementById('password');
        let cpassword = document.getElementById('confirm');
        let button = document.getElementById('kt_login_signup_submit');

        if(cpassword.value !== password.value || password.value.length < 5){
            password.style.border = "2px";
            password.style.borderStyle = "solid";
            password.style.borderColor = 'red';
            cpassword.style.border = "2px";
            cpassword.style.borderStyle = "solid";
            cpassword.style.borderColor = 'red';
            button.setAttribute("disabled", "");
        }else{
            password.style.border = "2px";
            password.style.borderStyle = "solid";
            password.style.borderColor = 'green';
            cpassword.style.border = "2px";
            cpassword.style.borderStyle = "solid";
            cpassword.style.borderColor = 'green';
            button.removeAttribute("disabled", "");
        }
    }


