<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="kt-todo__bottom" id="kt_page_portlet">
    <h5>Asset Depreciation</h5>
    <table class="table table-bordered table-hover table-checkable" id="lm_table_depreciation">
        <thead>
        <tr>
            <th>Year</th>
            <th>Month</th>
            <th>Asset serial No</th>
            <th>Depreciation Value/Month</th>
            <th>Current Value</th>
            <th>Action</th>
        </tr>
        </thead>

    </table>
    <!--End::Section-->
</div>

<div class="modal fade" id="previewPdf" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content bg-dark">
            <div class="modal-body" id="modalview" style="height:100%; min-height">
            </div>
            <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="btn btn-danger" name="button"><i class="flaticon-cancel"></i></button>
            </div>
        </div>
    </div>
</div>

 <div id="depriciation" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">You did not clock Out Yesterday</h4>
                </div>
                <div class="modal-body">
                    <form id="modifyDepreciationForm" action="#" method="get" onsubmit="return false">
                        <div class="form-group">
                            <input type="text" name="wclock_key" value="">
                            <textarea required name="wclock_time_reason" class="form-control" placeholder="give reason"></textarea>
                        </div>
                        <button type="submit" name="submit" class="btn btn-sm pull-right btn-elevate btn-elevate-air  btn-primary"><img src="<?php echo base_url('resources');?>/assets/media/icons/svg/Media/Repeat-one.svg"/>Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>


<script type="text/javascript">

    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    var Datatable = function() {
        var initTable = function() {
            var events = $('#lm_table_depreciation');
            // begin first table
            events.DataTable({
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: false,
                ajax: '<?php echo base_url('accounting/assets/datasourceDepreciation/'.$asset->asset_key);?>',
                columns: [
                    {data: 'asset_dep_year'},
                    {data: 'asset_dep_month'},
                    {data: 'asset_serial'},
                    {data: 'asset_dep_depriciation_month_price'},
                    {data: 'asset_dep_price_difference'},
                ],
                initComplete: function() {
                    this.api().columns().every(function() {
                        var column = this;

                        switch (column.title()) {
                            case 'Status':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="6"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Region':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="4"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'District':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="5"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                        }
                    });
                },
                columnDefs: [
                    {
                        targets: 0,
                        render: function(data, type, full, meta) {
                            return (data);
                        }
                    },
                    {
                        targets: 1,
                        render: function(data, type, full, meta) {
                            return (data);
                        }
                    },
                    {
                        targets: 3,
                        render: function (data, type, full, meta) {
                            return KTUtil.numberString(to_money(data));
                        }
                    },
                    {
                        targets: 4,
                        render: function (data, type, full, meta) {
                            return KTUtil.numberString(to_money(data));
                        }
                    },
                    {
                        targets: 5,
                        "width": "25%",
                        render: function(data, type, full, meta){
                            if(full.asset_dep_status === 'Pending'){ //&& full.asset_dep_price_difference > 0) {
                                //return ' <a href="javascript:deleteDep(' + full.asset_dep_key + ');"><i class="flaticon-delete text-danger"></i></a> | <a data-key="' + full.asset_dep_key + '" href="javascript:runDep(' + full.asset_dep_key + ');" class="btn btn-sm  btn-elevate btn-elevate-air  btn-success"><img src="</?php //echo base_url('resources');?>/assets/media/icons/svg/Media/DVD.svg"/> Run Depreciation</a>';
                                return 'Pending';
                            }
                            else {
                                return 'Depreciated';
                            }

                            }
                    }

                ],
            });

            var filter = function() {
                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                let table = $.fn.dataTable.tables( { api: true } );
                table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
            };

            var asdasd = function(value, index) {
                let table = $.fn.dataTable.tables( { api: true } );
                var val = $.fn.dataTable.util.escapeRegex(value);
                table.column(index).search(val ? val : '', false, true);
            };

            $('#m_search').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                var params = {};
                $('.kt-input').each(function() {
                    var i = $(this).data('col-index');
                    if (params[i]) {
                        params[i] += '|' + $(this).val();
                    }
                    else {
                        params[i] = $(this).val();
                    }
                });
                $.each(params, function(i, val) {
                    // apply search params to datatable
                    table.column(i).search(val ? val : '', false, false);
                });
                table.table().draw();
            });

            $('#m_reset').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                $('.kt-input').each(function() {
                    $(this).val('');
                    table.column($(this).data('col-index')).search('', false, false);
                });
                table.ajax.reload();
            });

        };

        return {
            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });

    function runDep(depr){
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to run asset Depreciation!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Run it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('accounting/assets/runDepreciation/');?>" + depr,
                    type: "get",
                    beforeSend: function(){
                        KTApp.block("#lm_table_depreciation",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"System Running assets depreciation ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            $('div#id-' + depr).hide();
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_depreciation');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_depreciation');
                        Swal.fire('',xhr.statusText,'warning');
                    }

                })
            }
        })
    }

    function deleteDep(depKey){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/assets/deleteDep/depreciation')?>/'+depKey,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("div#details",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting document ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            if(table != undefined){
                                table.ajax.reload();
                            }
                            $('div#' + docKey).hide();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('div#details');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }
</script>
