<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<!-- end::Head -->

<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topToolBarAssets('assets'); ?>

    <!-- begin:: Content -->
    <div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">

            <div class="kt-portlet kt-portlet--mobile">
                <!--<div class="kt-portlet__head">
                    <div class="kt-portlet__head-label">
                        <span class="kt-portlet__head-icon"><i class="flaticon-stopwatch"></i></span>
                        <h3 class="kt-portlet__head-title">Assets</h3>
                    </div>
                </div>-->
                <div class="kt-portlet__head">
                    <div class="kt-portlet__head-label">
                        <h3 class="kt-portlet__head-title">
                            ASSETS <?php if(!empty($when = $this->input->get("when"))) echo '| <span class="kt-font-brand">'. ucfirst(datesWhen($when)['label'])."</span>";?>
                        </h3>
                    </div>
                    <div class="kt-portlet__head-toolbar">
                        <ul class="nav nav-tabs nav-tabs-bold nav-tabs-line   nav-tabs-line-right nav-tabs-line-brand" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#depreciating-assets" role="tab" aria-selected="false">
                                    Depreciating
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#appreciating-assets" role="tab" aria-selected="true">
                                    Appreciating
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="kt-portlet__body">
                    <div class="tab-content">
                        <div class="tab-pane  active" id="depreciating-assets">
                            <table class="table " id="depreciating-assets-table">
                                <thead>
                                <tr>
                                    <th>Asset</th>
                                    <th>Type</th>
                                    <th>Actual Cost</th>
                                    <th>Registered</th>
                                    <th>Last Depreciated (Financial Year)</th>
                                    <th>Depreciation Value (/Year)</th>
                                    <th>Current Value</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                        <div class="tab-pane" id="appreciating-assets">
                            <table id="appreciating-assets-table" class="table">
                                <thead>
                                <tr>
                                    <th>Asset</th>
                                    <th>Type</th>
                                    <th>Actual Cost</th>
                                    <th>Registered</th>
                                    <!--<th>Last Appreciated (Financial Year)</th>
                                    <th>Appreciation Value (/Year)</th>
                                    <th>Current Value</th>-->
                                    <th>Action</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

    </div>
    <!-- end:: Content -->
</div>


<?php include VIEWPATH.'includes/footer.php';
include VIEWPATH . '/accounting/assets/scripts.php';
?>
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script src="https://js.pusher.com/4.4/pusher.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfobject/2.1.1/pdfobject.min.js" integrity="sha256-rYPX3dXq8Nh532EvCS2foeyTgmzbcC8u+nCk/rEtKXA=" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-timeago/1.6.3/jquery.timeago.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script src="https://printjs-4de6.kxcdn.com/print.min.js"></script>
<script src="<?php echo base_url('resources')?>/lockminds/js/lmscripts.js" type="text/javascript"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/numeral.js/2.0.6/numeral.min.js"></script>
<!--begin::Page Scripts(used by this page) -->

<!-- Begin: Asset appreciation Modal -->
<div class="modal fade" id="appreciation" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'appreciate-asset-form');
        echo form_open('', $attr );?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Asset Appreciation Calculator</h3>
            </div>
            <div class="modal-body">

            </div>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Appreciate</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: Asset appreciation Modal -->

<div class="modal fade" id="AssetRules" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongTitle">Asset Types</h5>
                </button>
            </div>
            <div class="modal-body text-back">
                <table class="table">
                    <tbody>
                    <?php if(!empty($rules)){
                        foreach ($rules as $key => $rule) {?>
                            <tr>
                                <td><?php echo 1 + $key;;?></td>
                                <td>
                                    <?php
                                    echo $rule['rule_name'];
                                    if($rule['rule_default'] ==1){?> &nbsp <span class="badge badge-warning"><b>Active</b></span><?php }?>
                                </td>
                            </tr>
                        <?php }
                    } else{?>
                        <tr>
                            <td>No data is avaialable</td>
                        </tr>
                    <?php }?>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer bg-dark">
                <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
</div>

<div class="modal fade" id="AssetTypes" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongTitle">Asset Types</h5>
                </button>
            </div>
            <div class="modal-body text-back">
                <table class="table">
                    <tbody>
                    <?php if(!empty($types)){
                        foreach ($types as $key => $type) {?>
                            <tr>
                                <td><?php echo 1 + $key;;?></td>
                                <td><?php //echo $type['actype_name'];?></td>
                            </tr>
                        <?php }
                    } else{?>
                        <tr>
                            <td>No data is avaialable</td>
                        </tr>
                    <?php }?>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer bg-dark">
                <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
</div>

<div class="modal fade" id="assetDetails" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
                <h5 class="modal-title text-white" id="exampleModalLongTitle">Asset Details</h5>
                <a id="print" href="javascript:(0);" class=" modal-title text-white" style="right:60px; position:absolute;">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M16,17 L16,21 C16,21.5522847 15.5522847,22 15,22 L9,22 C8.44771525,22 8,21.5522847 8,21 L8,17 L5,17 C3.8954305,17 3,16.1045695 3,15 L3,8 C3,6.8954305 3.8954305,6 5,6 L19,6 C20.1045695,6 21,6.8954305 21,8 L21,15 C21,16.1045695 20.1045695,17 19,17 L16,17 Z M17.5,11 C18.3284271,11 19,10.3284271 19,9.5 C19,8.67157288 18.3284271,8 17.5,8 C16.6715729,8 16,8.67157288 16,9.5 C16,10.3284271 16.6715729,11 17.5,11 Z M10,14 L10,20 L14,20 L14,14 L10,14 Z" id="Combined-Shape" fill="#000000"/>
                            <rect id="Combined-Shape-Copy" fill="#000000" opacity="0.3" x="8" y="2" width="8" height="2" rx="1"/>
                        </g>
                    </svg>
                </a>
                <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                            <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                            <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                        </g>
                    </svg></a>
            </div>
            <div class="modal-body text-back" id="printArea">

            </div>
            <div class="modal-footer bg-dark">
                <small> &copy <?php echo date('Y') ;?> Lockminds BMS | Asset details</small>
            </div>
        </div>
    </div>
</div>
</div>

<script>
    $(function () {
        $("select").select2({
            placeholder: "Select Option",
            allowClear: true
        })

        $("#appreciate").on('show.bs.modal', function (event) {
            var yStart = $('input#app_start').val(); 
            var getEnd = new Date(yStart);
            alert(yStart);
            //$("form#appreciate-asset-form").resetForm();
        })

        $("form#appreciate-asset-form").submit( function(event){
            const  form = $(this);
            event.preventDefault();
            let formData = form.serialize();
            let dateStart = $('input#app_start').val();
            let dateEnd = $('input#app_end').val();

            let dateStartDisplay = new Date(dateStart);
            let dateEndDisplay = new Date(dateEnd);
            let getStartYear = dateStartDisplay.getFullYear();
            let getEndYear = dateEndDisplay.getFullYear();
            if(getEndYear <= getStartYear){
                $('#targetError').css('display','block');
            }
            else{
                $('#targetError').css('display','none');
                $.ajax({
                    url: "<?php echo base_url('accounting/assets/calculateAppreciation');?>",
                    data: formData,
                    type: "post",
                    beforeSend: function(){
                        KTApp.block(form,{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Performing asset appreciation, Please wait ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblock(form);
                        if( result.status === true){
                            $("td#finVal").html(result.finVal);
                            $("td#finValRate").html(result.appRate + '%');
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock(form);
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'danger');
                        <?php }?>
                    }

                })
            }
        });

        $('input#app_rate').keyup(function (){
            alert('yes');
            let newRate = $(this).val();
            let yearStart = $('input#app_start').val();
            let yearEnd = $('input#app_end').val();
            let assetCost = $('input#asset_cost').val();
            if(newRate === ''){
                $('#rateRequired').css('display','block');
            }
            else if(yearEnd === ''){
                $('#targetRequired').css('display','block');
            }
            else {
                $('#targetRequired').css('display','none');
                $('#rateRequired').css('display','none');
                $.ajax({
                    url: "<?php echo base_url('accounting/assets/calculateAppreciation');?>",
                    data: {
                        "app_start" : yearStart,
                        "app_end" : yearEnd,
                        "asset_cost" : assetCost,
                        "app_rate" : newRate,
                    },
                    type: "post",
                    success: function(result){
                        if( result.status === true){
                            $("td#finVal").html(result.finVal);
                            $("td#finValRate").html(result.appRate + '%');
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    }
                })
            }

        });
        $('input#app_end').change(function (){
            alert('changed');
            let yearEnd = $(this).val();
            let yearStart = $('input#app_start').val();
            let assetCost = $('input#asset_cost').val();
            let appRate = $('input#app_rate').val();

            let dateStartDisplay = new Date(yearStart);
            let dateEndDisplay = new Date(yearEnd);
            let getStartYear = dateStartDisplay.getFullYear();
            let getEndYear = dateEndDisplay.getFullYear();

            if(getEndYear <= getStartYear){
                $('#targetError').css('display','block');
            }
            else if(appRate ===''){
                $('p#rateRequired').css('display','block');
            }
            else {
                $('p#rateRequired').css('display','none');
                $('#targetError').css('display','block');
                $.ajax({
                    url: "<?php echo base_url('accounting/assets/calculateAppreciation');?>",
                    data: {
                        "app_start" : yearStart,
                        "app_end" : yearEnd,
                        "asset_cost" : assetCost,
                        "app_rate" : appRate,
                    },
                    type: "post",
                    success: function(result){
                        if( result.status === true){
                            $("td#finVal").html(result.finVal);
                            $("td#finValRate").html(result.appRate + '%');
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    }
                })
            }

        });
    })

    function deleteasset(asset) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('/assets/delete/asset')?>/' + asset,
                    type: 'get',
                    beforeSend: function () {
                        KTApp.block(".kt-datatable", {
                            overlayColor: "#000000",
                            type: "loader",
                            state: "danger",
                            message: "Deleting asset ..."
                        });
                    },
                    success: function (result) {
                        let obj = JSON.parse(result);
                        if (obj.status == 'ok') {
                            Swal.fire('', obj.message, 'success');
                            $('.kt-datatable').KTDatatable('reload');
                        } else {
                            Swal.fire('', obj.message, 'warning');
                        }
                        KTApp.unblock('.kt-datatable');
                        KTApp.unblock('.kt-datatable');
                    },
                    error: function (xhr) {
                        KTApp.unblock('.kt-datatable');
                        Swal.fire('', xhr.statusText, 'warning');
                    }
                });
            }
        })
    }

    function assetDetails(asset) {
        let $modal = $('div#assetDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('/assets/assetdetails/');?>' + asset,
            type: 'get',
            beforeSend: function () {
                KTApp.block($div, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Loading asset details ...."
                });
            },
            success: function (result) {
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr) {
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('', xhr.statusText, 'warning');
            }
        })
    }

    function modifyasset(asset) {
        let $modal = $('div#assetDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('/assets/assetmodify/');?>' + asset,
            type: 'get',
            beforeSend: function () {
                KTApp.block($div, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Loading asset details ...."
                });
            },
            success: function (result) {
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr) {
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('', xhr.statusText, 'warning');
            }
        })
    }

    document.querySelector("#print").addEventListener("click", function () {
        printJS({
            printable: 'printArea',
            type: 'html',
            header: '<?php echo config_item('application_name');?> - asset Details',
            css: '<?php echo base_url('resources')?>/assets/demo/default/base/style.bundle.css',
            'style': 'link{text-decoration:none;}'
        });
    });
</script>

<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>