<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<!-- end::Head -->

<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topToolBarAssets('assets'); ?>

    <!-- begin:: Content -->
    <div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">

        <div class="kt-portlet kt-portlet--tabs" data-portlet="true">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">
                        Asset Types
                    </h3>
                </div>
                <div class="kt-portlet__head-toolbar">
                    <ul class="nav nav-tabs nav-tabs-bold nav-tabs-line   nav-tabs-line-right nav-tabs-line-brand" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#asset-type-list" role="tab" aria-selected="false">
                                Assets Types
                            </a>
                        </li>
                        <!--<li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#freights-list-bin" role="tab" aria-selected="true">
                                Recycle Bin
                            </a>
                        </li>-->
                    </ul>
                </div>
            </div>
            <div class="kt-portlet__body kt-portlet__body--fullheight">
                <div class="tab-content">
                    <div class="tab-pane  active" id="asset-type-list">
                        <table class="table " id="asset-type-list-table">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Type</th>
                                <th>Category</th>
                                <th>Account</th>
                                <th>Depriciation Rate %</th>
                                <th>Actions</th>

                            </tr>
                            </thead>
                        </table>
                    </div>
                    <!--<div class="tab-pane" id="freights-list-bin">
                        <table id="freights-list-bin-table" class="table">
                            <thead>
                            <tr>
                                <th>ID #</th>
                                <th>Importer</th>
                                <th>Country of Destination</th>
                                <th>Date</th>
                                <th>Invoice Number</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>-->
                </div>
            </div>
        </div>


    </div>
    <!-- end:: Content -->
</div>

<?php include VIEWPATH.'includes/footer.php'; ?>
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script>
    var assetTypes = $('#asset-type-list-table');
    if(assetTypes != undefined){
        // begin stages table
        assetTypes.DataTable({
            "ordering": false,
            responsive: true,
            buttons: [
                'print',
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5',
            ],
            dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
            searchDelay: 500,
            processing: false,
            serverSide: false,
            ajax: '<?php echo base_url( 'accounting/assets/datasourceassettypes');?>',
            columns: [
                {data: 'asset_type_id'},
                {data: 'asset_type_name'},
                {data: 'category_name'},
                {data: 'account_name'},
                {data: 'asset_type_value'}
            ],
            columnDefs: [
                {
                    targets: 5,
                    render: function(data, type, full, meta){
                            return '<a data-key="' + full.asset_type_key + '" href="<?= base_url('accounting/assets/assettypedetails/')?>'+ full.asset_type_key +'"><i class="la la-edit kt-font-success"></i> Modify</a>\n';
                    }
                }
            ],
        });

    }
</script>
<script>

    "use strict";
    // Class definition

    var KTDefaultDatatableDemo = function () {
        // Private functions

        // basic demo
        var demo = function () {

            var options = {
                // datasource definition
                data: {
                    type: 'remote',
                    source: {
                        read: {
                            url: '<?php echo base_url( 'accounting/assets/datasourceassettypes');?>',
                        },
                    },
                    pageSize: 10, // display 20 records per page
                    serverPaging: true,
                    serverFiltering: true,
                    serverSorting: true,
                },

                // layout definition
                layout: {
                    scroll: false, // enable/disable datatable scroll both horizontal and vertical when needed.
                    //height: 400, // datatable's body's fixed height
                    footer: false, // display/hide footer
                },

                // column sorting
                sortable: true,

                pagination: true,

                search: {
                    input: $('#generalSearch'),
                },

                // columns definition
                columns: [
                    {
                        field: 'asset_type_id',
                        title: '#',
                        sortable: false,
                        width: 30,
                        type: 'number',
                        selector: {class: 'kt-checkbox--solid'},
                        textAlign: 'center',
                        locked: {left: 'lg'},
                    },
                    {
                        field: 'asset_type_name',
                        title: 'Type',
                        template: function (row) {
                            return row.asset_type_name;
                        },
                        locked: {left: 'lg'},
                    },
                    {
                        field: 'category_name',
                        title: 'Category',
                        template: function (row) {
                            return row.category_name;
                        },
                    }, {
                        field: 'account_name',
                        title: 'Account',
                        template: function (row) {
                            return row.account_name;
                        },
                    },
                    {
                        field: 'asset_type_value',
                        title: 'Depriciation Rate %',
                        template: function (row) {
                            return row.asset_type_value;
                        },
                    },
                    {
                        field: 'Actions',
                        title: 'Actions',
                        sortable: false,
                        width: 80,
                        overflow: 'visible',
                        autoHide: false,
                        locked: {right: 'lg'},
                        template: function (row) {
                            return '\
    						<a href="<?php echo base_url('accounting/assets/assettypedetails/');?>' + row.asset_type_key + '" class="btn btn-sm btn-clean btn-icon btn-icon-md" title="Details">\
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">\
                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">\
                        <rect id="bound" x="0" y="0" width="24" height="24"/>\
                        <circle id="Combined-Shape" fill="#000000" opacity="0.3" cx="12" cy="12" r="10"/>\
                        <path d="M12,11 C10.8954305,11 10,10.1045695 10,9 C10,7.8954305 10.8954305,7 12,7 C13.1045695,7 14,7.8954305 14,9 C14,10.1045695 13.1045695,11 12,11 Z M7.00036205,16.4995035 C7.21569918,13.5165724 9.36772908,12 11.9907452,12 C14.6506758,12 16.8360465,13.4332455 16.9988413,16.5 C17.0053266,16.6221713 16.9988413,17 16.5815,17 L7.4041679,17 C7.26484009,17 6.98863236,16.6619875 7.00036205,16.4995035 Z" id="Combined-Shape" fill="#000000" opacity="0.3"/>\
                    </g>\
                </svg>\
    						</a>\
    					';
                        },
                    }],

            };

            var datatable = $('.taxesContainer').KTDatatable(options);

            $('#tax_classes,').selectpicker();

        };

        return {
            // public functions
            init: function () {
                demo();
            },
        };
    }();
    jQuery(document).ready(function () {
        KTDefaultDatatableDemo.init();
    });
</script>
<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>