<script type="text/javascript">

    var LMDatatableAssets = function () {
        var initTable = function () {
            // begin first table
            var table = $('#lm_table_assets').DataTable({
                responsive: true,
                // Pagination settings
                dom: `<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                pageLength: 10,
                language: {
                    'lengthMenu': 'Display _MENU_',
                    buttons: {
                        selectAll: "Select all",
                        selectNone: "Select none"
                    },
                    "emptyTable": "No record found",
                },
                searchDelay: 500,
                processing: true,
                serverSide: true,
                select: false,
                "ajax": "<?php echo base_url('accounting/assets/datasource');?>",
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
    			<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                buttons: [
                    {
                        text: 'Delete Seleted',
                        action: function (e, dt, node, config) {
                            deleteSelected(table);
                        }
                    },
                    'selectAll',
                    'selectNone',
                    'excelHtml5',
                    'pdfHtml5',
                ],
                columns: [
                    {data: 'asset_serial'},
                    {data: 'asset_type_name'},
                    {data: 'asset_total_cost'},
                    {data: 'asset_date'},
                ],
                columnDefs: [
                    {
                        targets: 0,
                        render: function (data, type, full, meta) {
                            return '<a href="<?php echo base_url('accounting/assets/details/');?>' + full.asset_key + '">' + ucfirst(data) + '</a>';
                        }
                    },
                    {
                        targets: 1,
                        render: function (data, type, full, meta) {
                            return ucfirst(data);
                        }
                    },
                    {
                        targets: 2,
                        render: function (data, type, full, meta) {
                            return KTUtil.numberString(to_money(data));
                        }
                    },
                    {
                        targets: 4,
                        render: function (data, type, full, meta) {
                            return ' <a href="javascript:deleteItem(' + full.asset_key + ');"><i class="flaticon-delete text-danger"></i></a>';
                        }
                    }
                ],
            });
        };

        return {
            //main function to initiate the module
            init: function () {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function () {
        $('select').css('width', '100%');
        $('select').select2({placeholder: 'select option'});
        let height = $(window).innerHeight() - 250;
        $('.lm_max_height').css({height: height});
        $(window).resize(function () {
            $('.lm_max_height').css({height: height});
        });
        LMDatatableAssets.init();

        $('form#formUpdate').submit(function (event) {
            let form = $(this);
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('accounting/assets/updateassetdetails')?>',
                type: 'post',
                data: formdata,
                beforeSend: function () {
                    KTApp.block(form, {
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Updating asset ...."
                    });
                },
                success: function (r) {
                    var obj = JSON.parse(r);
                    if (obj.status == 'ok') {
                        notifySuccess(obj.message);
                    } else {
                        Swal.fire('', obj.message, 'warning');
                    }
                    KTApp.unblock(form);
                },
                error: function () {
                    KTApp.unblock(form);
                }
            });
        })

        $('form#newAccountForm').submit(function (event) {
            let form = $(this);
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('accounting/assets/newaccount/')?>',
                type: 'get',
                data: formdata,
                beforeSend: function () {
                    KTApp.block("form#newAccountForm", {
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "creating new Account ...."
                    });
                },
                success: function (r) {
                    var obj = JSON.parse(r);
                    if (obj.status == 'ok') {
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables({api: true});
                        table.clear().draw();
                    } else {
                        Swal.fire('', obj.message, 'warning');
                    }
                    $('div#newAccount').modal('hide');
                    KTApp.unblock('form#newAccountForm');
                },
                error: function () {
                    KTApp.unblock('form#newAccountForm');
                    $('div#newAccount').modal('hide');
                }
            });
        })

    });

    function deleteItem(account) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/assets/delete/account')?>/' + account,
                    type: 'get',
                    beforeSend: function () {
                        KTApp.block("#lm_table_assets", {
                            overlayColor: "#000000",
                            type: "loader",
                            state: "danger",
                            message: "Deleting Asset ..."
                        });
                    },
                    success: function (result) {
                        let obj = JSON.parse(result);
                        if (obj.status == 'ok') {
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.clear().draw();
                        } else {
                            Swal.fire('', obj.message, 'warning');
                        }
                        KTApp.unblock('#lm_table_assets');
                    },
                    error: function (xhr) {
                        KTApp.unblock('#lm_table_assets');
                        Swal.fire('', xhr.statusText, 'warning');
                    }
                });
            }
        })
    }

    function deleteSelected(table) {
        if (table.rows('.selected').data().length < 1)
            return;
        var data = [];
        $.each(table.rows('.selected').data(), function () {
            data.push(this["asset_key"]);
        });
        Swal.fire({
            title: 'Are you sure?',
            text: "You are going to DELETE " + table.rows('.selected').data().length + " assets",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete them!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/assets/deleteselected/');?>',
                    type: 'get',
                    data: {'data': data},
                    beforeSend: function () {
                        KTApp.blockPage({
                            overlayColor: "#000000",
                            type: "loader",
                            state: "danger",
                            message: "Please wait ..."
                        });
                    },
                    success: function (result) {
                        let obj = JSON.parse(result);
                        if (obj.status == 'ok') {
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.clear().draw();
                        } else {
                            Swal.fire('', obj.message, 'warning');
                        }
                        KTApp.unblockPage();
                    },
                    error: function (xhr) {
                        KTApp.unblockPage();
                        Swal.fire('', xhr.statusText, 'warning');
                    }
                });
            }
        })
    }

</script>