<h3 class="kt-font-brand">Journal Entry | Expense</h3><hr/>
<?php
$lm =& get_instance();
$budgets = $lm->expensesBudgetsModel->budgets();
$categories = $lm->expensesCategoriesModel->categories();
$accounts = $lm->accountingModel->cashAccounts();

 echo form_open('#',['id'=>'saveexpense','onsubmit'=>'saveexpense(); return false;']);
//if(requireAuth()){?>
    <div class="row">
        <div class="col-12 alert alert-danger alert-dismissible fade show   m-alert m-alert--air m-alert--outline m-alert--outline-2x">
            <input required type="password" class="form-control" placeholder="Enter administrator password" name="passwd">
        </div>
    </div>
<?php //} ?>

<div class="row form-group">
    <div class="col-md-4 col-sm-12">
        <select name="expense_budget" class="form-control" required style="width: 100%;" >
            <option value="">Select Budget</option>
            <?php if(!empty($budgets)){
                foreach ($budgets as $b => $budget){?>
                    <option <?php if($expense->expense_budget == $budget['budget_key']) echo 'selected';?> value="<?php echo $budget['budget_key'];?>"><?php echo $budget['budget_title'];?></option>
                <?php }
            } ?>
        </select>
    </div>
    <div class="col-md-4 col-sm-12" >
        <select name="expense_category" class="form-control" required id="expense-categories" style="width: 100%;">
            <option value="">Select Category</option>
            <?php if(!empty($categories)){
                foreach ($categories as $b => $category){?>
                    <option <?php if($expense->expense_category == $category['category_key']) echo 'selected';?> value="<?php echo $category['category_key'];?>"><?php echo $category['category_title'];?></option>
                <?php }
            } ?>
        </select>
    </div>
    <div class="col-md-4 col-sm-12" id="expense-types">
        <select name="expense_type" class=" form-control" required style="width: 100%;">
            <option value="">Select Type</option>
            <option selected value="<?php echo $expense->expense_type;?>"><?php echo $expense->type_title;?></option>
        </select>
    </div>
</div>
<div class="row form-group">
    <div class="col-md-4 col-sm-12">
        <input type="text" required value="<?php echo number_format(to_money($expense->expense_amount));?>" name="expense_amount" placeholder="Expense Amount " class="form-control number" />
    </div>
    <div class="col-md-4 col-sm-12">
        <input type="text" required  value="<?php echo number_format(to_money($expense->expense_paid));?>" name="expense_paid" placeholder="Expense Paid" class="form-control number" />
    </div>
    <div class="col-md-4 col-sm-12" >
        <select name="expense_withdraw_account" class="form-control" required style="width: 100%;">
            <option value="">Withdraw Account</option>
            <?php if(!empty($accounts)){
                foreach ($accounts as $b => $acc){?>
                    <option <?php if($expense->expense_withdraw_account == $acc['account_id']) echo 'selected';?> value="<?php echo $acc['account_id'];?>"><?php echo $acc['account_name'];?></option>
                <?php }
            } ?>
        </select>
    </div>
</div>
<div class="row form-group">
    <div class="col-md-4 col-sm-12">
        <select required name="expense_status" class="form-control">
            <option <?php if($expense->expense_status == "Pending") echo 'selected';?> value="Pending">Pending</option>
            <option <?php if($expense->expense_status == "Approved") echo 'selected';?>  value="Approved">Approved</option>
            <option <?php if($expense->expense_status == "Rejected") echo 'selected';?>  value="Rejected">Rejected</option>
            <option <?php if($expense->expense_status == "Pending Reject") echo 'selected';?>  value="Pending Reject">Pending Reject</option>
        </select>
    </div>
    <div class="col-md-4 col-sm-12">
        <input type="date" required  name="expense_date_posted" placeholder="Date posted" class="form-control" value="<?php echo date("Y-m-d",strtotime($expense->expense_date_posted));?>" />
    </div>
    <div class="col-md-4 col-sm-12">
        <input type="text" required  name="expense_payee" placeholder="Enter Expense payee" class="form-control" value="<?php echo $expense->expense_payee;?>" />
    </div>
</div>
<div class="row form-group">
    <div class="col-12">
        <textarea required name="expense_details" class="form-control" placeholder="Enter expense description" ><?php echo nl2br($expense->expense_details);?></textarea>
    </div>
</div>
<?php if($files = $this->expensesModel->expenseDocs($expense->expense_key)){?>
    <div class="row ">
            <?php foreach ($files as $key =>  $file){?>
                <div class="col-md-4 col-sm-12" id="expenseFile-<?php echo $file['doc_id'];?>">
                            <div class="alert alert-outline-dark alert-bold" role="alert">
                                <div class="alert-text" >
                                    <a href="<?php echo base_url('uploads/expenses/'.$file['doc_name']);?>" download><b><?php echo $key+1;?>: View file&nbsp;</b></a>
                                    <a class="pull-right" href="javascript:deleteExpenseFile(<?php echo $file['doc_id'];?>);">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon kt-svg-icon--danger ">
                                        <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                            <rect id="bound" x="0" y="0" width="24" height="24"/>
                                            <path d="M22,7 L22,9 L19,9 C18.4477153,9 18,9.44771525 18,10 L18,13 C18,13.5522847 18.4477153,14 19,14 L22,14 L22,16 L19,16 C17.3431458,16 16,14.6568542 16,13 L16,10 C16,8.34314575 17.3431458,7 19,7 L22,7 Z" id="Path-52" fill="#000000" fill-rule="nonzero" opacity="0.3" transform="translate(19.000000, 11.500000) scale(-1, 1) translate(-19.000000, -11.500000) "/>
                                            <path d="M4.75777452,5 C5.56503586,3.79401426 6.93979195,3 8.5,3 C10.0602081,3 11.4349641,3.79401426 12.2422255,5 L4.75777452,5 Z" id="Combined-Shape" fill="#000000" opacity="0.3"/>
                                            <path d="M7,5 C7,2.790861 8.790861,1 11,1 C13.209139,1 15,2.790861 15,5 L7,5 Z" id="Combined-Shape" fill="#000000" opacity="0.3"/>
                                            <path d="M12.0500091,5 C12.2816442,3.85887984 13.290521,3 14.5,3 C15.709479,3 16.7183558,3.85887984 16.9499909,5 L12.0500091,5 Z" id="Combined-Shape" fill="#000000" opacity="0.3"/>
                                            <path d="M8,8 L8,8 C8.55228475,8 9,8.44771525 9,9 L9,18 C9,18.5522847 8.55228475,19 8,19 L8,19 C7.44771525,19 7,18.5522847 7,18 L7,9 C7,8.44771525 7.44771525,8 8,8 Z M13,8 L13,8 C13.5522847,8 14,8.44771525 14,9 L14,18 C14,18.5522847 13.5522847,19 13,19 L13,19 C12.4477153,19 12,18.5522847 12,18 L12,9 C12,8.44771525 12.4477153,8 13,8 Z M4.06055214,5 L16.9394479,5 C17.4917326,5 17.9394479,5.44771525 17.9394479,6 C17.9394479,6.01958668 17.9388724,6.03916914 17.9377222,6.05872202 L17.1107386,20.117444 C17.0485547,21.1745693 16.1731425,22 15.1141898,22 L5.88581016,22 C4.82685754,22 3.95144525,21.1745693 3.88926141,20.117444 L3.06227777,6.05872202 C3.02984649,5.50739031 3.4504984,5.0341569 4.00183012,5.00172563 C4.021383,5.00057546 4.04096546,5 4.06055214,5 Z" id="Combined-Shape" fill="#000000"/>
                                        </g>
                                    </svg>
                                    </a>
                                </div>
                            </div>
                </div>
            <?php } ?>
    </div>
<?php } ?>
<div class="row form-group">
    <div class="col-12">
        <div class="m-dropzone dropzone m-dropzone--primary dz-clickable"  id="expense-docs">
            <div class="m-dropzone__msg dz-message needsclick">
                <h3 class="m-dropzone__msg-title">Drop files here or click to upload.</h3>
                <span class="m-dropzone__msg-desc">Upload up to 10 files</span>
            </div>
        </div>
    </div>
</div>
<div class="row form-group">
    <div class="col-md-4 col-sm-12"></div>
    <div class="col-md-4 col-sm-12">
        <button type="button" data-dismiss="modal" class="btn btn-dark btn-block text-uppercase">Close</button>
    </div>
    <div class="col-md-4 col-sm-12">
        <button type="submit" class="btn btn-success btn-block text-uppercase">Update Expense</button>
    </div>
</div>
<input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />

<?php form_close();?>
<script>

    $('select').select2();

    $('select#expense-categories').change( function(){
        let val = $( this ).val();
        if(val == '')
            return;
        let form =  $('form#expense-form');
        let types = $('div#expense-types');

        $.ajax({
            url: '<?php echo base_url($auth_role.'/expenses/index/getselecttypes/');?>' + val ,
            type: 'get',
            beforeSend: function(){
                mApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading ..."
                });
            },
            success: function (result){
                types.html(result);
                mApp.unblock(form);
            },
            error: function (xhr){
                mApp.unblock(form);
                Swal('',xhr.statusText,'warning');
            }
        })
    })

    function saveexpense(){
        let form = $('form#saveexpense');
        let formData = form.serialize();
        $.ajax({
            url: '<?php echo base_url($auth_role.'/expenses/index/saveexpense/'.$expense->expense_key);?>',
            type: 'get',
            data: formData,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Please wait ..."
                });
            },
            success: function (response){
                KTApp.unblock(form);
                if(response.status == true){
                    $('.modal').modal('hide') // closes all active pop ups.
                    $('.modal-backdrop').remove() // removes the grey overlay.
                    notifySuccess(response.message);
                    let table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire("Server response",response.message,"warning");
                }
            },
            error: function (xhr){
                KTApp.unblock(form);
                Swal.fire("Server response ","Server issue occurred please try again later or contact support: <?php echo config_item("server_level_support");?>","warning");
            }
        })
    }

    (function($, undefined) {

        "use strict";

        // When ready.
        $(function() {

            var $input = $( "input.number" );

            $input.on( "keyup", function( event ) {

                // When user select text in the document, also abort.
                var selection = window.getSelection().toString();
                if ( selection !== '' ) {
                    return;
                }

                // When the arrow keys are pressed, abort.
                if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
                    return;
                }

                var $this = $( this );

                // Get the value.
                var input = $this.val();

                var input = input.replace(/[\D\s\._\-]+/g, "");
                input = input ? parseInt( input, 10 ) : 0;

                $this.val( function() {
                    return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
                } );
            } );

        });
    })(jQuery);

    function deleteExpenseFile(file){
        let cont = $("div#expenseFile-" + file);
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url($auth_role.'/expenses/index/deletefile')?>/' + file,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Please wait ..."
                        });
                    },
                    success: function(response){
                        KTApp.unblockPage();
                        if(response.status == true){
                            notifySuccess(response.message);
                            cont.hide();
                        }else{
                            Swal.fire("Server response",response.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        Swal.fire("Server response "  + xhr.statusText,"Server issue occured please try again later or contact support: <?php echo config_item("server_level_support");?>","warning");
                    }
                });
            }
        })
    }
    Dropzone.autoDiscover = false;
    var options = {
        url: "<?php echo base_url($auth_role.'/expenses/index/uploadexpensedocs');?>",
        paramName: "file", // The name that will be used to transfer the file
        maxFiles: 10,
        maxFilesize: 3, // MB
        success: function(file, response){
            let oldValue = $('input#uploadedfiles').val();
            if(oldValue.length > 0){
                oldValue = oldValue + 'LM-55';
            }
            let newValue =  oldValue + response.files;
            $('input#uploadedfiles').val(newValue);
        },
    };
    var expsenseDocs = new Dropzone("div#expense-docs",options);
</script>

