<?php
$lm =& get_instance();
$budgets = $lm->expensesBudgetsModel->budgets();
$categories = $lm->expensesCategoriesModel->categories();
$accounts = $lm->accountingModel->accounts();
?>
<h3>Create General/Proper Journal </h3><hr/>
<?php echo form_open('#',['id'=>'journal-form','onsubmit'=>'journalform(); return false;']);?>
<div class="row form-group">
    <div class="col-md-6 col-sm-12">
        <input class="form-control " name="j_title" placeholder="Journal Title" required />
    </div>
    <div class="col-md-6 col-sm-12">
        <input class="form-control number" name="j_amount" placeholder="Amount" required />
    </div>
</div>
<div class="row form-group">
    <div class="col-md-6 col-sm-12">
        <input type="date" required  name="j_date" placeholder="Date posted" class="form-control" />
    </div>
    <div class="col-6">
        <select required name="j_status" class="form-control">
            <option value="">Select Status</option>
            <option  value="Approved">Approved</option>
            <option  value="Pending">Pending</option>
            <option  value="Rejected">Rejected</option>
            <option  value="Pending Reject">Pending Reject</option>
        </select>
    </div>
</div>

<div class="row form-group">
    <div class="col-6" >
        <select name="j_debit_account" class="form-control" required style="width: 100%;">
            <option value="">Debit Account</option>
            <?php if(!empty($accounts)){
                foreach ($accounts as $b => $acc){?>
                    <option value="<?php echo $acc['account_id'];?>"><?php echo $acc['account_name'];?></option>
                <?php }
            } ?>
        </select>
    </div>
    <div class="col-6" >
        <select name="j_credit_account" class="form-control" required style="width: 100%;">
            <option value="">Credit Account</option>
            <?php if(!empty($accounts)){
                foreach ($accounts as $b => $acc){?>
                    <option value="<?php echo $acc['account_id'];?>"><?php echo $acc['account_name'];?></option>
                <?php }
            } ?>
        </select>
    </div>
</div>
<div class="row form-group">
    <div class="col-4"></div>
    <div class="col-4">
        <button type="button" data-dismiss="modal" class="btn btn-dark btn-block text-uppercase">Cancel</button>
    </div>
    <div class="col-4">
        <button type="submit" class="btn btn-success btn-block text-uppercase">Submit</button>
    </div>
</div>
<?php form_close();?>
<script type="text/javascript">

    $( function(){
        $("select").select2();
    })

    function journalform(){
        let form = $('form#journal-form');
        let formData = form.serialize();
        $.ajax({
            url: '<?php echo base_url($auth_role.'/accounting/journals/getactions/registergeneral');?>',
            type: 'get',
            data: formData,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Sending data ..."
                });
            },
            success: function (result){
                KTApp.unblock(form);
                if(result.status == true){
                    $('.modal').modal('hide') // closes all active pop ups.
                    $('.modal-backdrop').remove() // removes the grey overlay.
                    let table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                    notifySuccess(result.message);
                }else{
                    Swal.fire('',result.message,'warning');
                }
            },
            error: function (xhr){
                KTApp.unblock(form);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

</script>
<?php echo inputNumber();?>