<script type="text/javascript">

    "use strict";

    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    var Datatable = function() {

        var initTables = function() {
            var journals = $('#bms_journals');

            if(journals != undefined){
                // begin ledgers table
                journals.DataTable({
                    "ordering": false,
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: true,
                    serverSide: false,
                    ajax: '<?php echo base_url('accounting/journals/index/datasource');?>',
                    columns: [
                        {data: 'journal_id'},
                        {data: 'journal_title'},
                        {data: 'journal_date'},
                        {data: 'journal_type'},
                        {data: 'journal_status'},
                        {data: 'journal_status'},
                    ],
                    columnDefs: [
                        {
                            targets: 4,
                            render: function(data, type, full, meta) {
                                var status = {
                                    "APPROVED": {'journal_status': 'Approved', 'class': 'kt-font-bold kt-font-success'},
                                    "PENDING": {'journal_status': 'Pending', 'class': ' kt-font-bold kt-font-warning'},
                                    "REJECTED": {'journal_status': 'Rejected', 'class': ' kt-font-boldkt-font-danger'},
                                    "DRAFT": {'journal_status': 'Draft', 'class': ' kt-font-bold kt-font--dark'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }
                                return '<span class="' + status[data].class + '">' + status[data].journal_status + '</span>';
                            },
                        },
                        {
                            targets: 5,
                            render: function(data, type, full, meta) {
                                var status = {
                                    "APPROVED": {'journal_status': 'Approved', 'class': 'kt-badge--success'},
                                    "PENDING": {'journal_status': 'Pending', 'class': ' kt-badge--warning'},
                                    "REJECTED": {'journal_status': 'Rejected', 'class': ' kt-badge--danger'},
                                    "DRAFT": {'journal_status': 'Draft', 'class': ' kt-badge--dark'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return '<a href="<?php echo base_url('accounting/journals/details/');?>' + full.journal_key + '"><span class="kt-font-brand">View Details</span></a>';
                                }

                                if(full.journal_status != 'APPROVED' && full.journal_status != 'PENDING' && full.journal_status != 'REJECTED'){
                                    return '<a href="<?php echo base_url('accounting/journals/details/');?>' + full.journal_key + '"><span class="kt-font-brand">View Details</span></a> ' +
                                        '<div class="dropdown dropdown-inline">\n' +
                                        '   <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                        '    <i class="flaticon-more"></i>\n' +
                                        '     </span>\n' +
                                        '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                        '                                  <a class="dropdown-item" href="<?php echo base_url('accounting/journals/modify/');?>' + full.journal_key + '"><i class="la la-edit kt-font-success"></i> Modify</a>\n' +
                                        '                                <a class="dropdown-item" href="javascript:deleteJournal('+ full.journal_key  +');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n' +
                                        '                            </div>\n' +
                                        '                        </div>';
                                }else{
                                    return '<a href="<?php echo base_url('accounting/journals/details/');?>' + full.journal_key + '"><span class="kt-font-brand">View Details</span></a> ';
                                }

                            },
                        },
                    ],
                });

            }

            var journalsBin = $('#bms_journals_bin');

            if(journalsBin != undefined){
                // begin ledgers Bin table
                journalsBin.DataTable({
                    "ordering": false,
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                        <'row'<'col-sm-12'tr>>
                        <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: true,
                    serverSide: false,
                    ajax: '<?php echo base_url('accounting/journals/index/datasourcebin');?>',
                    columns: [
                        {data: 'journal_id'},
                        {data: 'journal_title'},
                        {data: 'journal_date'},
                        {data: 'journal_type'},
                        {data: 'journal_status'},
                        {data: 'journal_status'},
                    ],
                    columnDefs: [
                        {
                            targets: 4,
                            render: function(data, type, full, meta) {
                                var status = {
                                    "APPROVED": {'journal_status': 'Approved', 'class': 'kt-badge--success'},
                                    "PENDING": {'journal_status': 'Pending', 'class': ' kt-badge--warning'},
                                    "REJECTED": {'journal_status': 'Rejected', 'class': ' kt-badge--danger'},
                                    "DRAFT": {'journal_status': 'Draft', 'class': ' kt-badge--dark'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }
                                return '<span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline">' + status[data].journal_status + '</span>';
                            },
                        },
                        {
                            targets: 5,
                            render: function(data, type, full, meta) {
                                var status = {
                                    "APPROVED": {'journal_status': 'Approved', 'class': 'kt-badge--success'},
                                    "PENDING": {'journal_status': 'Pending', 'class': ' kt-badge--warning'},
                                    "REJECTED": {'journal_status': 'Rejected', 'class': ' kt-badge--danger'},
                                    "DRAFT": {'journal_status': 'Draft', 'class': ' kt-badge--dark'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }

                                if(full.journal_status == "DRAFT"){
                                    return '<a href="<?php echo base_url('accounting/journals/details/');?>' + full.journal_key + '"><span class="kt-font-brand">View Details</span></a>' +
                                        '<div class="dropdown dropdown-inline">\n' +
                                        '     <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                        '       <i class="flaticon-more"></i>\n' +
                                        '        </span>\n' +
                                        '         <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +

                                        '        <a class="dropdown-item" href="javascript:restoreJournal('+ full.journal_key  +');"><i class="la la-reply kt-font-success"></i> Restore</a>\n' +
                                        // '        <a class="dropdown-item" href="javascript:deleteForever('+ full.journal_key  +');"><i class="la la-trash kt-font-danger"></i> Delete Permanently</a>\n' +
                                        '       </div>\n' +
                                        '   </div>';
                                }else{
                                    return '<a href="<?php echo base_url('accounting/journals/details/');?>' + full.journal_key + '"><span class="kt-font-brand">View Details</span></a>';
                                }

                            },
                        },
                    ],
                });

            }

        };

        return {

            //main function to initiate the module
            init: function() {
                initTables();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });
</script>