<script type="text/javascript">

    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    var Datatable = function() {

        var initTables = function() {
            var ledgers = $('#bms_ledgers');

            if(ledgers != undefined){
                // begin ledgers table
                ledgers.DataTable({
                    "ordering": false,
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                        <'row'<'col-sm-12'tr>>
                        <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: true,
                    serverSide: true,
                    ajax: '<?php echo base_url('accounting/postings/index/datasource/'.$hash);?>',
                    columns: [
                        {data: 'gl_activity'},
                        {data: 'gl_date'},
                        {data: 'gl_category'},
                        {data: 'account_name'},
                        {data: 'account_number'},
                        {data: 'gl_debit'},
                        {data: 'gl_credit'},
                        {data: 'gl_status'},
                    ],
                    drawCallback: function(settings) {
                        var api = this.api();
                        var rows = api.rows({page: 'current'}).nodes();
                        var last = null;
                        api.column(0, {page: 'current'}).data().each(function(group, i) {
                            if (last !== group) {
                                $(rows).eq(i).before(
                                    '<tr class="group" style="height: 0px;">' +
                                    '<td colspan="8" cellpadding="0" cellspacing="0" style="height: 0px;"> </td>' +
                                    '</tr>',
                                );
                                last = group;
                            }
                        });
                    },
                    columnDefs: [
                        {
                            targets: 3,
                            render: function(data, type, full, meta) {
                                return  '<a  href="<?php echo base_url('accounting/account/history/');?>'+ full.account_key + '">' + full.account_name + '</a>';
                            },
                        },
                        {
                            targets: 4,
                            render: function(data, type, full, meta) {
                                return  '<a  href="<?php echo base_url('accounting/account/history/');?>'+ full.account_key + '">' + full.account_number + '</a>';
                            },
                        },{
                            targets: 5,
                            render: function(data, type, full, meta) {
                                return  KTUtil.numberString(to_money(full.gl_debit));
                            },
                        },{
                            targets: 6,
                            render: function(data, type, full, meta) {
                                return  KTUtil.numberString(to_money(full.gl_credit));
                            },
                        },
                        {
                            targets: 7,
                            render: function(data, type, full, meta) {
                                var status = {
                                    "APPROVED": {'gl_status': 'Approved', 'class': 'kt-badge--success'},
                                    "PENDING": {'gl_status': 'Pending', 'class': ' kt-badge--warning'},
                                    "REJECTED": {'gl_status': 'Rejected', 'class': ' kt-badge--danger'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }
                                return '<a href="javascript:(0);"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline">' + status[data].gl_status + '</span></a> ' +
                                    '<div class="dropdown dropdown-inline">\n' +
                                    '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '                                <i class="flaticon-more"></i>\n' +
                                    '                            </span>\n' +
                                    '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    '                                <a class="dropdown-item"  href="javascript:approveLedger('+ full.gl_key + ');"><i class="la la-toggle-off kt-font-success"></i> Approved</a>\n' +
                                    // '                                <a class="dropdown-item"  href="javascript:pendingLedger('+ full.gl_key +');"><i class="la la-toggle-off kt-font-warning"></i> Set Pending</a>\n' +
                                    '                                <div class="dropdown-divider"></div>' +
                                    '                                <a class="dropdown-item" href="javascript:deleteLedger('+ full.gl_key +');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n' +
                                    '                            </div>\n' +
                                    '                        </div>';
                            },
                        },
                    ],
                });

            }

            var ledgersBin = $('#bms_ledgers_bin');

            if(ledgersBin != undefined){
                // begin ledgers Bin table
                ledgersBin.DataTable({
                    "ordering": false,
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: true,
                    serverSide: true,
                    ajax: '<?php echo base_url('accounting/postings/index/datasourcebin/'.$hash);?>',
                    columns: [
                        {data: 'gl_activity'},
                        {data: 'gl_date'},
                        {data: 'gl_category'},
                        {data: 'account_name'},
                        {data: 'account_number'},
                        {data: 'gl_debit'},
                        {data: 'gl_credit'},
                        {data: 'gl_status'},
                    ],
                    drawCallback: function(settings) {
                        var api = this.api();
                        var rows = api.rows({page: 'current'}).nodes();
                        var last = null;
                        api.column(0, {page: 'current'}).data().each(function(group, i) {
                            if (last !== group) {
                                $(rows).eq(i).before(
                                    '<tr class="group" style="height: 0px;">' +
                                    '<td colspan="8" cellpadding="0" cellspacing="0" style="height: 0px;"> </td>' +
                                    '</tr>',
                                );
                                last = group;
                            }
                        });
                    },
                    columnDefs: [
                        {
                            targets: 3,
                            render: function(data, type, full, meta) {
                                return  '<a  href="<?php echo base_url('accounting/account/history/');?>'+ full.account_key + '">' + full.account_name + '</a>';
                            },
                        },
                        {
                            targets: 4,
                            render: function(data, type, full, meta) {
                                return  '<a  href="<?php echo base_url('accounting/account/history/');?>'+ full.account_key + '">' + full.account_number + '</a>';
                            },
                        },{
                            targets: 5,
                            render: function(data, type, full, meta) {
                                return  KTUtil.numberString(to_money(full.gl_debit));
                            },
                        },{
                            targets: 6,
                            render: function(data, type, full, meta) {
                                return  KTUtil.numberString(to_money(full.gl_credit));
                            },
                        },
                        {
                            targets: 7,
                            render: function(data, type, full, meta) {
                                var status = {
                                    "APPROVED": {'gl_status': 'Approved', 'class': 'kt-badge--success'},
                                    "PENDING": {'gl_status': 'Pending', 'class': ' kt-badge--warning'},
                                    "REJECTED": {'gl_status': 'Rejected', 'class': ' kt-badge--danger'},
                                    "PENDING REJECT": {'gl_status': 'Pending Rejected', 'class': ' kt-badge--dark'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }
                                return '<a href="javascript:(0);"><span class="kt-badge no-print' + status[data].class + ' kt-badge--wide kt-badge--inline ">' + status[data].gl_status + '</span></a> ' +
                                    '<div class="dropdown dropdown-inline">\n' +
                                    '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                    '                                <i class="flaticon-more"></i>\n' +
                                    '                            </span>\n' +
                                    '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    '                                <a class="dropdown-item"  href="javascript:restoreLedger('+ full.gl_key + ');"><i class="la la-reply kt-font-success"></i> Restore</a>\n' +
                                    // '                                <a class="dropdown-item"  href="javascript:deleteLedgerForever('+ full.gl_key + ');"><i class="la la-trash kt-font-danger"></i> Delete Permanently</a>\n' +
                                    '                            </div>\n' +
                                    '                        </div>';
                            },
                        },
                    ],
                });

            }

        };

        return {

            //main function to initiate the module
            init: function() {
                initTables();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });
</script>
