<form class="kt-form" id="createAccount" onsubmit="createAccount(); return false;">
    <div class="row">
        <div class="col-md-6">
            <div class="form-group">
                <label>Account Type</label>
                <select name="account_type"  class="form-control" id="accountTypesSelect" required>
                    <option value="" disabled selected>Select Type</option>
                    <?php if(!empty($types)){
                        foreach ($types as $i => $typ) {
                            print '<option value="'.$typ['type_key'].'">'.$typ['type_name'].'</option>';
                        }
                    }?>
                </select>
            </div>
            <div class="form-group">
                <div id="type_details">

                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <label>Name</label>
                <input class="form-control" placeholder="Account Name" required name="account_name" />
            </div>
            <div class="form-group">
                <label>Number</label>
                <input class="form-control" placeholder="Account Number"  name="account_number" />
            </div>
            <div class="form-group">
                <label>Description</label>
                <textarea class="form-control" placeholder="Description" required name="account_details" /> </textarea>
            </div>
            <div class="form-group">
                <label>Balance</label>
                <input class="form-control number" placeholder="Balance"  name="account_balance" />
                <input class="form-control" placeholder="Date" type="date"  name="balance_date" />
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-4 col-sm-6"><button data-dismiss="modal" class="btn btn-outline-dark pull-left">Cancel</button></div>
        <div class="col-md-4 col-sm-6"></div>
        <div class="col-md-4 col-sm-6"><button class="btn btn-outline-success  pull-right">Submit</button></div>
    </div>
</form>

<script type="text/javascript">
    $('select').select2({placeholder: "Select Option"});
    $("select[name='account_type']").change( function(event){
        const $this = $(this);
        const key = $this.val();
        let typeDetails = $("div#type_details");
        addSpinner(typeDetails);
        typeDetails.load('<?php echo base_url('accounting/registers/gettypedetails/');?>' + key, function( response, status, xhr ) {
            if ( status == "error" ) {
                <?php if(ENVIRONMENT !== 'production'){?>
                swal.fire("","An error occurred "+response,"warning");
                <?php }else{?>
                swal.fire("","An error occurred","warning");
                <?php }?>
            }
        });
    });

    function createAccount(){
        const  form = $("form#createAccount");
        let formData = form.serialize();
        $.ajax({
            url: "<?php echo base_url('accounting/chatofaccounts/createaccount');?>",
            type: "post",
            data: formData,
            beforeSend: function(){
                KTApp.block(form, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Processing ..."
                });
            },
            success: function(response){
                KTApp.unblock(form);
                if (response.status == true) {
                    $('#newAccount').modal("hide");
                    Swal.fire('', response.message, 'success');
                    let table = $.fn.dataTable.tables({api: true});
                    table.ajax.reload();
                } else {
                    Swal.fire('', response.message, 'warning');
                }
            },
            error: function(xhr){
                KTApp.unblock(form);
                <?php if(ENVIRONMENT !== 'production'){?>
                swal.fire("","An error occurred " + xhr.statusText,"warning");
                <?php }else{?>
                swal.fire("","An error occurred","warning");
                <?php }?>
            }
        })
    }

</script>
<?php echo inputNumber();?>
