<form class="kt-form" id="edit_account" onsubmit="editAccount(<?php echo $account->account_key;?>); return false;">
    <div class="row">
        <div class="col-md-6">
            <div class="form-group">
                <label>Account Type</label>
                <select name="account_type"  class="form-control" id="accountTypesSelect" required>
                    <option value="" disabled selected>Select Type</option>
                    <?php if(!empty($types)){
                        foreach ($types as $i => $typ) {?>
                            <option <?php  if($typ['type_key'] == $account->account_type) echo "selected";?> value="<?php echo $typ['type_key'];?>"><?php echo $typ['type_name'];?></option>
                       <?php  }
                    }?>
                </select>
            </div>
            <div class="form-group">
                <div id="type_details">
                    <div class="form-group">
                        <label>Type Details</label>
                        <select name="account_sub_type"  class="form-control" required>
                            <option value="" disabled selected>Select Option</option>
                            <?php if(!empty($subtypes)){
                                foreach ($subtypes as $i => $styp) {?>
                                    <option <?php  if($styp['subtype_key'] == $account->account_sub_type) echo "selected";?> value="<?php echo $styp['subtype_key'];?>"><?php echo $styp['subtype_name'];?></option>
                                <?php }
                            }?>
                        </select>
                    </div>
                    <div class="form-group" id="typeDesc" style="border-color: #dddddd; border: solid 1px; color: rgba(52,52,52,0.88); padding: 10px; border-radius: 3px;">
                        <?php echo $this->accountingModel->accountSubTypeDetails($account->account_sub_type)->subtype_details;?>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <label>Name</label>
                <input class="form-control" value="<?php echo $account->account_name;?>" placeholder="Account Name" required name="account_name" />
            </div>
            <div class="form-group">
                <label>Number</label>
                <input value="<?php echo $account->account_number;?>" class="form-control" placeholder="Account Number"  name="account_number" />
            </div>
            <div class="form-group">
                <label>Description</label>
                <textarea class="form-control" placeholder="Description" required name="account_details"><?php echo $account->account_details;?></textarea>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-4 col-sm-6"><button data-dismiss="modal" class="btn btn-outline-dark pull-left">Cancel</button></div>
        <div class="col-md-4 col-sm-6"></div>
        <div class="col-md-4 col-sm-6"><button type="submit" class="btn btn-outline-success  pull-right">Submit</button></div>
    </div>
</form>

<script type="text/javascript">
    $('select').select2({placeholder: "Select Option"});
    $("select[name='account_type']").change( function(event){
        const $this = $(this);
        const key = $this.val();
        let typeDetails = $("div#type_details");
        addSpinner(typeDetails);
        typeDetails.load('<?php echo base_url('accounting/registers/gettypedetails/');?>' + key, function( response, status, xhr ) {
            if ( status == "error" ) {
                <?php if(ENVIRONMENT !== 'production'){?>
                swal.fire("","An error occurred "+response,"warning");
                <?php }else{?>
                swal.fire("","An error occurred","warning");
                <?php }?>
            }
        });
    });

    function editAccount(account){
        const  form = $("form#edit_account");
        let formData = form.serialize();
        $.ajax({
            url: "<?php echo base_url('accounting/registers/updateaccount/');?>" + account,
            type: "post",
            data: formData,
            beforeSend: function(){
                KTApp.block(form, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Processing ..."
                });
            },
            success: function(response){
                KTApp.unblock(form);
                if (response.status == true) {
                    $('div#edit-account').modal("hide");
                    Swal.fire('', response.message, 'success');
                    let table = $.fn.dataTable.tables({api: true});
                    table.ajax.reload();
                } else {
                    Swal.fire('', response.message, 'warning');
                }
            },
            error: function(xhr){
                KTApp.unblock(form);
                <?php if(ENVIRONMENT !== 'production'){?>
                swal.fire("","An error occurred " + xhr.statusText,"warning");
                <?php }else{?>
                swal.fire("","An error occurred","warning");
                <?php }?>
            }
        })
    }

</script>


<?php echo inputNumber();?>
