<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    td {word-wrap: break-word}
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<!-- end:: Header -->
<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <!-- begin:: Subheader -->
    <?php settingsMenu() ?>
    <!-- end:: Subheader -->

    <!-- begin:: Content -->
    <div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">

        <!--Begin::App-->
        <div class="kt-grid kt-grid--desktop kt-grid--ver kt-grid--ver-desktop kt-app">

            <!--Begin:: App Aside Mobile Toggle-->
            <button class="kt-app__aside-close" id="kt_user_profile_aside_close">
                <i class="la la-close"></i>
            </button>

            <!--End:: App Aside Mobile Toggle-->

            <!--Begin:: App Aside-->
            <div class="kt-grid__item kt-app__toggle kt-app__aside col-md-2" id="kt_user_profile_aside">

                <!--begin:: Widgets/Applications/User/Profile1-->
                <div class="kt-portlet kt-portlet--height-fluid-">
                    <div class="kt-portlet__head  kt-portlet__head--noborder">
                        <div class="kt-portlet__head-label">
                            <h3 class="kt-portlet__head-title">
                            </h3>
                        </div>
                    </div>
                    <div class="kt-portlet__body kt-portlet__body--fit-y">

                        <!--begin::Widget -->
                        <div class="kt-widget kt-widget--user-profile-1">
                            <div class="kt-widget__head"></div>
                            <div class="kt-widget__body">
                                <div class="kt-widget__items">
                                    <?php accountingSettingsMenu($sub_link);?>
                                </div>
                            </div>
                        </div>

                        <!--end::Widget -->
                    </div>
                </div>

                <!--end:: Widgets/Applications/User/Profile1-->
            </div>

            <!--End:: App Aside-->

            <!--Begin:: App Content-->
            <div class="kt-grid__item kt-grid__item--fluid kt-app__content">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="kt-portlet">
                            <div class="kt-portlet__head">
                                <div class="kt-portlet__head-label">
                                    <h3 class="kt-portlet__head-title">Financial Periods Settings</h3>
                                </div>
                            </div>

                            <div class="kt-portlet kt-portlet--tabs" data-portlet="true">
                                <div class="kt-portlet__head">
                                    <div class="kt-portlet__head-label">
                                        <h3 class="kt-portlet__head-title">
                                            <a href="#financial-period" data-backdrop="false" data-toggle="modal" class="btn btn-outline-brand btn-sm" style="margin-left: 5px">Add New</a>
                                            <?php if(!empty($when = $this->input->get("when"))) echo '| <span class="kt-font-brand">'. ucfirst(datesWhen($when)['label'])."</span>";?>
                                        </h3>
                                    </div>
                                    <div class="kt-portlet__head-toolbar">
                                        <ul class="nav nav-tabs nav-tabs-bold nav-tabs-line   nav-tabs-line-right nav-tabs-line-brand" role="tablist">
                                            <li class="nav-item">
                                                <a class="nav-link active" data-toggle="tab" href="#financial-periods-list" role="tab" aria-selected="false">
                                                    List
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a class="nav-link" data-toggle="tab" href="#financial-periods-list-bin" role="tab" aria-selected="true">
                                                    Recycle Bin
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="kt-portlet__body kt-portlet__body--fullheight">
                                    <div class="tab-content">
                                        <div class="tab-pane  active" id="financial-periods-list">
                                            <table class="table" id="financial-periods-list-table">
                                                <thead>
                                                <tr>
                                                    <th>ID #</th>
                                                    <th>Financial Period Start</th>
                                                    <th>Financial Period End</th>
                                                    <th>Period Name</th>
                                                    <th>Action</th>
                                                </tr>
                                                </thead>
                                            </table>
                                        </div>
                                        <div class="tab-pane" id="financial-periods-list-bin">
                                            <table id="financial-periods-list-bin-table" class="table">
                                                <thead>
                                                <tr>
                                                    <th>ID #</th>
                                                    <th>Financial Period Start</th>
                                                    <th>Financial Period End</th>
                                                    <th>Period Name</th>
                                                    <th>Action</th>
                                                </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <?php echo form_open(current_url(),['class' => 'kt-form kt-form--label-right'])?>
                            <!--<div class="kt-portlet__body">
                                <div class="kt-section kt-section--first">
                                    <div class="kt-section__body">
                                        <div class="form-group row">
                                            <div class="col-md-6">
                                                <label>Source Account</label>
                                                <?php $accounts = $this->accountingModel->accounts(); ?>
                                                <select required name="setting_source_acc" class="form-control">
                                                    <option value="">Select Account</option>
                                                    <?php if(!empty($accounts)){
                                                        foreach ($accounts as $debit){ ?>
                                                            <option <?php if(!empty($settings) && $settings->setting_source_acc == $debit['account_key']) echo "selected";?> value="<?php echo $debit['account_key'];?>"><?= $debit['account_name'] ?></option>
                                                        <?php }
                                                    } ?>
                                                </select>
                                            </div>
                                            <div class="col-md-6">
                                                <label>Expense Account</label>
                                                <?php $accounts = $this->accountingModel->accounts(); ?>
                                                <select required name="setting_expense_acc" class="form-control">
                                                    <option value="">Select Account</option>
                                                    <?php if(!empty($accounts)){
                                                        foreach ($accounts as $credit){ ?>
                                                            <option <?php if(!empty($settings) && $settings->setting_expense_acc == $credit['account_key']) echo "selected";?> value="<?php echo $credit['account_key'];?>"><?= $credit['account_name'] ?></option>
                                                        <?php }
                                                    } ?>
                                                </select>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="kt-portlet__foot">
                                <div class="kt-form__actions">
                                    <div class="row">
                                        <div class="col-lg-3 col-xl-3">
                                        </div>
                                        <div class="col-lg-9 col-xl-9">
                                            <button type="submit" class="btn btn-success">Save Changes</button>&nbsp;
                                        </div>
                                    </div>
                                </div>
                            </div>-->
                            <?php echo form_close();?>
                        </div>
                    </div>
                </div>
            </div>

            <!--End:: App Content-->
        </div>

        <!--End::App-->
    </div>

    <!-- end:: Content -->
</div>
<!-- Begin: Add financial period Modal -->
<div class="modal fade" id="financial-period" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'financial-period-form');
        echo form_open('', $attr );?>
            <div class="modal-content">
                <div class="modal-header">
                    <h3>Add new financial period</h3>
                </div>
                <div class="modal-body">
                    <div class="kt-portlet__body">
                        <div class="form-group">
                            <label>Period Start</label>
                            <input type="date" name="fp_start" id="datePickerId" class="form-control kt-select2" id="kt_select2_3_modal" required>
                        </div>
                        <div class="form-group">
                            <label>Period End</label>
                            <input type="date" name="fp_end" id="datePickerId" class="form-control kt-select2" id="kt_select2_3_modal" required>
                        </div>
                        <div class="form-group">
                            <label>Period Name</label>
                            <input type="text" name="fp_prefix" class="form-control kt-select2" id="kt_select2_3_modal" placeholder="Eg. 2020/2021" required>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <div class="kt-form__actions">
                        <div class="row">
                            <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                            <div class="col-6">
                                <button type="submit" name="submit" class="btn btn-success pull-right">Add</button>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: Add financial period Modal -->

<!-- Begin: Modify financial period Modal -->
<div class="modal fade" id="modify-period" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'modify-period-form');
        echo form_open('', $attr );?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Modify financial period</h3>
            </div>
            <div class="modal-body">

            </div>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Save</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: Modify financial period Modal -->

<?php
include VIEWPATH.'includes/footer.php';
include VIEWPATH . 'accounting/settings/scripts.php';
?>
<!--begin::Global Theme Bundle(used by all pages) -->
<script src="<?php echo base_url();?>/resources/assets/plugins/global/plugins.bundle.js" type="text/javascript"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script src="<?php echo base_url();?>/resources/assets/js/scripts.bundle.js" type="text/javascript"></script>
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<script>

    function activateFinancial(key) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about activating financial period!",
            type: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Activate it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/settings/index/activate_period/')?>' + key,
                    type: 'get',
                    beforeSend: function () {
                        KTApp.blockPage({
                            overlayColor: "#000000",
                            type: "loader",
                            state: "danger",
                            message: "Activating Financial Period ..."
                        });
                    },
                    success: function (result) {
                        if (result.status == true) {
                            KTApp.unblockPage();
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.ajax.reload();
                        } else {
                            KTApp.unblockPage();
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.ajax.reload();
                        }
                    },
                    error: function (xhr) {
                        KTApp.unblockPage();
                        Swal.fire('Server Error', xhr.statusText, 'warning');
                        var table = $.fn.dataTable.tables({api: true});
                        table.ajax.reload();
                    }
                });
            }
        })
    }
    function deactivateFinancial(key) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about deactivating financial period!",
            type: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Deactivate it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/settings/index/deactivate_period/')?>' + key,
                    type: 'get',
                    beforeSend: function () {
                        KTApp.blockPage({
                            overlayColor: "#000000",
                            type: "loader",
                            state: "danger",
                            message: "Deactivating Financial Period ..."
                        });
                    },
                    success: function (result) {
                        if (result.status == true) {
                            KTApp.unblockPage();
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.ajax.reload();
                        } else {
                            KTApp.unblockPage();
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.ajax.reload();
                        }
                    },
                    error: function (xhr) {
                        KTApp.unblockPage();
                        Swal.fire('Server Error', xhr.statusText, 'warning');
                        var table = $.fn.dataTable.tables({api: true});
                        table.ajax.reload();
                    }
                });
            }
        })
    }
    function deleteFinancial(key) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about deleting financial period!",
            type: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/settings/index/delete_period/')?>' + key,
                    type: 'get',
                    beforeSend: function () {
                        KTApp.blockPage({
                            overlayColor: "#000000",
                            type: "loader",
                            state: "danger",
                            message: "Deactivating Financial Period ..."
                        });
                    },
                    success: function (result) {
                        if (result.status == true) {
                            KTApp.unblockPage();
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.ajax.reload();
                        } else {
                            KTApp.unblockPage();
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.ajax.reload();
                        }
                    },
                    error: function (xhr) {
                        KTApp.unblockPage();
                        Swal.fire('Server Error', xhr.statusText, 'warning');
                        var table = $.fn.dataTable.tables({api: true});
                        table.ajax.reload();
                    }
                });
            }
        })
    }
    function restoreFinancial(key) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about restoring financial period!",
            type: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/settings/index/restore_period/')?>' + key,
                    type: 'get',
                    beforeSend: function () {
                        KTApp.blockPage({
                            overlayColor: "#000000",
                            type: "loader",
                            state: "danger",
                            message: "Restoring Financial Period ..."
                        });
                    },
                    success: function (result) {
                        if (result.status == true) {
                            KTApp.unblockPage();
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.ajax.reload();
                        } else {
                            KTApp.unblockPage();
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.ajax.reload();
                        }
                    },
                    error: function (xhr) {
                        KTApp.unblockPage();
                        Swal.fire('Server Error', xhr.statusText, 'warning');
                        var table = $.fn.dataTable.tables({api: true});
                        table.ajax.reload();
                    }
                });
            }
        })
    }

    $(function () {
        $("#financial-period").on('show.bs.modal', function (event) {
            $("form#financial-period-form").resetForm();
        })

        $('#modify-period').on('show.bs.modal', function (event) {
            var modal = $(this)
            modal.find('.modal-body').html('Loading details ...');
            var button = $(event.relatedTarget)
            var key = button.data('key')
            //alert(key)
            modal.find('.modal-body').load('<?php echo base_url('accounting/settings/index/period_details');?>/' + key);
        })

        $("form#financial-period-form").submit( function(event){
            const  form = $(this);
            event.preventDefault();
            let formData = form.serialize();
            $.ajax({
                url: "<?php echo base_url('accounting/settings/index/periods');?>",
                data: formData,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Adding financial period, Please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    //window.location.reload();
                    if( result.status == true){
                        $("#financial-period").modal("hide");
                        notifySuccess(result.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.ajax.reload();

                    }else{
                        swal.fire("","An error occurred! "+ result.message,"warning");
                        var table = $.fn.dataTable.tables({api: true});
                        table.ajax.reload();
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    $("#financial-period").modal("hide");
                    Swal.fire('Server Error!', xhr.statusText,'warning');
                    var table = $.fn.dataTable.tables({api: true});
                    table.ajax.reload();
                }

            })
        });

        $("form#modify-period-form").submit( function(event){
            const  form = $(this);
            event.preventDefault();
            let formData = form.serialize();
            $.ajax({
                url: "<?php echo base_url('accounting/settings/index/period_details');?>",
                data: formData,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Updating financial period, Please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    //window.location.reload();
                    if( result.status == true){
                        $("#modify-period").modal("hide");
                        notifySuccess(result.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.ajax.reload();

                    }else{
                        swal.fire("","An error occurred! "+ result.message,"warning");
                        var table = $.fn.dataTable.tables({api: true});
                        table.ajax.reload();
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    $("#modify-period").modal("hide");
                    Swal.fire('Server Error!', xhr.statusText,'warning');
                    var table = $.fn.dataTable.tables({api: true});
                    table.ajax.reload();
                }

            })
        });
    })
</script>
<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>

