<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<form id="modifyClockForm" class="kt-form kt-form--fit kt-form--label-right" action="#" method="get" onsubmit="return false">

    <div class="row">
        <input  type="text" name="wclock_user_id" value="<?php echo $clock->wclock_user_id;?>" placeholder="" class="form-control"/>
        <div class="kt-callout__action col-6">
            <button class="btn btn-sm  btn-elevate btn-elevate-air  btn-info"><img src="<?php echo base_url('resources');?>/assets/media/icons/svg/Media/Pause.svg"/>Break</button>
        </div>
        <div class="kt-callout__action col-6">
            <a href="#" class="btn btn-sm pull-right btn-elevate btn-elevate-air  btn-danger"><img src="<?php echo base_url('resources');?>/assets/media/icons/svg/Electric/Shutdown.svg"/>Clock Out</a>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Closes</button>
        <button type="button" name="submit" class="btn btn-primary">Save changes</button>
    </div>

</form>

<script type="text/javascript">
    $('form#modifyClockForm').submit( function(event){
        let form = $( this );
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('clock/index/updateClockBreak/'.$clock->wclock_user_id);?>' ,
            type: 'get',
            data: formdata,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Pause working clock Employee ..."
                });
            },
            success: function(r){
                var obj = JSON.parse(r);
                if(obj.status == 'ok'){
                    $('div#clockDetails').modal('hide');
                    notifySuccess(obj.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock(form);
            },
            error: function(){
                $('div#clockDetails').modal('hide');
                KTApp.unblock(form);
            }
        });
    })
</script>