<?php
defined('BASEPATH') OR exit('No direct script access allowed');
include VIEWPATH.'/'.$auth_role.'/base_style.php';
include VIEWPATH.'/'.$auth_role.'/header.php';?>
<div class="m-content">
        <!--Begin::Section-->
        <div class="m-portlet">
                <div class="m-portlet__body  m-portlet__body--no-padding">
                        <div class="row m-row--no-padding m-row--col-separator-xl">
                                <div class="col-md-3">
                                        <!--begin:: Widgets/Stats2-1 -->
                                        <?php configuration_menu('currencies');?>
                                        <!--end:: Widgets/Stats2-1 -->
                                </div>
                                <div class="col-md-9 divloader">
                                        <div class="m-widget14">
                                          <h5>Currency Settings</h5><br/>
                                          <?php if(isset($status['flag'])){?>
                                              <div class="form-group m-form__group m--margin-top-10">
                                                  <div class="alert m-alert <?php echo $status['class'];?>" role="alert">
                                                      <?php echo $status['message'];?>
                                                  </div>
                                              </div>
                                          <?php } ?>

                                            <?php $attr = array('method' => 'post');
                                               echo form_open(current_url(),$attr);?>
                                              <input name="action" value="addcurrency" type="hidden" />
                                              <label class="form_label"><strong>Add Currency</strong></label>
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <input type="text" name="currency" required class="form-control" placeholder="Currency">
                                                    </div>
                                                    <input type="text" required name="currency_symbol" class="form-control " placeholder="Symbol">
                                                    <input type="text" name="currency_code" class="form-control " placeholder="Code">
                                                    <input type="text" required name="currency_convention" class="form-control number" placeholder="Convention">
                                                    <div class="input-group-append">
                                                      <button type="submit" class="btn btn-warning" style="font-weight:600" type="button">
                                                        Submit
                                                      </button>
                                                    </div>
                                                </div>
                                             <?php echo form_close();?>

                                          <br/>
                                              <div class="table-responsive">
                                                  <table class="table table-bordered" id="currencies">
                                                      <thead>
                                                          <tr>
                                                              <th colspan="5">Currency Settings</th>
                                                          </tr>
                                                          <tr>
                                                              <th>Currency</th>
                                                              <th>Symbol</th>
                                                              <th>Code</th>
                                                              <th>Unit</th>
                                                              <th>Default</th>
                                                              <th>Option</th>
                                                          </tr>
                                                      </thead>
                                                      <tbody>
                                                          <?php if(isset($currencies)):
                                                              foreach($currencies as $row):?>
                                                          <tr id="currency-<?php echo $row['currency_id'];?>">
                                                                      <td>
                                                                          <?php if($row['currency_default']):?>
                                                                          <span class="m--font-warning" style="font-weight:600"><?php echo $row['currency'];?> <small style="font-size:8px;">default</small></span>
                                                                          <?php else:
                                                                              echo $row['currency'];
                                                                          endif;?>
                                                                      </td>
                                                                      <td><?php echo $row['currency_symbol'];?></td>
                                                                      <td><?php echo $row['currency_code'];?></td>
                                                                      <td><?php echo number_format($row['currency_convention']);?></td>
                                                                      <td>
                                                                          <?php if($row['currency_default']):?>

                                                                          <?php else:?>
                                                                              <a href="javascript:makedefaultcurrency('<?php echo $row['currency_id'];?>');"><i class="fl flaticon-like m--font-success"></i></a>
                                                                            <?php  endif;?>
                                                                      </td>
                                                                      <td><?php if($row['currency_default'] != TRUE){?>
                                                                          <a href="<?php echo base_url('admin/configuration/currencies/details/'.$row['currency_id']);?>"><i class="flaticon-edit-1 m--font-warning"></i></a>
                                                                          <?php if(strtolower($row['currency']) != 'usd'){?>&nbsp
                                                                           <a class="delete-currency" data-currencyid="<?php echo $row['currency_id'];?>" href="javascript:(0');"><i class="fl flaticon-delete-1 m--font-danger"></i></a>
                                                                         <?php } ?>
                                                                       <?php };?>
                                                                      </td>
                                                                </tr>
                                                             <?php endforeach;
                                                          endif;?>
                                                      </tbody>
                                                  </table>
                                                    </div>
                                           </div>
                                    </div>
                                    <!--end:: Widgets/Daily Sales-->
                                </div>
                        </div>
                </div>
        </div>
<!-- end:: Body -->
<?php include VIEWPATH.'/'.$auth_role.'/footer.php';?>
<?php include VIEWPATH.'/'.$auth_role.'/base_scripts.php';?>
<script>
    $(function() {
      $(".delete-currency").click( function(){
            let id = $( this ).data('currencyid');
             swal({
                    title:"Are you sure?",
                    text:"You won't be able to revert this!",
                    type:"warning",
                    confirmButtonClass: "btn-danger btn",
                    showCancelButton:!0,
                    confirmButtonText:"Yes, delete it!"
                }).then(function(e){
                    if(e.value){
                       $.ajax({
                          url: '<?php echo base_url($auth_role.'/configuration/currencies/delete/');?>'+id,
                          type: 'get',
                          beforeSend: function(){
                               mApp.block("#currencies",{
                                  overlayColor:"#000000",
                                  type:"loader",
                                  state:"primary",
                                  message:"Processing..."
                              });
                           },
                          success: function(result){
                               if( result == 'ok'){
                                   $('tr#currency-'+id).css('display','none');
                               }
                               mApp.unblock('#currencies');
                           },
                           error: function(){
                            mApp.unblock('#currencies');
                            }
                       });
                    }
            });
      });
  });

function makedefaultcurrency( id ){
                      swal({
                              title:"Are you sure?",
                              text:"This will be currency for display money!",
                              showCancelButton:!0,
                              cancelButtonClass:"btn btn-warning btn-focus m-btn m-btn--pill pull-left",
                              confirmButtonText:"Yes, do it!",
                              confirmButtonClass:"btn btn-success btn-focus m-btn m-btn--pill m--font-light"
                          }).then(function(e){
                              if(e.value){
                                  window.location.href = "<?php echo base_url($auth_role.'/configuration/currencies/').'?fany=msn&yne=';?>" + id;
                              }
                          }
                      )
                  }

</script>
</body>
<!-- end::Body -->
</html>
