<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources');?>/assets/css/pages/wizard/wizard-2.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->

<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topToolBarCustomers('newcustomer');?>
    <!-- begin:: Content -->

    <div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">
        <div class="kt-portlet">
            <div class="kt-portlet__body kt-portlet__body--fit">
                <div class="kt-grid  kt-wizard-v2 kt-wizard-v2--white" id="kt_wizard_v2" data-ktwizard-state="step-first">
                    <div class="kt-grid__item kt-wizard-v2__aside">

                        <!--begin: Form Wizard Nav -->
                        <div class="kt-wizard-v2__nav">

                            <!--doc: Remove "kt-wizard-v2__nav-items--clickable" class and also set 'clickableSteps: false' in the JS init to disable manually clicking step titles -->
                            <div class="kt-wizard-v2__nav-items kt-wizard-v2__nav-items--clickable">
                                <div class="kt-wizard-v2__nav-item" data-ktwizard-type="step" data-ktwizard-state="current">
                                    <div class="kt-wizard-v2__nav-body">
                                        <div class="kt-wizard-v2__nav-icon">
                                            <i class="flaticon-globe"></i>
                                        </div>
                                        <div class="kt-wizard-v2__nav-label">
                                            <div class="kt-wizard-v2__nav-label-title">
                                                Account Settings
                                            </div>
                                            <div class="kt-wizard-v2__nav-label-desc">
                                                Setup Your Account Details
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="kt-wizard-v2__nav-item" data-ktwizard-type="step">
                                    <div class="kt-wizard-v2__nav-body">
                                        <div class="kt-wizard-v2__nav-icon">
                                            <i class="flaticon-bus-stop"></i>
                                        </div>
                                        <div class="kt-wizard-v2__nav-label">
                                            <div class="kt-wizard-v2__nav-label-title">
                                                Setup Locations
                                            </div>
                                            <div class="kt-wizard-v2__nav-label-desc">
                                                Choose Your Location Map
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="kt-wizard-v2__nav-item" href="#" data-ktwizard-type="step">
                                    <div class="kt-wizard-v2__nav-body">
                                        <div class="kt-wizard-v2__nav-icon">
                                            <i class="flaticon-responsive"></i>
                                        </div>
                                        <div class="kt-wizard-v2__nav-label">
                                            <div class="kt-wizard-v2__nav-label-title">
                                                Company Business Information
                                            </div>
                                            <div class="kt-wizard-v2__nav-label-desc">
                                                Add company business
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="kt-wizard-v2__nav-item" data-ktwizard-type="step">
                                    <div class="kt-wizard-v2__nav-body">
                                        <div class="kt-wizard-v2__nav-icon">
                                            <i class="flaticon-trophy"></i>
                                        </div>
                                        <div class="kt-wizard-v2__nav-label">
                                            <div class="kt-wizard-v2__nav-label-title">
                                                Security & Account
                                            </div>
                                            <div class="kt-wizard-v2__nav-label-desc">
                                                Username, Email, Password
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="kt-wizard-v2__nav-item" data-ktwizard-type="step">
                                    <div class="kt-wizard-v2__nav-body">
                                        <div class="kt-wizard-v2__nav-icon">
                                            <i class="flaticon-truck"></i>
                                        </div>
                                        <div class="kt-wizard-v2__nav-label">
                                            <div class="kt-wizard-v2__nav-label-title">
                                                Details Submit
                                            </div>
                                            <div class="kt-wizard-v2__nav-label-desc">
                                                register customer
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!--end: Form Wizard Nav -->
                    </div>
                    <div class="kt-grid__item kt-grid__item--fluid kt-wizard-v2__wrapper">

                        <!--begin: Form Wizard Form-->
                        <form class="kt-form" id="new_customer">

                            <!--begin: Form Wizard Step 1-->
                            <div class="kt-wizard-v2__content" data-ktwizard-type="step-content" data-ktwizard-state="current">
                                <div class="kt-heading kt-heading--md">Enter Customer Account Details</div>
                                <div class="kt-form__section kt-form__section--first">
                                    <div class="kt-wizard-v2__form">
                                        <div class="form-group">
                                            <label>Company Name</label>
                                            <input required type="text" class="form-control" name="company_name" placeholder="full company name" value="">
                                            <span class="form-text text-muted">Please enter company name.</span>
                                        </div>

                                        <div class="form-group">
                                            <label>Contact Phone</label>
                                            <input required id="phonenumber" type="text" class="form-control" placeholder="Phone" aria-describedby="basic-addon1"  name="phonenumber">
                                            <span class="form-text text-muted">Please enter your phone number.</span>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <!--end: Form Wizard Step 1-->

                            <!--begin: Form Wizard Step 2-->
                            <div class="kt-wizard-v2__content" data-ktwizard-type="step-content">
                                <div class="kt-heading kt-heading--md">Setup Location</div>
                                <div class="kt-form__section kt-form__section--first">
                                    <div class="kt-wizard-v2__form">

                                        <div class="form-group">
                                            <label>Country</label>
                                            <select required id="" name="country" class="countries order-alpha form-control" style="width:100%">
                                                <option value="">Select Country</option>
                                                <?php if(!empty($country = $this->countriesModel->find_all())){
                                                    foreach ($country as $key => $branch) {?>
                                                        <option value="<?php echo $branch['country_name'];?>"><?php echo $branch['country_name'];?></option>
                                                    <?php }
                                                } ?>
                                            </select>
                                        </div>

                                        <div class="form-group">
                                            <label>State:</label>
                                            <input type="text" value="" name="state" class="form-control"  placeholder=State>
                                        </div>

                                        <div class="form-group">
                                            <label>City:</label>
                                            <input type="text" value="" name="company_city" class="form-control"  placeholder=State>
                                        </div>

                                        <div class="form-group">
                                            <label>Company Address</label>
                                            <input type="text" value="" name="company_address" class="form-control"  placeholder="Company address">
                                        </div>

                                        <div class="form-group">
                                            <label>Residential Address</label>
                                            <input type="text" value="" name="residential_address" class="form-control"  placeholder="residential address">
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <!--end: Form Wizard Step 2-->

                            <!--begin: Form Wizard Step 3-->
                            <div class="kt-wizard-v2__content" data-ktwizard-type="step-content">
                                <div class="kt-heading kt-heading--md">Enter <b> Business </b> information</div>
                                <div class="kt-form__section kt-form__section--first">
                                    <div class="kt-wizard-v2__form">
                                        <div class="form-group">
                                            <label>Business Name</label>
                                            <input name="business_name" class="form-control" type="text" >
                                        </div>
                                        <div class="form-group">
                                            <label>TIN Number</label>
                                            <input class="form-control" type="text" name="business_tin_number" >
                                        </div>
                                        <div class="form-group">
                                            <label>Business Location</label>
                                            <input class="form-control" type="text" name="business_location" >
                                        </div>
                                        <div class="form-group">
                                            <label>Business type</label>
                                            <textarea name="business_type" class="form-control" rows="2" cols="80"></textarea>
                                        </div>
                                        <div class="form-group">
                                            <label>Company Age</label>
                                            <input class="form-control" type="text" name="company_age" value="0" >
                                        </div>
                                        <div class="form-group">
                                            <label>Registered Company</label>
                                            <div class="kt-radio-inline">
                                                <label class="kt-radio">
                                                    <input type="radio" value="Yes" name="company_registered"> Yes
                                                    <span></span>
                                                </label>
                                                <label class="kt-radio">
                                                    <input type="radio" checked  value="No" name="company_registered"> No
                                                    <span></span>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label>Business Lisence Number (sio lazima)</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend"><span class="input-group-text"><i class="la la-file"></i></span></div>
                                                <input type="text" class="form-control" placeholder="license number" aria-describedby="basic-addon1"  name="business_lisence">
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <!--end: Form Wizard Step 3-->

                            <!--begin: Form Wizard Step 4-->
                            <div class="kt-wizard-v2__content" data-ktwizard-type="step-content">
                                <div class="kt-heading kt-heading--md">Security & Access details</div>
                                <div class="kt-form__section kt-form__section--first">
                                    <div class="kt-wizard-v2__form">
                                        <div class="row">
                                            <div class="col-xl-6">
                                                <div class="form-group">
                                                    <label>Username</label>
                                                    <div id="spinnerUsername" class="kt-spinner--sm kt-spinner--warning kt-spinner--right kt-spinner--input">
                                                        <input autocomplete="off" onchange="checkusername(this.value)"  onkeyup="checkusername(this.value)" id="username" name="username" class="form-control" type="text" >
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-6">
                                                <div class="form-group">
                                                    <label>Password</label>
                                                    <div class="input-group">
                                                        <input id="passwordInput"  readonly onfocus="this.removeAttribute('readonly');"  type="password" class="form-control" placeholder="Password" aria-describedby="basic-addon1" name="password">
                                                        <div class="input-group-append"><button class="btn btn-sm btn-warning text-dark" type="button" onmouseup="hidePassword()" onmousedown="showPassword()" class="input-group-text"><i class="la la-eye text-dark"></i></button></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label>Company Email</label>
                                            <div id="spinnerEmail" class="kt-spinner--sm kt-spinner--warning kt-spinner--right kt-spinner--input">
                                                <input autocomplete="off" onchange="checkemail(this.value)" onkeyup="checkemail(this.value)" id="email" name="email" class="form-control" type="email" value="">
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-xl-6" hidden>
                                                <div class="form-group">
                                                    <label>Branch</label>
                                                    <select required id="branches" name="user_branch" class="form-control" style="width:100%">
                                                        <option value="">Select Branch</option>
                                                        <?php if(!empty($branches = $this->branchesModel->branches())){
                                                            foreach ($branches as $key => $branch) {?>
                                                                <option <?php if($branch['branch_key'] == runningBranch()->branch_key) echo 'selected';?> value="<?php echo $branch['branch_key'];?>"><?php echo $branch['branch_name'];?></option>
                                                            <?php }
                                                        } ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-xl-12">
                                                <div class="form-group">
                                                    <label>Administration:</label>
                                                    <select required  id="levels" name="auth_level" class="form-control" style="width:100%">
                                                        <option value=""></option>
                                                        <option selected  value="2">Corporate Customer</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label>Category</label>
                                            <div class="input-group">
                                                <select required name="user_group" class="form-control" style="width:100%">
                                                    <option value="">Select Category</option>
                                                    <?php if(!empty($groups)){
                                                        foreach ($groups as $key => $group) {?>
                                                            <option  value="<?php echo $group['group_key'];?>"><?php echo $group['group_name'];?></option>
                                                        <?php }
                                                    } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label>Communication</label>
                                            <div class="kt-checkbox-inline">
                                                <label class="kt-checkbox">
                                                    <input type="checkbox" value="1"  name="communicate_email" checked=""> Email
                                                    <span></span>
                                                </label>
                                                <label class="kt-checkbox">
                                                    <input type="checkbox" value="1"  name="communicate_sms" checked=""> SMS
                                                    <span></span>
                                                </label>
                                                <label class="kt-checkbox">
                                                    <input type="checkbox" value="1" name="communicate_phone" checked="" > Phone
                                                    <span></span>
                                                </label>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <!--end: Form Wizard Step 4-->

                            <!--begin: Form Wizard Step 5-->
                            <div class="kt-wizard-v2__content" data-ktwizard-type="step-content">
                                <div class="kt-heading kt-heading--md">Submit All Information</div>
                                <div class="kt-form__section kt-form__section--first" hidden>
                                    <div class="kt-wizard-v2__review">
                                        <div class="kt-wizard-v2__review-item">
                                            <div class="kt-wizard-v2__review-title">
                                                Account Details
                                            </div>
                                            <div class="kt-wizard-v2__review-content">
                                                John Wick<br>
                                                Phone: +61412345678<br>
                                                Email: johnwick@reeves.com
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--end: Form Wizard Step 5-->

                            <!--begin: Form Actions -->
                            <div class="kt-form__actions">
                                <button class="btn btn-secondary btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u" data-ktwizard-type="action-prev">
                                    Previous
                                </button>
                                <button type="submit" class="btn btn-success btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u" data-ktwizard-type="action-submit">
                                    Submit
                                </button>
                                <button class="btn btn-brand btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u" data-ktwizard-type="action-next">
                                    Next Step
                                </button>
                            </div>

                            <!--end: Form Actions -->
                        </form>

                        <!--end: Form Wizard Form-->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- end:: Content -->
</div>

<?php include VIEWPATH.'includes/footer.php';?>
<script src="<?php echo base_url('resources')?>/assets/js/pages/custom/wizard/wizard-2.js" type="text/javascript"></script>
<script src="//geodata.solutions/includes/countrystatecity.js"></script>
<script type="text/javascript">

    jQuery(document).ready(function() {
        $("#phonenumber").inputmask('+ 999 999 999999', {
            numericInput: true
        });

        "use strict";

        // Class definition
        var KTWizard2 = function () {
            // Base elements
            var wizardEl;
            var formEl;
            var validator;
            var wizard;

            // Private functions
            var initWizard = function () {
                // Initialize form wizard
                wizard = new KTWizard('kt_wizard_v2', {
                    startStep: 1, // initial active step number
                    clickableSteps: true  // allow step clicking
                });

                // Validation before going to next page
                wizard.on('beforeNext', function(wizardObj) {
                    if (validator.form() !== true) {
                        wizardObj.stop();  // don't go to the next step
                    }
                });

                wizard.on('beforePrev', function(wizardObj) {
                    if (validator.form() !== true) {
                        wizardObj.stop();  // don't go to the next step
                    }
                });

                // Change event
                wizard.on('change', function(wizard) {
                    KTUtil.scrollTop();
                });
            }

            var initValidation = function() {
                validator = formEl.validate({
                    // Validate only visible fields
                    ignore: ":hidden",

                    // Validation rules
                    rules: {
                        //= Step 1
                        fname: {
                            required: true
                        },
                        lname: {
                            required: true
                        },
                        phone: {
                            required: true
                        },
                        emaul: {
                            required: true,
                            email: true
                        },

                        //= Step 2
                        address1: {
                            required: true
                        },
                        postcode: {
                            required: true
                        },
                        city: {
                            required: true
                        },
                        state: {
                            required: true
                        },
                        country: {
                            required: true
                        },

                        //= Step 3
                        delivery: {
                            required: true
                        },
                        packaging: {
                            required: true
                        },
                        preferreddelivery: {
                            required: true
                        },

                        //= Step 4
                        locaddress1: {
                            required: true
                        },
                        locpostcode: {
                            required: true
                        },
                        loccity: {
                            required: true
                        },
                        locstate: {
                            required: true
                        },
                        loccountry: {
                            required: true
                        },

                        //= Step 5
                        ccname: {
                            required: true
                        },
                        ccnumber: {
                            required: true,
                            creditcard: true
                        },
                        ccmonth: {
                            required: true
                        },
                        ccyear: {
                            required: true
                        },
                        cccvv: {
                            required: true,
                            minlength: 2,
                            maxlength: 3
                        },
                    },

                    // Display error
                    invalidHandler: function(event, validator) {
                        KTUtil.scrollTop();

                        swal.fire({
                            "title": "",
                            "text": "There are some errors in your submission. Please correct them.",
                            "type": "error",
                            "confirmButtonClass": "btn btn-secondary"
                        });
                    },

                    // Submit valid form
                    submitHandler: function (form) {

                    }
                });
            }

            var initSubmit = function() {
                var btn = formEl.find('[data-ktwizard-type="action-submit"]');

                btn.on('click', function(e) {
                    e.preventDefault();

                    if (validator.form()) {
                        // See: src\js\framework\base\app.js
                        KTApp.progress(btn);
                        KTApp.block(formEl);
                        const formData = formEl.serialize();
                        // See: http://malsup.com/jquery/form/#ajaxSubmit
                        formEl.ajaxSubmit({
                            url: '<?php echo base_url('/crm/customers/index/createCustomer/');?>',
                            type: 'get',
                            data: formData,
                            success: function(result) {
                                KTApp.unprogress(btn);
                                KTApp.unblock(formEl);

                                if(result.status == true){
                                    Swal.fire('',result.message,'success');
                                    window.location.reload()
                                }else{
                                    Swal.fire('',result.message,'warning');
                                }
                            },
                            error: function(xhr){
                                Swal.fire('',xhr.statusText,'warning');
                            }
                        });
                    }
                });
            }

            return {
                // public functions
                init: function() {
                    wizardEl = KTUtil.get('kt_wizard_v2');
                    formEl = $('form#new_customer');

                    initWizard();
                    initValidation();
                    initSubmit();
                }
            };
        }();

        jQuery(document).ready(function() {
            KTWizard2.init();
            $("#phonenumber").inputmask('+ 999 999 999999', {
                numericInput: true
            });
        });



    });

    function showRequest(formData, jqForm, options) {
        // formData is an array; here we use $.param to convert it to a string to display it
        // but the form plugin does this for you automatically when it submits the data
        var queryString = $.param(formData);
        KTApp.block(jqForm,{
            overlayColor:"#000000",
            type:"loader",
            state:"danger",
            message:"Sending request to register an employee ..."
        });
        // here we could return false to prevent the form from being submitted;
        // returning anything other than false will allow the form submit to continue
        return true;
    }

    // post-submit callback
    function showResponse(responseText, statusText, xhr, $form)  {
        KTApp.unblock($form);
        var obj = JSON.parse(responseText);
        if(obj.status == 'ok'){
            Swal.fire('',obj.message,'success');
        }else{
            Swal.fire('',obj.message,'warning');
        }
    }

    function showPassword(){
        let input = $("#passwordInput");
        input.prop({type:"text"});
    }

    function hidePassword(){
        let input = $("#passwordInput");
        input.prop({type:"password"});
    }

    function checkemail(email){
        let spinner = $('div#spinnerEmail');
        let input = $('input#email');
        event.preventDefault();
        $.ajax({
            url: '<?php echo base_url('/administration/employees/index/checkemailonly/');?>' + encodeURIComponent(email),
            type: 'get',
            beforeSend: function(){
                spinner.addClass('kt-spinner');
                input.removeClass('is-valid is-invalid');
            },
            success: function(r){
                var obj = JSON.parse(r);
                spinner.removeClass('kt-spinner');
                if(obj.status == 'ok'){
                    input.addClass('is-valid');
                }else{
                    input.addClass('is-invalid');
                }
            },
            error: function(){
                spinner.removeClass('kt-spinner');
                Swal.fire('',obj.message,'warning');
            }
        });
    }

    function checkusername(username){
        let spinner = $('div#spinnerUsername');
        let input = $('input#username');
        event.preventDefault();
        $.ajax({
            url: '<?php echo base_url('/administration/employees/index/checkusernameonly/');?>' + encodeURIComponent(username),
            type: 'get',
            beforeSend: function(){
                spinner.addClass('kt-spinner');
                input.removeClass('is-valid is-invalid');
            },
            success: function(r){
                var obj = JSON.parse(r);
                spinner.removeClass('kt-spinner');
                if(obj.status == 'ok'){
                    input.addClass('is-valid');
                }else{
                    input.addClass('is-invalid');
                }
            },
            error: function(){
                spinner.removeClass('kt-spinner');
                Swal.fire('',obj.message,'warning');
            }
        });
    }
</script>
<!--end::Page Scripts -->
</body>
<!-- end::Body -->
</html>