<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="kt-portlet__body">
  <div class="kt-scroll lm_max_height." data-scroll="true" style=" overflow-y: scroll; padding:30px;">
    <form id="customersForm" onsubmit="return false;" class="kt-form">
      <div class="kt-section kt-section--first">
        <div class="kt-section__body">
          <div class="form-group row">
            <label class="col-3 col-form-label">Username</label>
            <div class="col-9">
              <div id="spinnerUsername" class="kt-spinner--sm kt-spinner--warning kt-spinner--right kt-spinner--input">
                <input autocomplete="off" onkeyup="checkusername(<?php echo $customer->user_id;?>, this.value)" id="username" name="username" class="form-control" type="text" value="<?php echo $customer->username;?>">
            </div>
            </div>
          </div>
          <div class="form-group row">
            <label class="col-3 col-form-label">Password</label>
            <div class="col-9">
              <div class="input-group">
                <input id="passwordInput" readonly onfocus="this.removeAttribute('readonly');"  type="password" class="form-control" placeholder="Password" aria-describedby="basic-addon1" name="password">
                <div class="input-group-append"><button class="btn btn-sm btn-warning text-dark" type="button" onmouseup="hidePassword()" onmousedown="showPassword()" class="input-group-text"><i class="la la-eye text-dark"></i></button></div>
              </div>
            </div>
          </div>
          <div class="form-group row">
            <label class="col-3 col-form-label">Group</label>
            <div class="col-9">
              <div class="input-group">
                <select id="groups" name="user_group" class="form-control" style="width:100%">
                  <option value="">Select group</option>
                  <?php if(!empty($groups = $this->groupsModel->groups())){
                    foreach ($groups as $key => $group) {?>
                      <option <?php if($group['group_key'] == $customer->user_group) echo 'selected';?> value="<?php echo $group['group_key'];?>"><?php echo $group['group_name'];?></option>
                    <?php }
                  } ?>
                </select>
              </div>
            </div>
          </div>
					<div class="form-group row">
            <label class="col-3 col-form-label">Branch</label>
            <div class="col-9">
              <div class="input-group">
                <select id="branches" required name="user_branch" class="form-control" style="width:100%">
                  <option value="">Select group</option>
                  <?php if(!empty($branches = $this->branchesModel->branches())){
                    foreach ($branches as $key => $branch) {?>
                      <option <?php if($branch['branch_key'] == $customer->user_branch) echo 'selected';?> value="<?php echo $branch['branch_key'];?>"><?php echo $branch['branch_name'];?></option>
                    <?php }
                  } ?>
                </select>
              </div>
            </div>
          </div>
          <div class="form-group row">
            <label class="col-3 col-form-label">Administration</label>
            <div class="col-9">
              <div class="input-group">
                <select id="levels" name="auth_level" class="form-control" style="width:100%">
                  <option value=""></option>
                  <option <?php if($customer->auth_level == 1) echo 'selected';?> value="1">Customer</option>
                </select>
              </div>
            </div>
          </div>
          <div class="form-group row">
            <label class="col-3 col-form-label">Email</label>
            <div class="col-9">
              <div id="spinnerEmail" class="kt-spinner--sm kt-spinner--warning kt-spinner--right kt-spinner--input">
                <input autocomplete="off" onkeyup="checkemail(<?php echo $customer->user_id;?>, this.value)" id="email" name="email" class="form-control" type="email" value="<?php echo $customer->email;?>">
            </div>
            </div>
          </div>
          <div class="form-group row">
            <label class="col-3 col-form-label">Contact Phone</label>
            <div class="col-9">
              <div class="input-group">
                <div class="input-group-prepend"><span class="input-group-text"><i class="la la-phone"></i></span></div>
                <input type="text" class="form-control" value="<?php echo $customer->phonenumber;?>" placeholder="Phone" aria-describedby="basic-addon1"  name="phonenumber">
              </div>
            </div>
          </div>
          <div class="form-group row">
            <label class="col-3 col-form-label">Communication</label>
            <div class="col-9">
              <div class="kt-checkbox-inline">
                <label class="kt-checkbox">
                    <input type="checkbox" value="1" <?php if($customer->communicate_email) echo 'checked="checked"';?> name="communicate_email" checked=""> Email
                    <span></span>
                </label>
                <label class="kt-checkbox">
                    <input type="checkbox" value="1" <?php if($customer->communicate_sms) echo 'checked="checked"';?> name="communicate_sms" checked=""> SMS
                    <span></span>
                </label>
                <label class="kt-checkbox">
                    <input type="checkbox" value="1" name="communicate_phone" <?php if($customer->communicate_phone) echo 'checked="checked"';?>> Phone
                    <span></span>
                </label>
            </div>
            </div>
          </div>
          <div class="form-group row">
            <label class="col-9 col-form-label"></label>
            <div class="col-3">
              <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Save Changes</b></button>
            </div>
          </div>
        </div>
      </div>
    </form>
</div>
</div>
<script type="text/javascript">
$(function(){
let height = $(window).innerHeight()  - 250;
  $('.lm_max_height.').css({ height: height });
  $(window).resize(function(){
    $('.lm_max_height.').css({ height: height });
  });
});
$('form#customersForm').submit( function(event){
  let form = $( this );
  let $div =  $('div#loadDetails');
  event.preventDefault();
  let formdata = form.serialize();
  $.ajax({
   url: '<?php echo base_url('customers/index/loadInformationSecurityAction/'.$customer->user_id);?>' ,
    type: 'get',
    data: formdata,
    beforeSend: function(){
        KTApp.block($div,{
                overlayColor:"#000000",
                type:"loader",
                state:"success",
                message:"Updating Primary information ...."
            });
      },
     success: function(r){
          var obj = JSON.parse(r);
          if(obj.status == 'ok'){
            Swal.fire('',obj.message,'success');
            }else{
                Swal.fire('',obj.message,'warning');
            }
            $div.modal('hide');
            KTApp.unblock($div);
         },
      error: function(){
        Swal.fire('',obj.message,'success');
          KTApp.unblock($div);
          }
  });
})

function showPassword(){
  let input = $("#passwordInput");
  input.prop({type:"text"});
}

function hidePassword(){
  let input = $("#passwordInput");
  input.prop({type:"password"});
}

function checkemail(email){
  let spinner = $('div#spinnerEmail');
  let input = $('input#email');
  event.preventDefault();
  $.ajax({
      url: '<?php echo base_url('/administration/employees/index/checkemailonly/');?>' + encodeURIComponent(email),
    type: 'get',
    beforeSend: function(){
        spinner.addClass('kt-spinner');
        input.removeClass('is-valid is-invalid');
      },
     success: function(r){
          var obj = JSON.parse(r);
          spinner.removeClass('kt-spinner');
          if(obj.status == 'ok'){
            input.addClass('is-valid');
            }else{
              input.addClass('is-invalid');
            }
         },
      error: function(){
        spinner.removeClass('kt-spinner');
        Swal.fire('',obj.message,'warning');
          }
  });
}

function checkusername(username){
  let spinner = $('div#spinnerUsername');
  let input = $('input#username');
  event.preventDefault();
  $.ajax({
   url: '<?php echo base_url('administration/employees/index/checkusernameonly/');?>' + encodeURIComponent(username),
    type: 'get',
    beforeSend: function(){
        spinner.addClass('kt-spinner');
        input.removeClass('is-valid is-invalid');
      },
     success: function(r){
          var obj = JSON.parse(r);
          spinner.removeClass('kt-spinner');
          if(obj.status == 'ok'){
            input.addClass('is-valid');
            }else{
              input.addClass('is-invalid');
            }
         },
      error: function(){
        spinner.removeClass('kt-spinner');
        Swal.fire('',obj.message,'warning');
          }
  });
}
</script>
