<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<form id="modifyGroupForm" class="kt-form" action="#" method="get" onsubmit="return false">
  <div class="form-group row">
    <div class="col-12">
      <div class="input-group">
        <select id="branches" required name="group_branch" class="form-control" style="width:100%">
          <option value="">Select group</option>
          <?php if(!empty($branches = $this->branchesModel->branches())){
            foreach ($branches as $key => $branch) {?>
              <option <?php if($branch['branch_key'] == $group->group_branch) echo 'selected';?> value="<?php echo $branch['branch_key'];?>"><?php echo $branch['branch_name'];?></option>
            <?php }
          } ?>
        </select>
      </div>
    </div>
  </div>
  <div class="form-group row">
    <div class="col-12">
      <input type="text" name="group_name" value="<?php echo $group->group_name;?>" class="form-control" placeholder="Group name">
    </div>
  </div>
  <div class="form-group row">
    <div class="col-12">
      <textarea class="form-control" name="group_details" rows="4" cols="80" placeholder="Group details"><?php echo $group->group_details;?></textarea>
    </div>
  </div>
  <div class="form-group row">
    <label class="col-8 col-form-label"></label>
    <div class="col-4">
      <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Save Changes</b></button>
    </div>
  </div>
</form>
<script type="text/javascript">
$('form#modifyGroupForm').submit( function(event){
  let form = $( this );
  event.preventDefault();
  let formdata = form.serialize();
  $.ajax({
   url: '<?php echo base_url($auth_role.'/customers/groups/update/'.$group->group_key);?>' ,
    type: 'get',
    data: formdata,
    beforeSend: function(){
        KTApp.block(form,{
                overlayColor:"#000000",
                type:"loader",
                state:"success",
                message:"Updating Group ..."
            });
      },
     success: function(r){
          var obj = JSON.parse(r);
          if(obj.status == 'ok'){
            $('div#groupDetails').modal('hide');
            notifySuccess(obj.message);
            var table = $.fn.dataTable.tables( { api: true } );
            table.clear().draw();
            }else{
                Swal.fire('',obj.message,'warning');
            }
            KTApp.unblock(form);
         },
      error: function(){
          $('div#groupDetails').modal('hide');
          KTApp.unblock(form);
          }
  });
})
</script>
