<div class="modal fade" id="budget-details" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="heading">Budget Details</h3>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button class="btn btn-dark kt-font-bolder pull-right btn-pill" data-dismiss="modal" type="button">X</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="transactions-details" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="heading">Budget Transactions</h3>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button class="btn btn-dark kt-font-bolder pull-right btn-pill" data-dismiss="modal" type="button">X</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="expenditure-details" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="heading">Budget Expenditure</h3>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button class="btn btn-dark kt-font-bolder pull-right btn-pill" data-dismiss="modal" type="button">X</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="deposit-details" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="heading">Budget Deposits</h3>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button class="btn btn-dark kt-font-bolder pull-right btn-pill" data-dismiss="modal" type="button">X</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="withdraw-details" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="heading">Budget Withdraw</h3>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button class="btn btn-dark kt-font-bolder pull-right btn-pill" data-dismiss="modal" type="button">X</button>
            </div>
        </div>
    </div>
</div>

<script>

    $( function(){
        $('select').select2();

        $('#budget-details').on('show.bs.modal', function (event) {
            let modal = $(this);
            let body = modal.find('.modal-body');
            body.html('<h1>Please wait ...</h1>');
            let button = $(event.relatedTarget)
            let key = button.data('key')
            body.load('<?php echo base_url($auth_role.'/expenses/budgets/index/details/');?>' + key );
        })

        $('#transactions-details').on('show.bs.modal', function (event) {
            let modal = $(this);
            let body = modal.find('.modal-body');
            body.html('<h1>Please wait ...</h1>');
            let button = $(event.relatedTarget)
            let key = button.data('key')
            body.load('<?php echo base_url($auth_role.'/expenses/budgets/index/transactions/');?>' + key );
        })

        $('#expenditure-details').on('show.bs.modal', function (event) {
            let modal = $(this);
            let body = modal.find('.modal-body');
            body.html('<h1>Please wait ...</h1>');
            let button = $(event.relatedTarget)
            let key = button.data('key')
            body.load('<?php echo base_url($auth_role.'/expenses/budgets/index/expenditure/');?>' + key );
        })

        $('#deposit-details').on('show.bs.modal', function (event) {
            let modal = $(this);
            let body = modal.find('.modal-body');
            body.html('<h1>Please wait ...</h1>');
            let button = $(event.relatedTarget)
            let key = button.data('key')
            body.load('<?php echo base_url($auth_role.'/expenses/budgets/index/deposits/');?>' + key );
        })

        $('#withdraw-details').on('show.bs.modal', function (event) {
            let modal = $(this);
            let body = modal.find('.modal-body');
            body.html('<h1>Please wait ...</h1>');
            let button = $(event.relatedTarget)
            let key = button.data('key')
            body.load('<?php echo base_url($auth_role.'/expenses/budgets/index/withdraws/');?>' + key );
        })


    })


    function createbudget(){
        let form  = $("form#formBudgetCreate");
        let formdata = form.serialize();
        $.ajax({
            url: "<?php echo base_url($auth_role.'/expenses/budgets/index/create');?>",
            data: formdata,
            type: "post",
            beforeSend: function () {
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"brand",
                    message:"Sending data ..."
                });
            },
            success: function (response) {
                KTApp.unblock(form);
                if(response.status == true){
                    form[0].reset();
                    notifySuccess(response.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire("Server response",response.message,"warning");
                }
            },
            error: function (xhr) {
                KTApp.unblock(form);
                Swal.fire("Server response ","Server issue occured please try again later or contact support: <?php echo config_item("server_level_support");?>","warning");
            }
        })
    }

    function deleteBudget(budget){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url($auth_role.'/expenses/budgets/index/delete')?>/' + budget,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting budget ..."
                        });
                    },
                    success: function(response){
                        KTApp.unblockPage();
                        if(response.status == true){
                            notifySuccess(response.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire("Server response",response.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        Swal.fire("Server response "  + xhr.statusText,"Server issue occured please try again later or contact support: <?php echo config_item("server_level_support");?>","warning");
                    }
                });
            }
        })
    }

    function showbalance(budget){
        Swal.fire({
            title: 'Submit access password',
            input: 'password',
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Show Balance',
            showLoaderOnConfirm: true,
            preConfirm: (login) => {
                return fetch(`<?php echo base_url($auth_role.'/expenses/budgets/index/showbalance');?>/${login}/${budget}`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(response.statusText)
                        }
                        return response.json()
                    })
                    .catch(error => {
                        Swal.showValidationMessage(
                            `Request failed: ${error}`
                        )
                    })
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((result) => {
            if (result.value) {
                Swal.fire({
                    title: `${result.value.message}`,
                })
            }
        })
    }
    function showtotalexpenditure(budget){
        Swal.fire({
            title: 'Submit access password',
            input: 'password',
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Show Balance',
            showLoaderOnConfirm: true,
            preConfirm: (login) => {
                return fetch(`<?php echo base_url($auth_role.'/expenses/budgets/index/showtotalexpenditure');?>/${login}/${budget}`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(response.statusText)
                        }
                        return response.json()
                    })
                    .catch(error => {
                        Swal.showValidationMessage(
                            `Request failed: ${error}`
                        )
                    })
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((result) => {
            if (result.value) {
                Swal.fire({
                    title: `${result.value.message}`,
                })
            }
        })
    }
</script>
