<?php
if(!empty($_GET['when'])) {
    $when = htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
}else{
    $when ='';
}
?>
<table class="table table-bordered" id="lm_expendicture">
    <thead>
    <tr>
        <th>Date</th>
        <th>Amount</th>
        <th>Paid</th>
        <th>Payee</th>
        <th>Description</th>
    </tr>
    </thead>
</table>
<script  type="text/javascript">

    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    var Datatable = function() {

        var expendictures = function() {
            var expendicture = $('#lm_expendicture');

            // begin first table
            expendicture.DataTable({
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
        <'row'<'col-sm-12'tr>>
        <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: true,
                ajax: '<?php echo base_url($auth_role.'/expenses/budgets/index/datasourceexpendicture/'.$budget->budget_key.'/'.$when);?>',
                columns: [
                    {data: 'expense_date'},
                    {data: 'expense_amount'},
                    {data: 'expense_paid'},
                    {data: 'expense_payee'},
                    {data: 'expense_details'},
                ],
                columnDefs: [
                    {
                        targets: 0,
                        "width": "10%",
                    },
                    {
                        targets: 1,
                        "width": "10%",
                        render: function(data, type, full, meta) {
                            return  numeral(to_money(full.expense_paid)).format('0,0') ;
                        },
                    },
                ],
            });
        };

        return {

            //main function to initiate the module
            init: function() {
                expendictures();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });

</script>
