<?php
if(!empty($_GET['when'])) {
    $when = htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
}else{
    $when ='';
}
?>

    <?php echo form_open('#',['id'=>'formWithdraw','onsubmit'=>'makewithdraw(); return false;']);?>
    <input required type="hidden" value="<?php echo $budget->budget_key;?>" name="key">
    <div class="form-group row">
        <div class="col-5">
            <input required type="date" name="date" placeholder="Post Date" class="form-control form-control-pill">
        </div>
        <div class="col-4">
           <input class="form-control number form-control-pill " name="amount" placeholder="Withdraw Amount">
        </div>
        <div class="col-3">
            <button type="submit" class="btn-block btn-pill btn btn-elevate-air btn-brand text-uppercase pull-right kt-font-bolder">Submit</button>
        </div>
    </div>
    <?php echo form_close();?>
<hr/>


    <table class="table table-bordered" id="lm_withdraws">
        <thead>
        <tr>
            <th>Date</th>
            <th>Amount</th>
            <th>Poster</th>
        </tr>
        </thead>
    </table>


<script  type="text/javascript">
    (function($, undefined) {
        "use strict";
        // When ready.
        $(function() {
            var $input = $( "input.number" );
            $input.on( "keyup", function( event ) {
                // When user select text in the document, also abort.
                var selection = window.getSelection().toString();
                if ( selection !== '' ) {
                    return;
                }
                // When the arrow keys are pressed, abort.
                if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
                    return;
                }
                var $this = $( this );
                // Get the value.
                var input = $this.val();
                var input = input.replace(/[\D\s\._\-]+/g, "");
                input = input ? parseInt( input, 10 ) : 0;
                $this.val( function() {
                    return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
                } );
            });
        });
    })(jQuery);
    $( function(){
        $("select").select2();

    })

    function makewithdraw(){
        let form  = $("form#formWithdraw");
        let formdata = form.serialize();
        $.ajax({
            url: "<?php echo base_url($auth_role.'/expenses/budgets/index/makewithdraw');?>",
            data: formdata,
            type: "post",
            beforeSend: function () {
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"brand",
                    message:"Sending data ..."
                });
            },
            success: function (response) {
                KTApp.unblock(form);
                if(response.status == true){
                    notifySuccess(response.message);
                    var table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire("Server response",response.message,"warning");
                }
            },
            error: function (xhr) {
                KTApp.unblock(form);
                Swal.fire("Server response","Server issue occured please try again later or contact support: <?php echo config_item("server_level_support");?>","warning");
            }
        })
    }

    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    var Datatable = function() {

        var withdraws = function() {
            var withdraw = $('#lm_withdraws');

            // begin first table
            withdraw.DataTable({
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
        <'row'<'col-sm-12'tr>>
        <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: true,
                ajax: '<?php echo base_url($auth_role.'/expenses/budgets/index/datasourcewithdraws/'.$budget->budget_key.'/'.$when);?>',
                columns: [
                    {data: 'bg_date'},
                    {data: 'bg_deposit'},
                    {data: 'user'},
                ],
                columnDefs: [
                    {
                        targets: 0,
                        "width": "10%",
                    },
                    {
                        targets: 1,
                        "width": "10%",
                        render: function(data, type, full, meta) {
                            return  numeral(to_money(full.bg_withdraw)).format('0,0') ;
                        },
                    }
                ],
            });
        };

        return {

            //main function to initiate the module
            init: function() {
                withdraws();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });

</script>
