<?php
if(!empty($_GET['when'])) {
    $when = htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
}else{
    $when ='';
}
?>
<script type="text/javascript">

  //== Class definition
  $.fn.dataTable.Api.register('column().title()', function() {
      return $(this.header()).text().trim();
  });

var Datatable = function() {

	var initTable = function() {
		var table = $('#lm_table');

		// begin first table
		table.DataTable({
			responsive: true,
            buttons: [
                'print',
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5',
            ],
            dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
			searchDelay: 500,
			processing: true,
			serverSide: true,
			ajax: '<?php echo base_url($auth_role.'/managers/expenses/employees/index/datasourcer/'.$details->user_id.'/'.$when);?>',
            columns: [
                {data: 'expense_id'},
                {data: 'expense_date'},
                {data: 'employee'},
                {data: 'category_title'},
                {data: 'type_title'},
                {data: 'expense_amount'},
                {data: 'expense_status'},
                {data: 'expense_payee'},
                {data: 'expense_details'},
                {data: 'budget_title'},
            ],
            initComplete: function() {
                this.api().columns().every(function() {
                    var column = this;

                    switch (column.title()) {
                        case 'Employee':
                            column.data().unique().sort().each(function(d, j) {
                                $('.m-input[data-col-index="2"]').append('<option value="' + d + '">' + d + '</option>');
                            });
                            break;
                        case 'Type':
                            column.data().unique().sort().each(function(d, j) {
                                $('.m-input[data-col-index="4"]').append('<option value="' + d + '">' + d + '</option>');
                            });
                            break;
                        case 'Category':
                            column.data().unique().sort().each(function(d, j) {
                                $('.m-input[data-col-index="3"]').append('<option value="' + d + '">' + d + '</option>');
                            });
                            break;
                        case 'Status':
                            var status = {
                                0: {'expense_status': 'Pending', 'class': 'm-badge--brand'},
                                1: {'expense_status': 'Approved', 'class': ' m-badge--success'},
                                2: {'expense_status': 'Rejected', 'class': ' m-badge--danger'},
                            };
                            column.data().unique().sort().each(function(d, j) {
                                $('.m-input[data-col-index="6"]').append('<option value="' + d + '">' + status[d].expense_status + '</option>');
                            });
                            break;
                    }
                });
            },
            columnDefs: [
                {
                    targets: 0,
                    "width": "3%",
                },
                {
                    targets: 1,
                    "width": "7%",
                },
                {
                    targets: 2,
                    "width": "10%",
                    render: function(data, type, full, meta) {
                        return  '<a  href="<?php echo base_url($auth_role.'/managers/expenses/employees/detailsr/');?>' + full.user_id + '">' + full.employee + '</a>';
                    },
                },
                {
                    targets: 3,
                    "width": "10%",
                    render: function(data, type, full, meta) {
                        return  '<a  href="<?php echo base_url($auth_role.'/managers/expenses/categories/detailsr/');?>' + full.category_id + '">' + full.category_title + '</a>';
                    },
                },
                {
                    targets: 4,
                    "width": "10%",
                    render: function(data, type, full, meta) {
                        return  '<a  href="<?php echo base_url($auth_role.'/managers/expenses/types/detailsr/');?>' + full.type_id + '">' + full.type_title + '</a>';
                    },
                },{
                    targets: 5,
                    "width": "5%",
                    render: function(data, type, full, meta) {
                        return  numeral(full.expense_amount).format('0,0') ;
                    },
                },
                {
                    targets: 6,
                    "width": "5%",
                    render: function(data, type, full, meta) {
                        var status = {
                            0: {'expense_status': 'Pending', 'class': 'm-badge--warning'},
                            1: {'expense_status': 'Approved', 'class': ' m-badge--success'},
                            2: {'expense_status': 'Rejected', 'class': ' m-badge--danger'},
                        };
                        if (typeof status[data] === 'undefined') {
                            return data;
                        }
                        return '<a href="#expense-details" data-toggle="modal" data-key="'+ full.expense_id +'"><span class="m-badge ' + status[data].class + ' m-badge--wide">' + status[data].expense_status + '</span></a>';
                    },
                },
                {
                    // hide columns by index number
                    targets: 7,
                    "width": "15%",

                },{
                    // hide columns by index number
                    targets: 8,
                    "width": "10%",
                    visible: false,
                },

                {
                    targets: 9 ,
                    "width": "10%",
                    render: function(data, type, full, meta) {
                        return  '<a  href="<?php echo base_url($auth_role.'/managers/expenses/budgets/detailsr/');?>' + full.budget_id + '">' + full.budget_title + '</a>';
                    },
                },
            ],
		});

        var filter = function() {
            var val = $.fn.dataTable.util.escapeRegex($(this).val());
            let table = $.fn.dataTable.tables( { api: true } );
            table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
        };

        var asdasd = function(value, index) {
            let table = $.fn.dataTable.tables( { api: true } );
            var val = $.fn.dataTable.util.escapeRegex(value);
            table.column(index).search(val ? val : '', false, true);
        };

        $('#m_search').on('click', function(e) {
            e.preventDefault();
            let table = $.fn.dataTable.tables( { api: true } );
            var params = {};
            $('.m-input').each(function() {
                var i = $(this).data('col-index');
                if (params[i]) {
                    params[i] += '|' + $(this).val();
                }
                else {
                    params[i] = $(this).val();
                }
            });
            $.each(params, function(i, val) {
                // apply search params to datatable
                table.column(i).search(val ? val : '', false, false);
            });
            table.table().draw();
        });

        $('#m_reset').on('click', function(e) {
            e.preventDefault();
            let table = $.fn.dataTable.tables( { api: true } );
            $('.m-input').each(function() {
                $(this).val('');
                table.column($(this).data('col-index')).search('', false, false);
            });
            table.table().draw();
        });

        $('#m_datepicker').datepicker({
            todayHighlight: true,
            templates: {
                leftArrow: '<i class="la la-angle-left"></i>',
                rightArrow: '<i class="la la-angle-right"></i>',
            },
        });
	};

	return {

		//main function to initiate the module
		init: function() {
			initTable();
		},

	};

}();

jQuery(document).ready(function() {
	Datatable.init();
});
</script>
