<form id="employeesFormn" onsubmit="return false;" class="kt-form">
      <div class="kt-section kt-section--first">
        <div class="kt-section__body">
          <div class="row">
            <div class="col-12">
              <div class="alert alert-outline-brand" role="alert">
                <div class="alert-text">
                  <h4 class="alert-heading">NOTE</h4>
                  <p>All depts added here will appear in <b>Sallary Slip</b></p>
                <?php date_diffrence('2019-03-24',date('Y-m-d'));?>
                </div>
              </div>
            </div>
            <div class="col-12">
              <div class="form-group row">
                <div class="col-12">
                  <textarea rows="2" name="details" class="form-control" type="text" placeholder="Dept details"><?php echo $dept->id_details;?></textarea>
                </div>
              </div> 
              <div class="form-group row">
                <div class="col-6">
                  <input name="rate" class="form-control number" placeholder="Enter rate amount">
                </div>
                <div class="col-6">
                  <select class="form-control" required name="rate_type">
                    <option value="">Rate type</option>
                    <option <?php if($dept->id_rate_type == 'fixed') echo 'checked';?> value="fixed">Fixed</option>
                    <option <?php if($dept->id_rate_type == 'fixed') echo 'percentage';?> value="percentage">Percentage</option>
                  </select>
                </div>
              </div>
              <div class="form-group row">
                <div class="col-8">
                  <input name="amount"value="<?php echo number_format(to_money($dept->id_amount));?>" class="form-control number" placeholder="Enter dept amount">
                </div>
                <div class="col-4">
                  <button type="submit" class="btn btn-block btn-brand"><b>UPDATE DEPT</b></button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
</form>

  <script type="text/javascript">
  $('select').select2({placeholder:'Select option'});
  (function($, undefined) {
      "use strict";
      // When ready.
      $(function() {
        var $input = $( "input.number" );
        $input.on( "keyup", function( event ) {
            // When user select text in the document, also abort.
            var selection = window.getSelection().toString();
            if ( selection !== '' ) {
                return;
            }
            // When the arrow keys are pressed, abort.
            if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
                return;
            }
            var $this = $( this );
            // Get the value.
            var input = $this.val();
            var input = input.replace(/[\D\s\._\-]+/g, "");
            input = input ? parseInt( input, 10 ) : 0;
            $this.val( function() {
                return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
            } );
        });
      });
  })(jQuery);

  $('form#employeesFormn').submit( function(event){
    let form = $( this );
    let $div =  $('form#employeesFormn');
    let $modal =  $('div#modify');
    event.preventDefault();
    let formdata = form.serialize();
    $.ajax({
     url: '<?php echo base_url('admin/administration/employees/index/modifyinternaldept/'.$employee->user_id.'/'.$dept->id_key);?>',
      type: 'get',
      data: formdata,
      beforeSend: function(){
          KTApp.block($div,{
                  overlayColor:"#000000",
                  type:"loader",
                  state:"success",
                  message:"Updating dept information ...."
              });
        },
       success: function(r){
            var obj = JSON.parse(r);
            if(obj.status == 'ok'){
              reloadsummary();
              $('.kt-datatable').KTDatatable('reload');
                  notifySuccess(obj.message);
                  $modal.modal('hide');
              }else{
                  Swal.fire('',obj.message,'warning');
              }
              KTApp.unblock($div);
           },
        error: function(xhr){
          Swal.fire('',xhr.statusText,'warning');
            KTApp.unblock($div);
            }
    });
  })
  </script>
