<script type="text/javascript">

  var LMDatatableCharges = function() {
    	var initTable = function() {
    		// begin first table
    		var table = $('#lm_table_leave').DataTable({

    			responsive: true,
    			// Pagination settings
    			dom: `<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
    			// read more: https://datatables.net/examples/basic_init/dom.html

    			lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],

    			pageLength: 10,

    			language: {
    				'lengthMenu': 'Display _MENU_',
            buttons: {
                selectAll: "Select all",
                selectNone: "Select none"
            },
            "emptyTable": "No record found",
    			},
    			searchDelay: 500,
    			processing: true,
    			serverSide: true,
    			select:true,
          "ajax":"<?php echo base_url($auth_role.'/hrm/leave/index/datasourceLeave');?>",
    			dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
    			<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
    			buttons: [
            {
              text: 'Delete Seleted',
              action: function ( e, dt, node, config ) {
                  deleteSelected( table);
                }
            },
            'selectAll',
            'selectNone',
    				'excelHtml5',
    				'pdfHtml5',
    			],
          columns: [
            {data: 'hrm_leave_schemes_title'},
            {data: 'action'},
          ],
          columnDefs: [
          {
            targets: 0,
            render: function(data, type, full, meta){
              return ucfirst(data);
            }
          },
            {
              targets: 1,
              render: function(data, type, full, meta){
                return '<a href="javascript:details(' + full.hrm_leave_schemes_key + ');"><i class="flaticon-eye text-success"></i></a> | ' +
                    '<a href="javascript:modify(' + full.hrm_leave_schemes_key + ');"><i class="flaticon-edit text-warning"></i></a> | ' +
                    '<a href="javascript:deleteLeave(' + full.hrm_leave_schemes_key + ');"><i class="flaticon-delete text-danger"></i></a>';
              }
            }
          ],
    		});
    	};

    	return {
    		//main function to initiate the module
    		init: function() {
    			initTable();
    		},

    	};

    }();

  jQuery(document).ready(function() {
    $('select').css('width','100%');
    $('select').select2({placeholder: 'select option'});
    let height = $(window).innerHeight()  - 250;
    $('.lm_max_height').css({ height: height });
    $(window).resize(function(){
      $('.lm_max_height').css({ height: height });
    });
  	LMDatatableCharges.init();
    $('form#newChargeForm').submit( function(event){
      let form = $( this );
      event.preventDefault();
      let formdata = form.serialize();
      $.ajax({
       url: '<?php echo base_url($auth_role.'/hrm/leave/index/newleave/')?>',
        type: 'get',
        data: formdata,
        beforeSend: function(){
            KTApp.block("form#newChargeForm",{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Creating new Charge ...."
                });
          },
         success: function(r){
              var obj = JSON.parse(r);
              if(obj.status == 'ok'){
                notifySuccess(obj.message);
                var table = $.fn.dataTable.tables( { api: true } );
                table.clear().draw();
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock('form#newChargeForm');
                $('div#newCharge').modal('hide');
             },
          error: function(){
              KTApp.unblock('form#newChargeForm');
              }
      });
    })
  });

  function deleteLeave(leave){
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this!",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
      if (result.value) {
        $.ajax({
            url: '<?php echo base_url($auth_role.'/hrm/leave/index/delete/leave')?>/'+leave,
            type: 'get',
            beforeSend: function(){
                KTApp.block("#lm_table_leave",{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Deleting Charge ..."
                    });
              },
             success: function(result){
                 let obj = JSON.parse(result);
                     if( obj.status == 'ok'){
                       notifySuccess(obj.message);
                       var table = $.fn.dataTable.tables( { api: true } );
                       table.clear().draw();
                      }else{
                        Swal.fire('',obj.message,'warning');
                      }
                 KTApp.unblock('#lm_table_leave');
                 },
              error: function(xhr){
                  KTApp.unblock('#lm_table_leave');
                  Swal.fire('',xhr.statusText,'warning');
                  }
        });
      }
    })
  }

  function details(leave){
    let $modal =  $('div#chargeDetails');
    let $div = $modal.find('.modal-body');
    $div.html('');
    $modal.modal('show');
    $.ajax({
      url: '<?php echo base_url($auth_role.'/charges/index/detailsCharge/');?>' + charge,
      type: 'get',
      beforeSend: function(){
      KTApp.block($div,{
              overlayColor:"#000000",
              type:"loader",
              state:"success",
              message:"Loading charge details ...."
          });
      },
      success: function (result){
        $div.html(result);
        KTApp.unblock($div);
      },
      error: function (xhr){
        $modal.modal('hide');
        KTApp.unblock($div);
        Swal.fire('',xhr.statusText,'warning');
      }
    })
  }

  function modify(leave){
    let $modal =  $('div#leaveDetails');
    let $div = $modal.find('.modal-body');
    $div.html('');
    $modal.modal('show');
    $.ajax({
      url: '<?php echo base_url($auth_role.'/hrm/leave/index/modifyLeave/');?>' + leave,
      type: 'get',
      beforeSend: function(){
      KTApp.block($div,{
              overlayColor:"#000000",
              type:"loader",
              state:"success",
              message:"Loading leave details ...."
          });
      },
      success: function (result){
        $div.html(result);
        KTApp.unblock($div);
      },
      error: function (xhr){
        $modal.modal('hide');
        KTApp.unblock($div);
        Swal.fire('',xhr.statusText,'warning');
      }
    })
  }

  function deleteSelected(table){
    if(table.rows('.selected').data().length<1)
    return;
    var data= [];
   $.each(table.rows('.selected').data(), function() {
     data.push(this["charge_key"]);
   });
    Swal.fire({
      title: 'Are you sure?',
      text: "You are going to DELETE " + table.rows('.selected').data().length + " charges",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, Delete them!'
    }).then((result) => {
      if (result.value) {
        $.ajax({
            url: '<?php echo base_url($auth_role.'/charges/index/deleteselected/');?>',
            type: 'get',
            data: {'data':data},
            beforeSend: function(){
                KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Please wait ..."
                    });
              },
             success: function(result){
                   let obj = JSON.parse(result);
                     if( obj.status == 'ok'){
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();
                      }else{
                        Swal.fire('',obj.message,'warning');
                      }
                   KTApp.unblockPage();
                 },
             error: function(xhr){
                KTApp.unblockPage();
                Swal.fire('',xhr.statusText,'warning');
                }
        });
      }
    })
  }

  document.querySelector("#print").addEventListener("click", function() {
    printJS({ printable: 'printArea', type: 'html', header: '<?php echo config_item('application_name');?> - Leave Details',css:'<?php echo base_url('resources')?>/assets/demo/default/base/style.bundle.css','style':'link{text-decoration:none;}'});
  });
</script>
