<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<script type="text/javascript">
(function($, undefined) {
    "use strict";
    // When ready.
    $(function() {
      var $input = $( "input.number" );
      $input.on( "keyup", function( event ) {
          // When user select text in the document, also abort.
          var selection = window.getSelection().toString();
          if ( selection !== '' ) {
              return;
          }
          // When the arrow keys are pressed, abort.
          if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
              return;
          }
          var $this = $( this );
          // Get the value.
          var input = $this.val();
          var input = input.replace(/[\D\s\._\-]+/g, "");
          input = input ? parseInt( input, 10 ) : 0;
          $this.val( function() {
              return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
          } );
      });
    });
})(jQuery);

$( function(){
  $('form#registerCollateral').submit( function(e){
    e.preventDefault();
    var div = $('div#printArea');
    var divContainer = $('div#details');
    var file_data = $('#file').prop('files')[0];
    var value = $('#value').val();
    var type = $('#type').val();
    var date = $('#date').val();
    var form_data = new FormData();
    form_data.append('file', file_data);
    form_data.append('type', type);
    form_data.append('value', value);
    form_data.append('date', date);
      $.ajax({
          dataType: 'text', // what to expect back from the server
          cache: false,
          contentType: false,
          processData: false,
          data: form_data,
          type: 'get',
          url: '<?php echo base_url($auth_role.'/loans/applications/registerCollateral/'.$application->app_key);?>',
          beforeSend: function(){
              window.onbeforeunload = function(event) {
                  var message = "Wait until i finish uploading data to the database";
                      var e = e || window.event;
                      if (e) {
                          e.returnValue = message;
                      }
                      return message;
                  };
            KTApp.block(div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"danger",
                    message:"Updating collateral information ..."
                });
          },
          success: function (r){
              var obj = JSON.parse(r);
              window.onbeforeunload = null;
              KTApp.unblock(div);
              if(obj.status == 'ok'){
                notifySuccess(obj.message);
                divContainer.load('<?php echo base_url($auth_role.'/loans/applications/loadcollaterals/'.$application->app_key);?>');
                }else{
                notifyWarning(obj.message);
              }
          },
          error: function(xhr){
            window.onbeforeunload = null;
            Swal.fire('',xhr.statusText,'warning');
            KTApp.unblock(div);
          }
    });
    //$('form#registerCollateralt').trigger("reset");
});
})

document.querySelector("#print").addEventListener("click", function() {
  printJS({ printable: 'printArea', type: 'html', header: '<?php echo config_item('application_name');?> - Payment Summary | <?php echo date('Y M d');?>',css:'<?php echo base_url('resources')?>/assets/demo/default/base/style.bundle.css','style':'link{text-decoration:none;}'});
});
</script>
