<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php if(!empty($this->loansModel->applicationnextpayment($application->app_key)) && strtolower($application->app_status) == 'approved'){?>
<form id="#approveme" class="kt-form" onsubmit="collectPayment(<?php echo $this->loansModel->applicationnextpayment($application->app_key)->loan_payment_id;?>); return false">
  <div class="form-group row">
    <div class="col-3">
      <div class="input-group">
        <input type="text" name="installment_number" readonly class="form-control" value="<?php echo 'Installemt #. '.$this->loansModel->applicationnextpayment($application->app_key)->loan_payment_number;?>">
      </div>
    </div>
    <div class="col-3">
      <div class="input-group date">
        <input type="text" name="loan_payment_amount" id="loan_payment_amount"   class="form-control number" value="<?php
        echo lm_number(to_money($this->loansModel->applicationnextpayment($application->app_key)->loan_payment_collection_balance));?>">
        <div class="input-group-append">
          <span class="input-group-text">
            <i class="la la-dollar glyphicon-th"></i>
          </span>
        </div>
      </div>
    </div>
    <div class="col-3">
      <div class="input-group date">
        <button type="submit" class="btn btn-warning btn-block" name="button">COLLECT</button>
      </div>
    </div>
    <div class="col-3">
      <div class="input-group date">
        <a href="javascript:(0);" onclick="collectAllPayments(<?php echo $application->app_key;?>,<?php echo $this->loansModel->applicationnextpayment($application->app_key)->loan_payment_number;?>);" class="btn btn-danger btn-block" name="button">COLLECT ALL</a>
      </div>
    </div>
  </div>
</form>
<?php }else{
    if(strtolower($application->app_status) != 'approved'){?>
<div class="alert alert-outline-danger">
        <h3>Application is pending <b>Approval</h3>
</div>
    <?php }
} ?>

<table class="table table-info table-bordered">
 <thead>
   <tr>
     <th>#</th>
     <th>Date</th>
     <th>Principal</th>
     <th>Interest</th>
     <th>Charges</th>
     <th>Total</th>
     <th>Paid</th>
     <th>Balance</th>
     <th>Status</th>
   </tr>
 </thead>
 <tbody>
   <?php if(!empty($payments)){
     $totalPrincipal = 0;
     $totalCharges = 0;
     $totalInterest = 0;
     $grandTotal = 0;
     $total = 0;
     $chargesAmount =0;
     foreach ($payments as $key => $payment) {
         $totalInterest = $totalInterest + $payment['loan_payment_interest'];
         $totalPrincipal = $totalPrincipal + $payment['loan_payment_principal'];
         $grandTotal = $totalInterest + $totalPrincipal;
         $total =  $payment['loan_payment_interest'] + $payment['loan_payment_principal'];
       ?>
       <tr <?php
       if(isDateBetween(date('Y-m-d'),$payment['loan_payment_schedule_start'],$payment['loan_payment_schedule_end'])){
         echo 'style="background:green; color:white"';
       }
       if(!empty($this->loansModel->applicationnextpayment($payment['loan_payment_app'])) && $this->loansModel->applicationnextpayment($payment['loan_payment_app'])->loan_payment_id == $payment['loan_payment_id']) { echo 'style="background:red; color:white;"'; }
       if(!$payment['loan_payment_collected']){ echo 'style="color:red;"';} ?>>
         <td><?php echo $payment['loan_payment_number'];?></td>
         <td><?php echo $payment['loan_payment_schedule_end'];?></td>
         <td><?php echo lm_number(to_money($payment['loan_payment_principal']));?></td>
         <td><?php echo lm_number(to_money($payment['loan_payment_interest']));?></td>
         <td><?php echo lm_number(to_money($payment['loan_payment_charges']));?></td>
         <td><?php echo lm_number(to_money($payment['loan_payment_amount']));?></td>
         <td><?php echo lm_number(to_money($payment['loan_payment_total_collected']));?></td>
         <td><?php echo lm_number(to_money($payment['loan_payment_collection_balance']));?></td>
            <td><?php  if($payment['loan_payment_collected']) {
              echo '<span class="badge badge-success">Collected</span>';
            } else{
              echo '<span class="badge badge-danger">Pending</span>';
            };?> </td>
       </tr>
     <?php  $chargesAmount = 0; } ?>
       <tr>
         <th colspan="2">Total Principal</th>
         <th colspan="2">Total Interest</th>
         <th colspan="2">Grand Total</th>
         <th colspan="3">Status</th>
       </tr>
       <tr>
         <td colspan="2"><?php echo runnCurrency()->currency_symbol.lm_number(to_money($totalPrincipal));?></td>
         <td colspan="2"><?php echo runnCurrency()->currency_symbol.lm_number(to_money($totalInterest));?></td>
         <td colspan="2"><?php echo runnCurrency()->currency_symbol.lm_number(to_money($grandTotal + $totalCharges));?></td>
         <td colspan="3"> <?php if($this->loansModel->applicationisfullpaid($application->app_key)){ echo 'Full Paid';}else{ echo 'Partially Paid';}?></td>
       </tr>
     <?php
   } ?>
 </tbody>
</table>
<script type="text/javascript">
(function($, undefined) {
    "use strict";
    // When ready.
    $(function() {
      var $input = $( "input.number" );
      $input.on( "keyup", function( event ) {
          // When user select text in the document, also abort.
          var selection = window.getSelection().toString();
          if ( selection !== '' ) {
              return;
          }
          // When the arrow keys are pressed, abort.
          if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
              return;
          }
          var $this = $( this );
          // Get the value.
          var input = $this.val();
          var input = input.replace(/[\D\s\._\-]+/g, "");
          input = input ? parseInt( input, 10 ) : 0;
          $this.val( function() {
              return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
          } );
      });
    });
})(jQuery);

function collectAllPayments(app,number){
  let div = $('div#details');
  let data = $('input#loan_payment_amount').val();
  event.preventDefault();
  Swal.fire({
    title: 'Are you sure?',
    text: "You won't be able to revert!",
    type: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Yes, Collect!'
  }).then((result) => {
    if (result.value) {
      $.ajax({
          url: '<?php echo base_url($auth_role.'/loans/repayments/collectallpayments/');?>' + app + '/' + number,
          type: 'get',
          data: {'loan_payment_amount': data},
          beforeSend: function(){
              KTApp.block("table",{
                      overlayColor:"#000000",
                      type:"loader",
                      state:"danger",
                      message:"Collecting Payment ..."
                  });
            },
           success: function(result){
               let obj = JSON.parse(result);
                   if( obj.status == 'ok'){
                      notifySuccess(obj.message);
                      div.load('<?php echo base_url($auth_role.'/loans/applications/loadpayments/'.$application->app_key);?>')
                    }else{
                      KTApp.unblock("table");
                      Swal.fire('',obj.message,'warning');
                    }
               },
            error: function(xhr){
              KTApp.unblock("table");
                Swal.fire('',xhr.statusText,'warning');
                }
      });
    }
  })
}

  function collectPayment(app){
    let div = $('div#details');
    let data = $('input#loan_payment_amount').val();
    event.preventDefault();
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert!",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, Collect!'
    }).then((result) => {
      if (result.value) {
        $.ajax({
            url: '<?php echo base_url($auth_role.'/loans/repayments/collectsingle/');?>' + app,
            type: 'get',
            data: {'loan_payment_amount': data},
            beforeSend: function(){
                KTApp.block("table",{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Collecting Payment ..."
                    });
              },
             success: function(result){
                 let obj = JSON.parse(result);
                     if( obj.status == 'ok'){
                        notifySuccess(obj.message);
                        div.load('<?php echo base_url($auth_role.'/loans/applications/loadpayments/'.$application->app_key);?>')
                      }else{
                        KTApp.unblock("table");
                        Swal.fire('',obj.message,'warning');
                      }
                 },
              error: function(xhr){
                KTApp.unblock("table");
                  Swal.fire('',xhr.statusText,'warning');
                  }
        });
      }
    })
  }
</script>
