<script type="text/javascript">

    var LMDatatable = function() {

    	$.fn.dataTable.Api.register('column().title()', function() {
    		return $(this.header()).text().trim();
    	});

    	var initTable = function() {
    		// begin first table
    		var table = $('#lm_table').DataTable({
    			responsive: true,
    			// Pagination settings
    			dom: `<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
    			// read more: https://datatables.net/examples/basic_init/dom.html

    			lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],

    			pageLength: 10,
                        "order": [[ 0, "desc" ]],
    			language: {
                            'lengthMenu': 'Display _MENU_',
    			},

    			searchDelay: 500,
    			processing: true,
    			serverSide: true,
    			select: true,
    			ajax: {
    				url: '<?php echo base_url($auth_role.'/loans/applications/datasource');?>',
    				type: 'POST',
    				data: {
    					// parameters for custom backend script demo
    					columnsDef: [
    						'app_id', 'customer', 'groupname', 'app_date', 'loan_name', 'principal',
    						'interest','status',],
    				},
    			},
    			dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
    			<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
    			buttons: [
    				'print',
    				'copyHtml5',
    				'excelHtml5',
    				'csvHtml5',
    				'pdfHtml5',
    			],
    			columns: [
    				{data: 'app_id'},
    				{data: 'customer'},
    				{data: 'groupname'},
    				{data: 'app_date'},
    				{data: 'loan_name'},
    				{data: 'principal'},
    				{data: 'interest'},
    				{data: 'status', responsivePriority: -1},
    			],

    			columnDefs: [
    				{
    					targets: 7,
    					render: function(data, type, full, meta) {
    						var status = {
    							'Pending': {'title': 'Pending', 'class': 'kt-badge--warning'},
    							'Approved': {'title': 'Approved', 'class': ' kt-badge--success'},
    						};
    						if (typeof status[data] === 'undefined') {
    							return data;
    						}
    						return '<a href="<?php echo base_url($auth_role.'/loans/applications/details/');?>' + full.app_key +'"><span class="kt-badge ' + status[data].class + ' kt-badge--inline">' + status[data].title + '</span></a>';
    					},
    				},
    				{
    					targets: 1,
    					render: function(data, type, full, meta) {
    						return '<a href="<?php echo base_url($auth_role.'/loans/applications/details/');?>' + full.app_key +'">' + data + '</a>';
    					},
    				},
    			],
    		});

    		var filter = function() {
    			var val = $.fn.dataTable.util.escapeRegex($(this).val());
    			table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
    		};

    		var asdasd = function(value, index) {
    			var val = $.fn.dataTable.util.escapeRegex(value);
    			table.column(index).search(val ? val : '', false, true);
    		};

    		$('#kt_search').on('click', function(e) {
    			e.preventDefault();
    			var params = {};
    			$('.kt-input').each(function() {
    				var i = $(this).data('col-index');
    				if (params[i]) {
    					params[i] += '|' + $(this).val();
    				}
    				else {
    					params[i] = $(this).val();
    				}
    			});
    			$.each(params, function(i, val) {
    				// apply search params to datatable
    				table.column(i).search(val ? val : '', false, false);
    			});
    			table.table().draw();
    		});

    		$('#kt_reset').on('click', function(e) {
    			e.preventDefault();
    			$('.kt-input').each(function() {
    				$(this).val('');
    				table.column($(this).data('col-index')).search('', false, false);
    			});
    			table.table().draw();
    		});

    		$('#kt_datepicker').datepicker({
    			todayHighlight: true,
    			templates: {
    				leftArrow: '<i class="la la-angle-left"></i>',
    				rightArrow: '<i class="la la-angle-right"></i>',
    			},
    		});

    		$('input#checkall').click(function() {
    			var set = $(this).closest('table').find('.checkbox_value');
    			var checked = $(this).is(':checked');
    			$(set).each(function() {
    				if (checked) {
    					$(this).prop('checked', true);
    					table.rows($(this).closest('tr')).select();
    				}
    				else {
    					$(this).prop('checked', false);
    					table.rows($(this).closest('tr')).deselect();
    				}
    			});
    		});

    	  $('table#lm_table').dataTable().find('input#checkbox_value').each( function(){
    			$( this ).click( function(){
    				alert();
    			})
    		});

    	};

    	return {

    		//main function to initiate the module
    		init: function() {
    			initTable();
    		},

    	};

    }();

    var LMDatatableMe = function() {

      $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
      });

      var initTable = function() {
        // begin first table
        var table = $('#lm_table_applications_me').DataTable({
          responsive: true,
          // Pagination settings
          dom: `<'row'<'col-sm-12'tr>>
          <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
          // read more: https://datatables.net/examples/basic_init/dom.html

          lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],

          pageLength: 10,
          "order": [[ 0, "desc" ]],
          language: {
            'lengthMenu': 'Display _MENU_',
          },

          searchDelay: 500,
          processing: true,
          serverSide: true,
          select: true,
          ajax: {
            url: '<?php echo base_url($auth_role.'/loans/applications/datasourceme');?>',
            type: 'POST',
            data: {
              // parameters for custom backend script demo
              columnsDef: [
                'app_id', 'customer', 'groupname', 'app_date', 'loan_name', 'principal',
                'interest','status',],
            },
          },
          dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
          <'row'<'col-sm-12'tr>>
          <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
          buttons: [
            'print',
            'copyHtml5',
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5',
          ],
          columns: [
            {data: 'app_id'},
            {data: 'customer'},
            {data: 'groupname'},
            {data: 'app_date'},
            {data: 'loan_name'},
            {data: 'principal'},
            {data: 'interest'},
            {data: 'status'},
          ],

          columnDefs: [
            {
              targets: 7,
              render: function(data, type, full, meta){
                var status = {
                  'Pending': {'title': 'Pending', 'class': ' kt-badge--warning'},
                  'Approved': {'title': 'Approved', 'class': ' kt-badge--success'},
                };
                if (typeof status[data] === 'undefined'){
                  return data;
                }
                return '<a href="<?php echo base_url($auth_role.'/loans/applications/details/');?>' + full.app_key +'"><span class="kt-badge ' + status[data].class + ' kt-badge--inline">' + status[data].title + '</span></a>';
              },
            },
            {
              targets: 1,
              render: function(data, type, full, meta) {                                                                 
                return '<a href="<?php echo base_url($auth_role.'/loans/applications/details/');?>' + full.app_key +'">' + data + '</a>';
              },
            },
          ],
        });

        var filter = function() {
          var val = $.fn.dataTable.util.escapeRegex($(this).val());
          table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
        };

        var asdasd = function(value, index) {
          var val = $.fn.dataTable.util.escapeRegex(value);
          table.column(index).search(val ? val : '', false, true);
        };

        $('#kt_search').on('click', function(e) {
          e.preventDefault();
          var params = {};
          $('.kt-input').each(function() {
            var i = $(this).data('col-index');
            if (params[i]) {
              params[i] += '|' + $(this).val();
            }
            else {
              params[i] = $(this).val();
            }
          });
          $.each(params, function(i, val) {
            // apply search params to datatable
            table.column(i).search(val ? val : '', false, false);
          });
          table.table().draw();
        });

        $('#kt_reset').on('click', function(e) {
          e.preventDefault();
          $('.kt-input').each(function() {
            $(this).val('');
            table.column($(this).data('col-index')).search('', false, false);
          });
          table.table().draw();
        });

        $('#kt_datepicker').datepicker({
          todayHighlight: true,
          templates: {
            leftArrow: '<i class="la la-angle-left"></i>',
            rightArrow: '<i class="la la-angle-right"></i>',
          },
        });

        $('input#checkall').click(function() {
          var set = $(this).closest('table').find('.checkbox_value');
          var checked = $(this).is(':checked');
          $(set).each(function() {
            if (checked) {
              $(this).prop('checked', true);
              table.rows($(this).closest('tr')).select();
            }
            else {
              $(this).prop('checked', false);
              table.rows($(this).closest('tr')).deselect();
            }
          });
        });

        $('table#lm_table').dataTable().find('input#checkbox_value').each( function(){
          $( this ).click( function(){
            alert();
          })
        });

      };

      return {

        //main function to initiate the module
        init: function() {
          initTable();
        },

      };

    }();

    jQuery(document).ready(function() {
    	LMDatatable.init();
      LMDatatableMe.init();
    });

    function to_money(money){
      let unit = '<?php echo 1 * runnCurrency()->currency_convention;?>';
      let result = money * unit;
      return result.toLocaleString('TZS');
    }

    function ucfirst(string){
      return string.charAt(0).toUpperCase() + string.slice(1);
    }
</script>
