<form id="basicform" class="kt-form">
    <div class="form-group">
			<label class="col-lg-2 col-form-label">Charges</label>
			<div data-repeater-list="" class="col-lg-10">
				<div data-repeater-item class="form-group row align-items-center">
					<div class="col-md-6">
								<select required class="form-control" name="loan_charge" style="width:100%;">
                  <option value=""></option>
                  <?php if(!empty($charges)){
                    foreach ($charges as $key => $value) {?>
                        <option value="<?php echo $value['charge_key'];?>"><?php echo $value['charge_name'];?></option>
                    <?php }} ?>
                </select>
					</div>
					<div class="col-md-4">
						<button type="submit" class="btn btn-brand pull-right" name="button">ADD</button>
					</div>
				</div>
			</div>
		</div>
</form>
<hr/>
<div class="kt-portlet__body kt-portlet__body--fit">
    <div class="kt-datatable" id="kt-datatables"></div>
</div>
<div class="modal fade" id="chargeDetails" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterCharge" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
      <div class="modal-content" style="border:0px;">
        <div class="modal-header bg-dark">
          <h5 class="modal-title text-white" id="exampleModalLongCharge">Charge Details</h5>
          <a id="print" href="javascript:(0);" class=" modal-title text-white" style="right:60px; position:absolute;">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <rect id="bound" x="0" y="0" width="24" height="24"/>
                    <path d="M16,17 L16,21 C16,21.5522847 15.5522847,22 15,22 L9,22 C8.44771525,22 8,21.5522847 8,21 L8,17 L5,17 C3.8954305,17 3,16.1045695 3,15 L3,8 C3,6.8954305 3.8954305,6 5,6 L19,6 C20.1045695,6 21,6.8954305 21,8 L21,15 C21,16.1045695 20.1045695,17 19,17 L16,17 Z M17.5,11 C18.3284271,11 19,10.3284271 19,9.5 C19,8.67157288 18.3284271,8 17.5,8 C16.6715729,8 16,8.67157288 16,9.5 C16,10.3284271 16.6715729,11 17.5,11 Z M10,14 L10,20 L14,20 L14,14 L10,14 Z" id="Combined-Shape" fill="#000000"/>
                    <rect id="Combined-Shape-Copy" fill="#000000" opacity="0.3" x="8" y="2" width="8" height="2" rx="1"/>
                </g>
            </svg>
          </a>
          <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <rect id="bound" x="0" y="0" width="24" height="24"/>
                    <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                    <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                </g>
            </svg></a>
        </div>
        <div class="kt-scroll lm_max_height" data-scroll="true" style=" overflow-y: scroll; padding:30px;">
          <div class="modal-body text-back" id="printArea">

          </div>
        </div>
        <div class="modal-footer bg-dark">
        <small> &copy <?php echo date('Y') ;?> Lockminds BMS | Charge details</small>
        </div>
      </div>
    </div>
  </div>
</div>
<script type="text/javascript">
function ChargeDetails(charge){
  let $modal =  $('div#chargeDetails');
  let $div = $modal.find('.modal-body');
  $div.html('');
  $modal.modal('show');
  $.ajax({
    url: '<?php echo base_url($auth_role.'/charges/index/detailsCharge/');?>' + charge,
    type: 'get',
    beforeSend: function(){
    KTApp.block($div,{
            overlayColor:"#000000",
            type:"loader",
            state:"success",
            message:"Loading charge details ...."
        });
    },
    success: function (result){
      $div.html(result);
      KTApp.unblock($div);
    },
    error: function (xhr){
      $modal.modal('hide');
      KTApp.unblock($div);
      Swal.fire('',xhr.statusText,'warning');
    }
  })
}

$('select').select2({placeholder:'Select charge'});
function ucfirst(string){
  return string.charAt(0).toUpperCase() + string.slice(1);
}

$(function(){
  $('select').css('width','100%');
  $('select').select2({placeholder: 'select option'});
let height = $(window).innerHeight()  - 250;
  $('.lm_max_height').css({ height: height });
  $(window).resize(function(){
    $('.lm_max_height').css({ height: height });
  });
});

  $(function(){
    $('form#basicform').submit( function(event){
    event.preventDefault();
      let form = $( this );
      let $div =  $('div#details');
      let formdata  = form.serialize();
      $.ajax({
       url: '<?php echo base_url($auth_role.'/loans/index/loadchargesAction/'.$loan->loan_key);?>',
        type: 'get',
        data: formdata,
        beforeSend: function(){
            KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Updating loan charges information ...."
                });
          },
         success: function(r){
              var obj = JSON.parse(r);
              if(obj.status == 'ok'){
              Swal.fire('',obj.message,'success');
                $('.kt-datatable').KTDatatable('reload');
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock($div);
             },
          error: function(xhr){
            Swal.fire('',xhr.statusText,'warning');
              KTApp.unblock($div);
              }
      });
    })

    "use strict";
    // Class definition

    var KTDefaultDatatableDemo = function() {
      // Private functions

      // basic demo
      var demo = function() {

        var options = {
          // datasource definition
          data: {
            type: 'remote',
            source: {
              read: {
                url: '<?php echo base_url($auth_role.'/loans/index/datasourcecharges/'.$loan->loan_key);?>',
              },
            },
            pageSize: 10, // display 20 records per page
            serverPaging: true,
            serverFiltering: true,
            serverSorting: true,
          },

          // layout definition
          layout: {
            scroll: true, // enable/disable datatable scroll both horizontal and vertical when needed.
            //height: 400, // datatable's body's fixed height
            footer: false, // display/hide footer
          },

          // column sorting
          sortable: true,

          pagination: true,

          search: {
            input: $('#generalSearch'),
          },

          // columns definition
          columns: [
            {
              field: 'id',
              title: '#',
              sortable: false,
              width: 30,
              type: 'number',
              selector: {class: 'kt-checkbox--solid'},
              textAlign: 'center',
              locked: {left: 'lg'},
            }, {
              field: 'charge_name',
              title: 'Charge',
              locked: {left: 'lg'},
              template: function(row){
                return ucfirst(row.charge_name);
              }
            },  {
      					field: 'product_name',
      					title: 'Product',
                template: function(row){
                  return ucfirst(row.product_name);
                }
      				},
              {
                field: 'charge_amount',
                title: 'Value',
                template: function(row) {
                  if(row.charge_option == 'percent'){
                    return to_money(row.charge_amount) + '%';
                  }else{
                    return to_money(row.charge_amount);
                  }

                }
              },
            {
              field: 'charge_type',
              title: 'Type',
              template: function(row){
                return ucfirst(row.charge_type);
              }
            },
              {
                field: 'charge_option',
                title: 'Option',
                template: function(row){
                  return ucfirst(row.charge_option);
                }
              },
              {
                field: 'charge_active',
                title: 'Active',
                template: function(row){
                  return ucfirst(row.charge_status);
                }
              },
              {
                field: 'charge_overide',
                title: 'Override',
                template: function(row){
                  return ucfirst(row.charge_overide);
                }
              },
            {
              field: 'lc_actions',
              title: 'Actions',
              sortable: false,
              width: 80,
              overflow: 'visible',
              autoHide: false,
              locked: {right: 'lg'}
            }],

        };

        var datatable = $('.kt-datatable').KTDatatable(options);


      };

      return {
        // public functions
        init: function() {
          demo();
        },
      };
    }();

    jQuery(document).ready(function() {
      KTDefaultDatatableDemo.init();
    });
  })

  function deleteItem(charge){
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this!",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
      if (result.value) {
        $.ajax({
            url: '<?php echo base_url($auth_role.'/loans/index/delete/charge')?>/'+charge,
            type: 'get',
            beforeSend: function(){
                KTApp.block(".kt-datatable",{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Deleting Charge ..."
                    });
              },
             success: function(result){
                 let obj = JSON.parse(result);
                     if( obj.status == 'ok'){
                        Swal.fire('',obj.message,'success');
                        $('.kt-datatable').KTDatatable('reload');
                      }else{
                        Swal.fire('',obj.message,'warning');
                      }
                 KTApp.unblock('.kt-datatable');
                 },
              error: function(xhr){
                  KTApp.unblock('.kt-datatable');
                  Swal.fire('',xhr.statusText,'warning');
                  }
        });
      }
    })
  }

</script>
