<script type="text/javascript">

function moveUp(selectId) {
	var selectList = document.getElementById(selectId);
	var selectOptions = selectList.getElementsByTagName('option');
	for (var i = 1; i < selectOptions.length; i++) {
		var opt = selectOptions[i];
		if (opt.selected) {
			selectList.removeChild(opt);
			selectList.insertBefore(opt, selectOptions[i - 1]);
		}
       }
}

function moveDown(selectId) {
	var selectList = document.getElementById(selectId);
	var selectOptions = selectList.getElementsByTagName('option');
	for (var i = selectOptions.length - 2; i >= 0; i--) {
		var opt = selectOptions[i];
		if (opt.selected) {
		   var nextOpt = selectOptions[i + 1];
		   opt = selectList.removeChild(opt);
		   nextOpt = selectList.replaceChild(opt, nextOpt);
		   selectList.insertBefore(nextOpt, opt);
		}
       }
}
</script>
<style>
  #sortable { list-style-type: none; margin: 0; padding: 0; width: 100%; }
  </style>
	<div class="alert alert-outline-brand" role="alert">
			<div class="alert-text">
				<h4 class="alert-heading">Processing Order</h4>
				<p>The Transaction Processing Strategy determines the order incoming payments are allocated between Interest, Principal, Penalties and Fees. the default setting is ‘Interest, Principal, Penalties, Fees’, which ensures that clients with an outstanding Penalty are still able to repay their full loan instalment.</p>
				<hr>
				<p class="mb-0">Drag item to change order</p>
			</div>
		</div>
  <div class="form-group row">
    <div class="col-4">
			<label for="">Repayment Order</label>
			<div class="kt-widget4" id="sortable">
				<?php   $po = unserialize($loan->loan_payment_order);
        if(!empty($po)){
          foreach ($po as $key => $value) {
						$mod = $key % 2;
						if($mod == 1){
							$class='info kt-font-light';
						}else{
							$class = 'success kt-font-light';
						}?>
						<div id="loan_payment_order-<?php echo $value;?>" class="ui-state-default kt-widget4__item  kt-padding-10 bg-<?php echo $class;?>" style="border:0px; color:white;">
							<a id="<?php echo $value;?>" href="#" class="kt-widget4__title kt-widget4__title--light kt-padding-l-10 kt-font-light">
								<?php echo ucfirst($value);?>
							</a>
					</div>
          <?php  }
          }  ?>

			</div>
		</div>

		<div class="col-4">
			<label for="">Approve Order</label>
			<div class="kt-widget4" id="sortableApprove">
				<?php   $po = unserialize($loan->loan_approve_order);
        if(!empty($po)){
          foreach ($po as $key => $value) {
						$mod = $key % 2;
						if($mod == 1){
							$class='danger kt-font-light';
						}else{
							$class = 'warning kt-font-light';
						}?>
						<div id="loan_approve_order-<?php echo $value;?>" class="ui-state-default kt-widget4__item  kt-padding-10 bg-<?php echo $class;?>" style="border:0px; color:white;">
							<a id="<?php echo $value;?>" href="#" class="kt-widget4__title kt-widget4__title--light kt-padding-l-10 kt-font-light">
								<?php echo ucfirst($this->titlesModel->category($value)->category_name);?>
							</a>
					</div>
          <?php  }
          }  ?>

			</div>
		</div>
		<div class="col-4">
			<form id="approvers" action="#">
			<label for="">Approver Titles</label>
			<select class="form-control" name="loan_approve_order[]" multiple>
				<option value=""></option>
				<?php if(!empty($titles = $this->titlesModel->categories())){
					foreach ($titles as $key => $title) {?>
						<option <?php if(in_array_r($title['category_key'],unserialize($loan->loan_approve_order))) echo 'selected';?> value="<?php echo $title['category_key'];?>"><?php echo $title['category_name'];?></option>
					<?php }
				} ?>
			</select><br/>
			<button type="button" id="approveorder" class="btn btn-success btn-block" name="button">APPLY</button>
		</form>
		</div>

</div>
<script type="text/javascript">
$( function() {
	  $('button#approveorder').click( function(event){
			event.preventDefault();
			let $div =  $('div#details');
			let values = $('form#approvers').serialize();
			$.ajax({
			 url: '<?php echo base_url($auth_role.'/loans/index/approveOrderupdate/'.$loan->loan_key);?>' ,
				type: 'get',
				data:values,
				beforeSend: function(){
						KTApp.block($div,{
										overlayColor:"#000000",
										type:"loader",
										state:"success",
										message:"Updating processing information ...."
								});
					},
				 success: function(r){
							var obj = JSON.parse(r);
							if(obj.status == 'ok'){
								 notifySuccess(obj.message);
								$div.load("<?php echo base_url($auth_role.'/loans/index/loadprocessing/'.$loan->loan_key);?>");
								}else{
									notifyWarning(obj.message);
								}
								KTApp.unblock($div);
						 },
					error: function(xhr){
						Swal.fire('',xhr.statusText,'success');
							KTApp.unblock($div);
							}
			});
		});

		$('select').select2({placeholder: 'Select title'});
    $( "#sortable" ).sortable({
			"ui-sortable": "kt-widget4__item",
      placeholder: "ui-state-highlight",
			axis: 'y',
    	update: function (event, ui) {
        var data = $(this).sortable('serialize');
				let $div =  $('div#details');
				$.ajax({
				 url: '<?php echo base_url($auth_role.'/loans/index/loadprocessingAction/'.$loan->loan_key);?>' ,
					type: 'get',
					data: data,
					beforeSend: function(){
							KTApp.block($div,{
											overlayColor:"#000000",
											type:"loader",
											state:"success",
											message:"Updating processing information ...."
									});
						},
					 success: function(r){
								var obj = JSON.parse(r);
								if(obj.status == 'ok'){
									 notifySuccess(obj.message);
									$div.load("<?php echo base_url($auth_role.'/loans/index/loadprocessing/'.$loan->loan_key);?>");
									}else{
										notifyWarning(obj.message);
									}
									KTApp.unblock($div);
							 },
						error: function(xhr){
							Swal.fire('',xhr.statusText,'success');
								KTApp.unblock($div);
								}
				});
    }
    });
    $( "#sortable" ).disableSelection();

		$( "#sortableApprove" ).sortable({
			"ui-sortable": "kt-widget4__item",
      placeholder: "ui-state-highlight",
			axis: 'y',
    	update: function (event, ui) {
        var data = $(this).sortable('serialize');
				let $div =  $('div#details');
				$.ajax({
				 url: '<?php echo base_url($auth_role.'/loans/index/approveOrderAction/'.$loan->loan_key);?>' ,
					type: 'get',
					data: data,
					beforeSend: function(){
							KTApp.block($div,{
											overlayColor:"#000000",
											type:"loader",
											state:"success",
											message:"Updating processing information ...."
									});
						},
					 success: function(r){
								var obj = JSON.parse(r);
								if(obj.status == 'ok'){
									 notifySuccess(obj.message);
									$div.load("<?php echo base_url($auth_role.'/loans/index/loadprocessing/'.$loan->loan_key);?>");
									}else{
										notifyWarning(obj.message);
									}
									KTApp.unblock($div);
							 },
						error: function(xhr){
							Swal.fire('',xhr.statusText,'success');
								KTApp.unblock($div);
								}
				});
    }
    });
    $( "#sortableApprove" ).disableSelection();

  } );

	function notifySuccess(message){
		$.notify({
				// options
				message: message,
			},{
				// settings
				element: 'body',
				position: null,
				type: "success",
				allow_dismiss: true,
				newest_on_top: true,
				showProgressbar: false,
				placement: {
					from: "bottom",
					align: "right"
				},
				offset: 20,
				spacing: 10,
				z_index: 1031,
				delay: 500,
				timer: 500,
				url_target: '_blank',
				mouse_over: null,
				animate: {
					enter: 'animated fadeInDown',
					exit: 'animated fadeOutUp'
				},
				onShow: null,
				onShown: null,
				onClose: null,
				onClosed: null,
				icon_type: 'class',
				template: '<div data-notify="container" class="col-xs-11 col-sm-3 alert alert-{0}" role="alert">' +
					'<span data-notify="icon"></span> ' +
					'<span data-notify="title">{1}</span> ' +
					'<span data-notify="message">{2}</span>' +
					'<div class="progress" data-notify="progressbar">' +
						'<div class="progress-bar progress-bar-{0}" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%;"></div>' +
					'</div>' +
				'</div>'
			});
	}

	function notifyWarning(message){
		$.notify({
				// options
				message: message,
			},{
				// settings
				element: 'body',
				position: null,
				type: "warning",
				allow_dismiss: true,
				newest_on_top: true,
				showProgressbar: false,
				placement: {
					from: "bottom",
					align: "right"
				},
				offset: 20,
				spacing: 10,
				z_index: 1031,
				delay: 500,
				timer: 500,
				url_target: '_blank',
				mouse_over: null,
				animate: {
					enter: 'animated fadeInDown',
					exit: 'animated fadeOutUp'
				},
				onShow: null,
				onShown: null,
				onClose: null,
				onClosed: null,
				icon_type: 'class',
				template: '<div data-notify="container" class="col-xs-11 col-sm-3 alert alert-{0}" role="alert">' +
					'<span data-notify="icon"></span> ' +
					'<span data-notify="title">{1}</span> ' +
					'<span data-notify="message">{2}</span>' +
					'<div class="progress" data-notify="progressbar">' +
						'<div class="progress-bar progress-bar-{0}" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%;"></div>' +
					'</div>' +
				'</div>'
			});
	}

</script>
