<script type="text/javascript">

  var LMDatatableCollect = function() {

    var initTable = function() {
      // begin first table
      var table = $('#lm_table_collect').DataTable({
        responsive: true,
        // Pagination settings
        dom: `<'row'<'col-sm-12'tr>>
        <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
        // read more: https://datatables.net/examples/basic_init/dom.html

        lengthMenu: [[10, 25, 50, 100,], [10, 25, 50, 100,]],

        pageLength: 10,

        language: {
          'lengthMenu': 'Display _MENU_',
          buttons: {
              selectAll: "Select all",
              selectNone: "Select none"
          },
          "emptyTable": "No record found",
        },
        searchDelay: 500,
        processing: true,
        serverSide: true,
        select: {
          style: 'mulit+shift',
        },
        "ajax": "<?php echo base_url($auth_role.'/loans/repayments/datasourcecollect');?>",
        dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
        <'row'<'col-sm-12'tr>>
        <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
        buttons: [
            {
                text: 'Collect Seleted',
                action: function ( e, dt, node, config ) {
                    collectSelected(table);
                }
            },
          'selectAll',
          'selectNone',
          'excelHtml5',
          'pdfHtml5',
        ],
        columns: [
          {data: 'number'},
          {data: 'customer'},
          {data: 'duedate'},
          {data: 'principal'},
          {data: 'interest'},
          {data: 'charges'},
          {data: 'amount'},
          {data: 'paid'},
          {data: 'balance'},
          {data: 'status', responsivePriority: -1},
        ],
        columnDefs: [
          {
            targets: 0,
            render: function(data, type, full, meta){
              if (typeof full.number === 'undefined')
                return 'number';
              return full.number;
            }
          },
          {
            targets: 1,
            render: function(data, type, full, meta) {
              if (typeof full.customer === 'undefined')
                return 'Customer';
              return '<a href="<?php echo base_url($auth_role.'/loans/applications/details/');?>' + full.app_key + '">'
              + full.customer +
              '</a>';
            },
          },
          {
            targets: 2,
            render: function(data, type, full, meta) {
              if (typeof full.duedate === 'undefined')
                return 'Due Date';
              return  full.duedate ;
            },
          },
          {
            targets: 3,
            render: function(data, type, full, meta) {
              if (typeof full.principal === 'undefined')
                return 'Principal';
              return  KTUtil.numberString(to_money(full.principal));
            },
          }
          ,
          {
            targets: 4,
            render: function(data, type, full, meta) {
              if (typeof full.interest === 'undefined')
                return 'Interest';
              return  KTUtil.numberString(to_money(full.interest));
            },
          } ,
          {
            targets: 5,
            render: function(data, type, full, meta) {
              if (typeof full.charges === 'undefined')
                return 'Charges';
              return  KTUtil.numberString(to_money(full.charges));
            },
          } ,
          {
            targets: 6,
            render: function(data, type, full, meta) {
              if (typeof full.amount === 'undefined')
                return 'Total';
              return  KTUtil.numberString(to_money(full.amount));
            },
          },
          {
            targets: 7,
            render: function(data, type, full, meta) {
              if (typeof full.paid === 'undefined')
                return 'Paid';
              return  KTUtil.numberString(to_money(full.paid));
            },
          },{
            targets: 8,
            render: function(data, type, full, meta) {
              if (typeof full.balance === 'undefined')
                return 'Balance';
              return  KTUtil.numberString(to_money(full.balance));
            },
          },
          {
            targets: 9,
            render: function(data, type, full, meta) {
              if (typeof full.status === 'undefined')
                return 'Status';
                  var status = {
                    1: {'title': 'Collected', 'class': 'kt-badge--success'},
                    0: {'title': 'Collect', 'class': ' kt-badge--warning'},
                  };
                  if (typeof status[data] === 'undefined') {
                    return 'Status';
                  }
                  return '<a href="javascript:collectPayment('+ full.loan_payment_id + ');"><span class="kt-badge ' + status[data].class + ' kt-badge--inline">' + status[data].title + '</span></a>';
            },
          },
        ],
      });

      var filter = function() {
        var val = $.fn.dataTable.util.escapeRegex($(this).val());
        table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
      };

      var asdasd = function(value, index) {
        var val = $.fn.dataTable.util.escapeRegex(value);
        table.column(index).search(val ? val : '', false, true);
      };

    };

    return {

      //main function to initiate the module
      init: function() {
        initTable();
      },

    };

  }();

  var LMDatatableApprove = function() {


    	$.fn.dataTable.Api.register('column().title()', function() {
    		return $(this.header()).text().trim();
    	});

    	var initTable = function() {
    		// begin first table
    		var table = $('#lm_table_approve').DataTable({

    			responsive: true,
    			// Pagination settings
    			dom: `<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
    			// read more: https://datatables.net/examples/basic_init/dom.html

    			lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],

    			pageLength: 10,

    			language: {
    				'lengthMenu': 'Display _MENU_',
            buttons: {
                selectAll: "Select all",
                selectNone: "Select none"
            },
            "emptyTable": "No record found",
    			},
    			searchDelay: 500,
    			processing: true,
    			serverSide: true,
    			select: {
            style: 'mulit+shift',
          },
          "ajax":"<?php echo base_url($auth_role.'/loans/repayments/datasourceapprove');?>",
    			dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
    			<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
    			buttons: [
            {
              text: 'Approve Seleted',
              action: function ( e, dt, node, config ) {
                  approveSelected( table);
                }
            },
            'selectAll',
            'selectNone',
    				'excelHtml5',
    				'pdfHtml5',
    			],
          columns: [
            {data: 'number'},
            {data: 'customer'},
            {data: 'collected'},
            {data: 'principal'},
            {data: 'interest'},
            {data: 'charges'},
            {data: 'amount'},
            {data: 'paid'},
            {data: 'balance'},
            {data: 'status', responsivePriority: -1},
          ],
    			columnDefs: [
            {
              targets: 0,
              render: function(data, type, full, meta){
                if (typeof full.number === 'undefined')
    							return '#';
                return full.number;
              }
            },
    				{
    					targets: 1,
    					render: function(data, type, full, meta) {
                if (typeof full.customer === 'undefined')
    							return 'Customer';
    						return '<a href="<?php echo base_url($auth_role.'/loans/applications/details/');?>' + full.app_key + '">'
                + full.customer +
                '</a>';
    					},
    				},
            {
    					targets: 2,
    					render: function(data, type, full, meta) {
                if (typeof full.collected === 'undefined')
                  return 'Collected';
    						return  full.collected;
    					},
    				},
            {
    					targets: 3,
    					render: function(data, type, full, meta) {
                if (typeof full.principal === 'undefined')
                  return 'Principal';
    						return  KTUtil.numberString(to_money(full.principal));
    					},
    				},
            {
    					targets: 4,
    					render: function(data, type, full, meta) {
                if (typeof full.interest === 'undefined')
                  return 'Interest';
    						return  KTUtil.numberString(to_money(full.interest));
    					},
    				},
            {
    					targets: 5,
    					render: function(data, type, full, meta) {
                if (typeof full.charges === 'undefined')
                  return 'Charges';
    						return  KTUtil.numberString(to_money(full.charges));
    					},
    				},
            {
              targets: 6,
              render: function(data, type, full, meta) {
                if (typeof full.amount === 'undefined')
                  return 'Total';
                return  KTUtil.numberString(to_money(full.amount));
              },
            },
            {
              targets: 7,
              render: function(data, type, full, meta) {
                if (typeof full.paid === 'undefined')
                  return 'Paid';
                return  KTUtil.numberString(to_money(full.paid));
              },
            },{
              targets: 8,
              render: function(data, type, full, meta) {
                if (typeof full.balance === 'undefined')
                  return 'Balance';
                return  KTUtil.numberString(to_money(full.balance));
              },
            },
            {
              targets: 9,
              render: function(data, type, full, meta) {
                if (typeof full.status === 'undefined')
                  return 'Status';
                    var status = {
                      1: {'title': 'Approve', 'class': 'kt-badge--warning'},
                      0: {'title': 'Approved', 'class': ' kt-badge--success'},
                    };
                    if (typeof status[data] === 'undefined') {
                      return 'Status';
                    }
                    return '<a href="javascript:approvePayment('+ full.loan_payment_id + ');"><span class="kt-badge ' + status[data].class + ' kt-badge--inline">' + status[data].title + '</span></a>';
              },
            },
    			],
    		});

    		var filter = function() {
    			var val = $.fn.dataTable.util.escapeRegex($(this).val());
    			table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
    		};

    		var asdasd = function(value, index) {
    			var val = $.fn.dataTable.util.escapeRegex(value);
    			table.column(index).search(val ? val : '', false, true);
    		};
    	};

    	return {
    		//main function to initiate the module
    		init: function() {
    			initTable();
    		},

    	};

    }();

  jQuery(document).ready(function() {
  	LMDatatableCollect.init();
    LMDatatableApprove.init();
  });

  function ucfirst(string){
    return string.charAt(0).toUpperCase() + string.slice(1);
  }

  function approvePayment(app){
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this!",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#d33',
      cancelButtonColor: '#3085d6',
      confirmButtonText: 'Yes, Confirm it!'
    }).then((result) => {
      if (result.value) {
        $.ajax({
            url: '<?php echo base_url($auth_role.'/loans/repayments/approveaction')?>/' + app,
            type: 'get',
            beforeSend: function(){
              KTApp.blockPage({
                      overlayColor:"#000000",
                      type:"loader",
                      state:"danger",
                      message:"Please wait while, We are collecting payments ..."
                  });
              },
            success: function(result){
                 let obj = JSON.parse(result);
                     if( obj.status == 'ok'){
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();
                      }else{
                        notifyWarning(obj.message);
                      }
                 KTApp.unblockPage();
                 },
            error: function(xhr){
                KTApp.unblockPage();
                Swal.fire('',xhr.statusText,'warning');
              }
        });
      }
    })
  }

  function approveSelected(table){
    if(table.rows('.selected').data().length<1)
    return;
    var data= [];
   $.each(table.rows('.selected').data(), function() {
     data.push(this["loan_payment_id"]);
   });
    Swal.fire({
      title: 'Are you sure?',
      text: "You are going to Approve payments for " + table.rows('.selected').data().length + " selected rows",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, Approve them!'
    }).then((result) => {
      if (result.value) {
        $.ajax({
            url: '<?php echo base_url($auth_role.'/loans/repayments/approveall/');?>',
            type: 'get',
            data: {'data':data},
            beforeSend: function(){
                KTApp.blockPage({
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Please wait while, We are approving payments ..."
                    });
              },
             success: function(result){
                   let obj = JSON.parse(result);
                     if( obj.status == 'ok'){
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();
                      }else{
                        notifyWarning(obj.message)
                      }
                   KTApp.unblockPage();
                 },
             error: function(xhr){
                KTApp.unblockPage();
                Swal.fire('',xhr.statusText,'warning');
                }
        });
      }
    })
  }

  function collectSelected(table){
     if(table.rows('.selected').data().length<1)
     return;
     var data= [];
    $.each(table.rows('.selected').data(), function() {
      data.push(this["loan_payment_id"] + '-' + this["amount"]);
    });
     Swal.fire({
       title: 'Are you sure?',
       text: "You are going to collect payments for " + table.rows('.selected').data().length + " selected rows",
       type: 'warning',
       showCancelButton: true,
       confirmButtonColor: '#3085d6',
       cancelButtonColor: '#d33',
       confirmButtonText: 'Yes, Collect them!'
     }).then((result) => {
       if (result.value) {
         $.ajax({
             url: '<?php echo base_url($auth_role.'/loans/repayments/collectall/');?>',
             type: 'get',
             data: {'data':data},
             beforeSend: function(){
                 KTApp.blockPage({
                         overlayColor:"#000000",
                         type:"loader",
                         state:"danger",
                         message:"Please wait while, We are collecting payments ..."
                     });
               },
              success: function(result){
                    let obj = JSON.parse(result);
                      if( obj.status == 'ok'){
                         notifySuccess(obj.message);
                         var table = $.fn.dataTable.tables( { api: true } );
                         table.clear().draw();
                       }else{
                         notifyWarning(obj.message)
                       }
                    KTApp.unblockPage();
                  },
              error: function(xhr){
                 KTApp.unblockPage();
                 Swal.fire('',xhr.statusText,'warning');
                 }
         });
       }
     })
   }

  function collectPayment(id,app){
     Swal.fire({
       title: 'Please Fill in Ammount to Collect',
       input: 'text',
       inputClass: 'number swal2-input',
       inputAttributes: {
         autocapitalize: 'off',
         class: 'number form-control',
         value: app,
         placeholder:'Enter amount to collect',
         require: 'required',
       },
       showCancelButton: true,
       confirmButtonText: 'Collect',
       showLoaderOnConfirm: true,
       preConfirm: (amount) => {
         return fetch(`<?php echo base_url($auth_role.'/loans/repayments/collectajax/');?>`+ id + `/` + amount  )
           .then(response => {
             if (!response.ok) {
               throw new Error(response.statusText)
             }
             return response.json()
           })
           .catch(error => {
             Swal.showValidationMessage(
               `Request failed: ${error}`
             )
           })
       },
       allowOutsideClick: () => !Swal.isLoading()
     }).then((result) => {
       if (result.value) {
         if(result.value.status == 'ok'){
             notifySuccess(result.value.message);
             let table = $.fn.dataTable.tables( { api: true } );
             table.clear().draw();
         }
       }
     })
   }
</script>
