<!-- begin::Body -->
<?php include VIEWPATH.'/'.$auth_role.'/includes/header.styles.php';?>
  <!-- begin:: Page -->
<div class="kt-grid kt-grid--hor kt-grid--root">
  <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--ver kt-page">
  <!-- begin:: Aside -->
  <?php include VIEWPATH.'/'.$auth_role.'/menus/left.php';?>
    <!-- end:: Aside -->
    <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor kt-wrapper" id="kt_wrapper">
      <!-- begin:: Header -->
    <?php include VIEWPATH.'/'.$auth_role.'/menus/top.php';?>
      <!-- end:: Header -->
      <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
      <?php topToolBarLoans();?>
          <!-- begin:: Content -->
          <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
            <div class="kt-portlet">
              <div class="kt-portlet__body  kt-portlet__body--fit">
                <div class="row row-no-padding row-col-separator-xl">
                  <div class="col-md-3">
                    <div class="kt-section" style="margin:0px; height:100%;">
                      <div class="kt-section__content kt-section__content--solid" style="margin:0px; height:100%;">
                        <h5 class="kt-padding-20">Loan Reports</h5>
                        <ul class="kt-nav">
                          <li class="kt-nav__section kt-nav__section--first">
                            <span class="kt-nav__section-text">Principal</span>
                          </li>
                          <li class="kt-nav__item">
                            <a href="javascript:(0);" onclick="loadprincipal('collected')" class="kt-nav__link">
                              <i class="kt-nav__link-icon flaticon-folder-1"></i>
                              <span class="kt-nav__link-text">Principal Collected</span>
                            </a>
                          </li>
                          <li class="kt-nav__item">
                            <a href="javacript:(0);" onclick="loadprincipal('outstanding')" class="kt-nav__link">
                              <i class="kt-nav__link-icon flaticon-folder-1"></i>
                              <span class="kt-nav__link-text">Principal Outstanding</span>
                            </a>
                          </li>
                          <li class="kt-nav__item">
                            <a href="javacript:(0);" onclick="loadprincipal('overdue')" class="kt-nav__link">
                              <i class="kt-nav__link-icon flaticon-folder-1"></i>
                              <span class="kt-nav__link-text">Principal Overdue</span>
                            </a>
                          </li>
                          <li class="kt-nav__section">
                            <span class="kt-nav__section-text">Interest</span>
                          </li>
                          <li class="kt-nav__item">
                            <a href="javacript:(0);" onclick="loadinfo('penalties')" class="kt-nav__link">
                              <i class="kt-nav__link-icon flaticon-lifebuoy"></i>
                              <span class="kt-nav__link-text">Penalty Settings</span>
                            </a>
                          </li>
                          <li class="kt-nav__item">
                            <a href="javacript:(0);" onclick="loadinfo('charges')" class="kt-nav__link">
                              <i class="kt-nav__link-icon flaticon-cogwheel-2"></i>
                              <span class="kt-nav__link-text">Charges Settings</span>
                            </a>
                          </li>
                          <li class="kt-nav__section">
                            <span class="kt-nav__section-text">Repayments</span>
                          </li>
                          <li class="kt-nav__item">
                            <a href="javacript:(0);" onclick="loadinfo('processing')" class="kt-nav__link">
                              <i class="kt-nav__link-icon flaticon-interface-1"></i>
                              <span class="kt-nav__link-text">Processing Order</span>
                            </a>
                          </li>
                        </ul>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-9">

                    <!--begin::New Feedbacks-->
                    <div class="kt-widget24 kt-padding-b-0">
                      <div class="kt-widget24__details">
                        <div class="kt-widget24__info">
                          <h4 class="kt-widget24__title">
                            Loan Reports <small id="info"></small>
                          </h4>
                        </div>
                      </div>
                    </div>
                    <hr>
                    <div id="details" class="kt-padding-25">
                      <table id="lm_table">

                      </table>
                    </div>
                    <!--end::New Feedbacks-->
                  </div>
                </div>
              </div>
            </div>
          </div>
      </div>
        </div>
        <?php bottom();?>
        <!-- end:: Footer -->
      </div>
    </div>
  </div>

  <?php
    include VIEWPATH.'/'.$auth_role.'/menus/right.php';
    include VIEWPATH.'/'.$auth_role.'/includes/footer.php';
    include VIEWPATH.'/'.$auth_role.'/includes/footer.scripts.php';
  ?>

  <script>

  function loadprincipal(info){

    let url = '<?php echo base_url($auth_role.'/loans/reports/principal/');?>' + info;

    principalData();
    if(info == 'collected'){
      principalcollected(url,info);
    }

    if(info == 'outstanding'){
      principalcollected(url,info);
    }

    if(info == 'overdue'){
      principalcollected(url,info);
    }

  }

  function principalData(){

    $.fn.dataTable.pipeline = function ( opts ) {
        // Configuration options
        var conf = $.extend( {
            pages: 5,     // number of pages to cache
            url: '',      // script url
            data: null,   // function or object with parameters to send to the server
                          // matching how `ajax.data` works in DataTables
            method: 'GET' // Ajax HTTP method
        }, opts );

        // Private variables for storing the cache
        var cacheLower = -1;
        var cacheUpper = null;
        var cacheLastRequest = null;
        var cacheLastJson = null;

        return function ( request, drawCallback, settings ) {
            var ajax          = false;
            var requestStart  = request.start;
            var drawStart     = request.start;
            var requestLength = request.length;
            var requestEnd    = requestStart + requestLength;

            if ( settings.clearCache ) {
                // API requested that the cache be cleared
                ajax = true;
                settings.clearCache = false;
            }
            else if ( cacheLower < 0 || requestStart < cacheLower || requestEnd > cacheUpper ) {
                // outside cached data - need to make a request
                ajax = true;
            }
            else if ( JSON.stringify( request.order )   !== JSON.stringify( cacheLastRequest.order ) ||
                      JSON.stringify( request.columns ) !== JSON.stringify( cacheLastRequest.columns ) ||
                      JSON.stringify( request.search )  !== JSON.stringify( cacheLastRequest.search )
            ) {
                // properties changed (ordering, columns, searching)
                ajax = true;
            }

            // Store the request for checking next time around
            cacheLastRequest = $.extend( true, {}, request );

            if ( ajax ) {
                // Need data from the server
                if ( requestStart < cacheLower ) {
                    requestStart = requestStart - (requestLength*(conf.pages-1));

                    if ( requestStart < 0 ) {
                        requestStart = 0;
                    }
                }

                cacheLower = requestStart;
                cacheUpper = requestStart + (requestLength * conf.pages);

                request.start = requestStart;
                request.length = requestLength*conf.pages;

                // Provide the same `data` options as DataTables.
                if ( typeof conf.data === 'function' ) {
                    // As a function it is executed with the data object as an arg
                    // for manipulation. If an object is returned, it is used as the
                    // data object to submit
                    var d = conf.data( request );
                    if ( d ) {
                        $.extend( request, d );
                    }
                }
                else if ( $.isPlainObject( conf.data ) ) {
                    // As an object, the data given extends the default
                    $.extend( request, conf.data );
                }

                settings.jqXHR = $.ajax( {
                    "type":     conf.method,
                    "url":      conf.url,
                    "data":     request,
                  //  "dataType": "json",
                    "cache":    false,
                    "success":  function ( json ) {
                        cacheLastJson = $.extend(true, {}, json);

                        if ( cacheLower != drawStart ) {
                            json.aaData.splice( 0, drawStart-cacheLower );
                        }
                        if ( requestLength >= -1 ) {
                            json.aaData.splice( requestLength, json.aaData.length );
                        }

                        drawCallback( json );
                    }
                } );
            }
            else {
                json = $.extend( true, {}, cacheLastJson );
                json.draw = request.draw; // Update the echo for each response
                json.aaData.splice( 0, requestStart-cacheLower );
                json.aaData.splice( requestLength, json.aaData.length );

                drawCallback(json);
            }
        }
    };

    $.fn.dataTable.Api.register( 'clearPipeline()', function () {
        return this.iterator( 'table', function ( settings ) {
            settings.clearCache = true;
        } );
    } );

  }

  function principalcollected(url,info){
    let $div =  $('div#details');
    $div.html('');
    $('small#info').html(' | Principal ' + info);
    addElement('details','table','lm_table','table table-bordered table-info');
    var table = document.getElementById("lm_table");
    var header = table.createTHead();
    var row = header.insertRow(0);
    row.insertCell(0).innerHTML = "Loan #";
    row.insertCell(1).innerHTML = "Customer #";
    row.insertCell(2).innerHTML = "Customer";
    row.insertCell(3).innerHTML = "Principal";
    row.insertCell(4).innerHTML = "Due";
    row.insertCell(5).innerHTML = "Paid";
    row.insertCell(6).innerHTML = "Balance";
    let collected  = {
      responsive: true,
      // Pagination settings
      dom: `<'row'<'col-sm-12'tr>>
      <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,

      lengthMenu: [[10, 25, 50, 100,], [10, 25, 50, 100,]],

      pageLength: 10,

      language: {
        'lengthMenu': 'Display _MENU_',
      },
      searchDelay: 500,
      processing: true,
      serverSide: true,
      "ajax": $.fn.dataTable.pipeline( {
            url: url,
            type: 'POST',
            pages: 5 // number of pages to cache
        } ),
      dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
      <'row'<'col-sm-12'tr>>
      <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
      buttons: [
        'excelHtml5',
        'pdfHtml5',
      ],
      columns: [
        {data: 'app_id'},
        {data: 'customer_number'},
        {data: 'customer #'},
        {data: 'principal'},
        {data: 'due'},
        {data: 'paid'},
        {data: 'balance'},
      ],
      columnDefs: [
        {
          targets: 0,
          render: function(data, type, full, meta){
            if (typeof full.app_id === 'undefined')
              return 'Loan #';
            return full.app_id;
          }
        },
        {
          targets: 1,
          render: function(data, type, full, meta){
            if (typeof full.customer_number === 'undefined')
              return 'Cutomer #';
            return full.customer_number;
          }
        },
        {
          targets: 2,
          render: function(data, type, full, meta) {
            if (typeof full.customer === 'undefined')
              return 'Customer';
            return full.customer;
          },
        },
        {
          targets: 3,
          render: function(data, type, full, meta) {
            if (typeof full.principal === 'undefined')
              return 'Principal';
            return  KTUtil.numberString(to_money(full.principal));
          },
        }
        ,
        {
          targets: 4,
          render: function(data, type, full, meta) {
            if (typeof full.principal === 'undefined')
              return 'Due';
            return  KTUtil.numberString(to_money(full.due));
          },
        } ,
        {
          targets: 5,
          render: function(data, type, full, meta) {
            if (typeof full.paid === 'undefined')
              return 'Paid';
            return  KTUtil.numberString(to_money(full.paid));
          },
        } ,
        {
          targets: 6,
          render: function(data, type, full, meta) {
            if (typeof full.principal === 'undefined')
              return 'Balance';
            return  KTUtil.numberString(to_money(full.due - full.paid));
          },
        },
      ],
    }
    var table = $('#lm_table');
    table.DataTable().destroy();
    table.DataTable(collected);
}

</script>

</body>
<!-- end::Body -->
</html>
