<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<form class="kt-form" id="modifytaxForm" action="#" onsubmit="return false;">
  <div class="form-group row">
    <div class="col-12">
      <input required type="text" value="<?php echo number_format(to_money($paye->paye_start));?>" maxlength="30" name="paye_start" class="form-control number" placeholder="PAYE Start">
    </div>
  </div>
  <div class="form-group row">
    <div class="col-12">
      <input required type="text" value="<?php echo number_format(to_money($paye->paye_end));?>" maxlength="30" name="paye_end" class="form-control number" placeholder="PAYE End">
    </div>
  </div>
  <div class="form-group row">
    <div class="col-12">
      <input required type="text" value="<?php echo $paye->paye_percent;?>"  maxlength="30" name="paye_percent" class="form-control" placeholder="PAYE Percent">
    </div>
  </div>
  <div class="form-group row">
    <label class="col-8 col-form-label"></label>
    <div class="col-4">
      <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b> UPDATE PAYE</b></button>
    </div>
  </div>
  </form>
<script type="text/javascript">
(function($, undefined) {
    "use strict";
    // When ready.
    $(function() {
      var $input = $( "input.number" );
      $input.on( "keyup", function( event ) {
          // When user select text in the document, also abort.
          var selection = window.getSelection().toString();
          if ( selection !== '' ) {
              return;
          }
          // When the arrow keys are pressed, abort.
          if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
              return;
          }
          var $this = $( this );
          // Get the value.
          var input = $this.val();
          var input = input.replace(/[\D\s\._\-]+/g, "");
          input = input ? parseInt( input, 10 ) : 0;
          $this.val( function() {
              return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
          } );
      });
    });
})(jQuery);

$('form#modifytaxForm').submit( function(event){
  let form = $( this );
  event.preventDefault();
  let formdata = form.serialize();
  $.ajax({
   url: '<?php echo base_url('admin/payrolls/paye/updatepaye/'.$paye->paye_key);?>' ,
    type: 'get',
    data: formdata,
    beforeSend: function(){
        KTApp.block(form,{
                overlayColor:"#000000",
                type:"loader",
                state:"success",
                message:"Updating PAYE ...."
            });
      },
     success: function(r){
          var obj = JSON.parse(r);
          if(obj.status == 'ok'){
            $('.kt-datatable').KTDatatable('reload');
            $('div#payeDetails').modal('hide');
            Swal.fire('',obj.message,'success');
            }else{
                Swal.fire('',obj.message,'warning');
            }
            KTApp.unblock(form);
         },
      error: function(){
          $('div#payeDetails').modal('hide');
          KTApp.unblock(form);
          }
  });
})



</script>
