<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<form class="kt-form" id="modifytaxForm" action="#" onsubmit="return false;">
  <div class="form-group row">
    <div class="col-12">
      <input required value="<?php echo $tax->payroll_tax_name;?>" type="text" maxlength="30" name="payroll_tax_name" class="form-control" placeholder="Tax name">
    </div>
  </div>
  <div class="form-group row">
    <div class="col-12">
      <select required class="form-control" name="payroll_tax_group">
      <?php if(!empty($classes)){
        foreach ($classes as $key => $value) {?>
          <option value=""></option>
          <option <?php if($tax->payroll_tax_group == $value['tax_group_key']) echo 'selected';?> value="<?php echo $value['tax_group_key'];?>"><?php echo $value['tax_group_name'];?></option>
        <?php }
      } ?>
      </select>
    </div>
  </div>
  <div class="form-group row">
    <div class="col-12">
      <input required type="text" value="<?php echo $tax->payroll_tax_percent;?>" maxlength="30" name="payroll_tax_percent" class="form-control" placeholder="Tax percent">
    </div>
  </div>
  <div class="form-group row">
    <div class="col-12">
      <textarea class="form-control" name="payroll_tax_details" rows="3" cols="80" placeholder="Tax details"><?php echo $tax->payroll_tax_details;?></textarea>
    </div>
  </div>
  <div class="form-group row">
    <label class="col-9 col-form-label"></label>
    <div class="col-3">
      <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Register</b></button>
    </div>
  </div>
  </form>
<script type="text/javascript">


$('form#modifytaxForm').submit( function(event){
  let form = $( this );
  event.preventDefault();
  let formdata = form.serialize();
  $.ajax({
   url: '<?php echo base_url('admin/payrolls/taxes/updatetax/'.$tax->payroll_tax_key);?>' ,
    type: 'post',
    data: formdata,
    beforeSend: function(){
        KTApp.block(form,{
                overlayColor:"#000000",
                type:"loader",
                state:"success",
                message:"Updating Payroll Tax ...."
            });
      },
     success: function(r){
          var obj = JSON.parse(r);
          if(obj.status == 'ok'){
            $('.kt-datatable').KTDatatable('reload');
            $('div#taxDetails').modal('hide');
            Swal.fire('',obj.message,'success');
            }else{
                Swal.fire('',obj.message,'warning');
            }
            KTApp.unblock(form);
         },
      error: function(){
          $('div#taxDetails').modal('hide');
          KTApp.unblock(form);
          }
  });
})
</script>
