<!-- begin::Body -->
<?php include VIEWPATH.'/admin/includes/header.styles.php';?>
  <!-- begin:: Page -->
<div class="kt-grid kt-grid--hor kt-grid--root">
  <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--ver kt-page">
  <!-- begin:: Aside -->
  <?php include VIEWPATH.'/admin/menus/left.php';?>
    <!-- end:: Aside -->
    <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor kt-wrapper" id="kt_wrapper">
      <!-- begin:: Header -->
    <?php include VIEWPATH.'/admin/menus/top.php';?>
      <!-- end:: Header -->
      <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
      <?php topToolBarPayrolls('variables');?>
          <!-- begin:: Content -->
          <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
            <div class="row">
                <div class="col-lg-12">
                  <!--begin::Portlet-->
                  <div class="kt-portlet kt-portlet--last kt-portlet--head-md kt-portlet--responsive-mobile" id="kt_page_portlet">
                    <div class="kt-portlet__head kt-portlet__head--md" style="">
                      <div class="kt-portlet__head-label">
                        <h3 class="kt-portlet__head-title">Variables</h3>
                      </div>
                      <div class="kt-portlet__head-toolbar">
                        <a href="#newVariable" data-toggle="modal" class="btn btn-label-brand kt-margin-r-10">
                          <span class="kt-hidden-mobile">New Variable</span>
                        </a>
                        <div class="btn-group">
                          <button type="button" class="btn btn-label-brand">
                            <i class="la la-navicon"></i>
                            <span class="kt-hidden-mobile">Options</span>
                          </button>
                          <button type="button" class="btn btn-label-brand dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          </button>
                          <div class="dropdown-menu dropdown-menu-right">
                            <ul class="kt-nav">
                              <li class="kt-nav__item">
                                <a href="#" class="kt-nav__link">
                                  <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                        <rect id="bound" x="0" y="0" width="24" height="24"/>
                                        <path d="M6,8 L6,20.5 C6,21.3284271 6.67157288,22 7.5,22 L16.5,22 C17.3284271,22 18,21.3284271 18,20.5 L18,8 L6,8 Z" id="round" fill="#000000" fill-rule="nonzero"/>
                                        <path d="M14,4.5 L14,4 C14,3.44771525 13.5522847,3 13,3 L11,3 C10.4477153,3 10,3.44771525 10,4 L10,4.5 L5.5,4.5 C5.22385763,4.5 5,4.72385763 5,5 L5,5.5 C5,5.77614237 5.22385763,6 5.5,6 L18.5,6 C18.7761424,6 19,5.77614237 19,5.5 L19,5 C19,4.72385763 18.7761424,4.5 18.5,4.5 L14,4.5 Z" id="Shape" fill="#000000" opacity="0.3"/>
                                    </g>
                                  </svg>
                                  <span class="kt-nav__link-text"> &nbsp Delete all</span>
                                </a>
                              </li>
                            </ul>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="kt-portlet__body kt-portlet__body--fit">
                        <div class="kt-datatable" id="variables"></div>
                    </div>
                  </div>

                  <!--end::Portlet-->
                </div>
              </div>
          </div>

          <!-- end:: Content -->
        </div>

        <!-- begin:: Footer -->
        <?php bottom();?>
        <!-- end:: Footer -->
      </div>
    </div>
  </div>
  <div class="modal fade" id="variableDetails" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content" style="border:0px;">
          <div class="modal-header bg-dark">
            <h5 class="modal-title text-white" id="exampleModalLongTitle">Expense Details</h5>
            <a id="print" href="javascript:(0);" class=" modal-title text-white" style="right:60px; position:absolute;">
              <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                  <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                      <rect id="bound" x="0" y="0" width="24" height="24"/>
                      <path d="M16,17 L16,21 C16,21.5522847 15.5522847,22 15,22 L9,22 C8.44771525,22 8,21.5522847 8,21 L8,17 L5,17 C3.8954305,17 3,16.1045695 3,15 L3,8 C3,6.8954305 3.8954305,6 5,6 L19,6 C20.1045695,6 21,6.8954305 21,8 L21,15 C21,16.1045695 20.1045695,17 19,17 L16,17 Z M17.5,11 C18.3284271,11 19,10.3284271 19,9.5 C19,8.67157288 18.3284271,8 17.5,8 C16.6715729,8 16,8.67157288 16,9.5 C16,10.3284271 16.6715729,11 17.5,11 Z M10,14 L10,20 L14,20 L14,14 L10,14 Z" id="Combined-Shape" fill="#000000"/>
                      <rect id="Combined-Shape-Copy" fill="#000000" opacity="0.3" x="8" y="2" width="8" height="2" rx="1"/>
                  </g>
              </svg>
            </a>
            <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
              <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                  <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                      <rect id="bound" x="0" y="0" width="24" height="24"/>
                      <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                      <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                  </g>
              </svg></a>
          </div>
          <div class="modal-body text-back" id="printArea">

          </div>
          <div class="modal-footer bg-dark">
          <small> &copy <?php echo date('Y') ;?> Lockminds BMS | Payroll Variable details</small>
          </div>
        </div>
      </div>
    </div>
  </div>

    <div class="modal fade" id="newVariable" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterVariable" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-md" role="document">
          <div class="modal-content" style="border:0px;">
            <div class="modal-header bg-dark">
              <h5 class="modal-title text-white" id="exampleModalLongVariable">New Variable</h5>
              <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <rect id="bound" x="0" y="0" width="24" height="24"/>
                        <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                        <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                    </g>
                </svg></a>
            </div>
            <div class="modal-body text-back">
                <form id="newVariableForm" class="kt-form" action="#" method="get" onsubmit="return false">
                  <div class="form-group row">
                    <div class="col-12">
                      <input required type="text" maxlength="30" name="variable_name" class="form-control" placeholder="Variable name">
                    </div>
                  </div>
                  <div class="form-group row">
                    <div class="col-12">
                      <select required class="form-control" name="variable_type">
                        <option value="pay">Pay</option>
                        <option value="deduct">Deduct</option>
                      </select>
                    </div>
                  </div>
                  <div class="form-group row">
                    <div class="col-12">
                      <input required type="text" maxlength="30" name="variable_amount" class="form-control" placeholder="Variable amount">
                    </div>
                  </div>
                  <div class="form-group row">
                    <div class="col-12">
                      <textarea class="form-control" name="variable_details" rows="3" cols="80" placeholder="Variable details"></textarea>
                    </div>
                  </div>
                  <div class="form-group row">
                    <label class="col-9 col-form-label"></label>
                    <div class="col-3">
                      <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Register</b></button>
                    </div>
                  </div>
                </form>
            </div>
            <div class="modal-footer bg-dark">
            <small> &copy <?php echo date('Y') ;?> Lockminds BMS | Register new Variable</small>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!--end::Global App Bundle -->

  <!-- begin::Quick Panel -->
  <?php include VIEWPATH.'/admin/menus/right.php';
    include VIEWPATH.'/admin/includes/footer.php';
    include VIEWPATH.'/admin/includes/footer.scripts.php';
  ?>

  <script>

  "use strict";
  // Class definition

  var KTDefaultDatatableDemo = function() {
  	// Private functions

  	// basic demo
  	var demo = function() {

  		var options = {
  			// datasource definition
  			data: {
  				type: 'remote',
  				source: {
  					read: {
  						url: '<?php echo base_url('admin/payrolls/variables/datasource');?>',
  					},
  				},
  				pageSize: 10, // display 20 records per page
  				serverPaging: true,
  				serverFiltering: true,
  				serverSorting: true,
  			},

  			// layout definition
  			layout: {
  				scroll: false, // enable/disable datatable scroll both horizontal and vertical when needed.
  				//height: 400, // datatable's body's fixed height
  				footer: false, // display/hide footer
  			},

  			// column sorting
  			sortable: true,

  			pagination: true,

  			search: {
  				input: $('#generalSearch'),
  			},

  			// columns definition
  			columns: [
  				{
  					field: 'id',
  					title: '#',
  					sortable: false,
  					width: 30,
  					type: 'number',
  					selector: {class: 'kt-checkbox--solid'},
  					textAlign: 'center',
  					locked: {left: 'lg'},
  				}, {
  					field: 'variable_name',
  					title: 'Variable',
  					locked: {left: 'lg'},
  				},
          {
  					field: 'variable_type',
  					title: 'Variable Type',
  				},
          {
  					field: 'variable_amount',
  					title: 'Variable Amount',
            template: function(row) {
      						return to_money(row.variable_amount).toLocaleString('TZ');
      					},
  				},
          {
  					field: 'variable_actions',
  					title: 'Actions',
  					sortable: false,
  					width: 80,
  					overflow: 'visible',
  					autoHide: false,
            locked: {right: 'lg'}
  				}],

  		};

  		var datatable = $('.kt-datatable').KTDatatable(options);

  	};

  	return {
  		// public functions
  		init: function() {
  			demo();
  		},
  	};
  }();

  jQuery(document).ready(function() {
  	KTDefaultDatatableDemo.init();
    $('form#newVariableForm').submit( function(event){
      let form = $( this );
      event.preventDefault();
      let formdata = form.serialize();
      $.ajax({
       url: '<?php echo base_url('admin/payrolls/variables/newvariable/')?>',
        type: 'get',
        data: formdata,
        beforeSend: function(){
            KTApp.block("form#newVariableForm",{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Creating new Variable ..."
                });
          },
         success: function(r){
              var obj = JSON.parse(r);
              if(obj.status == 'ok'){
                $('.kt-datatable').KTDatatable('reload');
                Swal.fire('',obj.message,'success');
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock('form#newVariableForm');
                $('div#newVariable').modal('hide');
             },
          error: function(){
              KTApp.unblock('form#newVariableForm');
              $('div#newVariable').modal('hide');
              }
      });
    })
  });

  function deletevariable(variable){
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this!",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
      if (result.value) {
        $.ajax({
            url: '<?php echo base_url('admin/payrolls/variables/delete/variable')?>/'+variable,
            type: 'get',
            beforeSend: function(){
                KTApp.block(".kt-datatable",{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Deleting Variable ..."
                    });
              },
             success: function(result){
                 let obj = JSON.parse(result);
                     if( obj.status == 'ok'){
                        Swal.fire('',obj.message,'success');
                        $('.kt-datatable').KTDatatable('reload');
                      }else{
                        Swal.fire('',obj.message,'warning');
                      }
                 KTApp.unblock('.kt-datatable');  KTApp.unblock('.kt-datatable');
                 },
              error: function(xhr){
                  KTApp.unblock('.kt-datatable');
                  Swal.fire('',xhr.statusText,'warning');
                  }
        });
      }
    })
  }

  function variableDetails(variable){
    let $modal =  $('div#variableDetails');
    let $div = $modal.find('.modal-body');
    $div.html('');
    $modal.modal('show');
    $.ajax({
      url: '<?php echo base_url('admin/payrolls/variables/variableDetails/');?>' + variable,
      type: 'get',
      beforeSend: function(){
      KTApp.block($div,{
              overlayColor:"#000000",
              type:"loader",
              state:"success",
              message:"Loading variable details ...."
          });
      },
      success: function (result){
        $div.html(result);
        KTApp.unblock($div);
      },
      error: function (xhr){
        $modal.modal('hide');
        KTApp.unblock($div);
        Swal.fire('',xhr.statusText,'warning');
      }
    })
  }

  function modifyvariable(variable){
    let $modal =  $('div#variableDetails');
    let $div = $modal.find('.modal-body');
    $div.html('');
    $modal.modal('show');
    $.ajax({
      url: '<?php echo base_url('admin/payrolls/variables/variableModify/');?>' + variable,
      type: 'get',
      beforeSend: function(){
      KTApp.block($div,{
              overlayColor:"#000000",
              type:"loader",
              state:"success",
              message:"Loading variable details ...."
          });
      },
      success: function (result){
        $div.html(result);
        KTApp.unblock($div);
      },
      error: function (xhr){
        $modal.modal('hide');
        KTApp.unblock($div);
        Swal.fire('',xhr.statusText,'warning');
      }
    })
  }

  function to_money(money){
    let unit = '<?php echo 1 * runnCurrency()->currency_convention;?>';
    let result = money * unit;
    return result.toLocaleString('TZS');
  }

  document.querySelector("#print").addEventListener("click", function() {
  	printJS({ printable: 'printArea', type: 'html', header: '<?php echo config_item('application_name');?> - Variable Details',css:'<?php echo base_url('resources')?>/assets/demo/default/base/style.bundle.css','style':'link{text-decoration:none;}'});
  });
  </script>
</body>
</html>
