<!-- begin::Body -->
<?php include VIEWPATH.'/'.$auth_role.'/includes/header.styles.php';?>
  <!-- begin:: Page -->
<div class="kt-grid kt-grid--hor kt-grid--root">
  <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--ver kt-page">
  <!-- begin:: Aside -->
  <?php include VIEWPATH.'/'.$auth_role.'/menus/left.php';?>
    <!-- end:: Aside -->
    <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor kt-wrapper" id="kt_wrapper">
      <!-- begin:: Header -->
    <?php include VIEWPATH.'/'.$auth_role.'/menus/top.php';?>
      <!-- end:: Header -->
      <div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
      <?php topToolBarSavingProducts('products');?>
          <!-- begin:: Content -->
          <div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
            <div class="row">
                <div class="col-lg-12">
                  <!--begin::Portlet-->
                  <div class="kt-portlet kt-portlet--last kt-portlet--head-md kt-portlet--responsive-mobile" id="kt_page_portlet">
                    <div class="kt-portlet__head kt-portlet__head--md" style="">
                      <div class="kt-portlet__head-label">
                        <h3 class="kt-portlet__head-title">Product</h3>
                      </div>
                      <div class="kt-portlet__head-toolbar">
                        <a href="#newProduct" data-toggle="modal" class="btn btn-label-brand kt-margin-r-10">
                          <span class="kt-hidden-mobile">New Product</span>
                        </a>
                        <div class="btn-group">
                          <button type="button" class="btn btn-label-brand">
                            <i class="la la-navicon"></i>
                            <span class="kt-hidden-mobile">Options</span>
                          </button>
                          <button type="button" class="btn btn-label-brand dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          </button>
                          <div class="dropdown-menu dropdown-menu-right">
                            <ul class="kt-nav">
                              <li class="kt-nav__item">
                                <a href="#" class="kt-nav__link">
                                  <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                        <rect id="bound" x="0" y="0" width="24" height="24"/>
                                        <path d="M6,8 L6,20.5 C6,21.3284271 6.67157288,22 7.5,22 L16.5,22 C17.3284271,22 18,21.3284271 18,20.5 L18,8 L6,8 Z" id="round" fill="#000000" fill-rule="nonzero"/>
                                        <path d="M14,4.5 L14,4 C14,3.44771525 13.5522847,3 13,3 L11,3 C10.4477153,3 10,3.44771525 10,4 L10,4.5 L5.5,4.5 C5.22385763,4.5 5,4.72385763 5,5 L5,5.5 C5,5.77614237 5.22385763,6 5.5,6 L18.5,6 C18.7761424,6 19,5.77614237 19,5.5 L19,5 C19,4.72385763 18.7761424,4.5 18.5,4.5 L14,4.5 Z" id="Shape" fill="#000000" opacity="0.3"/>
                                    </g>
                                  </svg>
                                  <span class="kt-nav__link-text"> &nbsp Delete all</span>
                                </a>
                              </li>
                            </ul>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="kt-portlet__body kt-portlet__body--fit">
                        <div class="kt-datatable" id="products"></div>
                    </div>
                  </div>

                  <!--end::Portlet-->
                </div>
              </div>
          </div>


          <!-- end:: Content -->
        </div>

        <!-- begin:: Footer -->
        <?php bottom();?>
        <!-- end:: Footer -->
      </div>
    </div>
  </div>

  <!-- end:: Page -->

  <!-- begin::Quick Panel -->
  <?php include VIEWPATH.'/'.$auth_role.'/menus/right.php';
    include VIEWPATH.'/'.$auth_role.'/includes/footer.php';
    include VIEWPATH.'/'.$auth_role.'/includes/footer.scripts.php';
    include VIEWPATH.'/'.$auth_role.'/includes/scripts.php';
  ?>
  <div class="modal fade" id="details" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterProduct" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content" style="border:0px;">
          <div class="modal-header bg-dark">
            <h5 class="modal-title text-white" id="exampleModalLongProduct">Product Details</h5>
            <a id="print" href="javascript:(0);" class=" modal-title text-white" style="right:60px; position:absolute;">
              <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                  <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                      <rect id="bound" x="0" y="0" width="24" height="24"/>
                      <path d="M16,17 L16,21 C16,21.5522847 15.5522847,22 15,22 L9,22 C8.44771525,22 8,21.5522847 8,21 L8,17 L5,17 C3.8954305,17 3,16.1045695 3,15 L3,8 C3,6.8954305 3.8954305,6 5,6 L19,6 C20.1045695,6 21,6.8954305 21,8 L21,15 C21,16.1045695 20.1045695,17 19,17 L16,17 Z M17.5,11 C18.3284271,11 19,10.3284271 19,9.5 C19,8.67157288 18.3284271,8 17.5,8 C16.6715729,8 16,8.67157288 16,9.5 C16,10.3284271 16.6715729,11 17.5,11 Z M10,14 L10,20 L14,20 L14,14 L10,14 Z" id="Combined-Shape" fill="#000000"/>
                      <rect id="Combined-Shape-Copy" fill="#000000" opacity="0.3" x="8" y="2" width="8" height="2" rx="1"/>
                  </g>
              </svg>
            </a>
            <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
              <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                  <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                      <rect id="bound" x="0" y="0" width="24" height="24"/>
                      <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                      <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                  </g>
              </svg></a>
          </div>
          <div class="kt-scroll lm_max_height" data-scroll="true" style=" overflow-y: scroll; padding:30px;">
            <div class="modal-body text-back" id="printArea">

            </div>
          </div>
          <div class="modal-footer bg-dark">
          <small> &copy <?php echo date('Y') ;?> Lockminds BMS | Product details</small>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="newProduct" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterProduct" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content" style="border:0px;">
          <div class="modal-header bg-dark">
            <h5 class="modal-title text-white" id="exampleModalLongProduct">New Product</h5>
            <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
              <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                  <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                      <rect id="bound" x="0" y="0" width="24" height="24"/>
                      <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                      <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                  </g>
              </svg></a>
          </div>
          <div class="modal-body text-back">
            <div class="kt-scroll lm_max_height" data-scroll="true" style=" overflow-y: scroll; padding:30px;">
              <form id="newProductForm" class="kt-form" action="#" method="get" onsubmit="return false">
                <div class="form-groupn row">
                  <div class="col-12">
                    <label class="col-form-label">Product Name</label>
                    <input name="product_name" class="form-control" type="text" >
                  </div>
                </div>
                <div class="form-groupn row">
                  <div class="col-12">
                    <label class="col-form-label">Interest Rate (Annum) %</label>
                    <input name="product_interest_rate" class="form-control" type="text" >
                  </div>
                </div>
                <div class="form-groupn row">
                  <div class="col-12">
                    <label class="col-form-label">Interest Posting Frequency on Savings Accounts</label>
                    <select name="product_interest_frequency" class="form-control" name="">
                      <option value="1">Every 1 Month</option>
                      <option value="2">Every 2 Months</option>
                      <option value="3">Every 3 Months</option>
                      <option value="4">Every 4 Months</option>
                      <option value="6">Every 6 Months</option>
                      <option value="12">Every 12 Months</option>
                    </select>
                  </div>
                </div>
                <div class="form-groupn row">
                  <div class="col-12">
                    <label class="col-form-label">When should Interest be added to Saving Account?</label>
                    <select name="product_interest_add_day" class="form-control" name="">
                      <?php for ($i=1; $i < 32; $i++) {
                        if($i == 1){ $th = 'st'; }
                        if($i == 2){ $th = 'nd'; }
                        if($i == 3){ $th = 'rd'; }
                        if($i > 3){ $th = 'th'; }?>
                        <option value="<?php echo $i;?>"><?php echo $i.'<sup>'.$th.' of the month</sup>';?></option>
                      <?php } ?>
                    </select>
                  </div>
                </div>
                <div class="form-groupn row">
                  <div class="col-12">
                    <label class="col-form-label">Minimum Balance for Interest Rate</label>
                    <input name="product_minimun_balance_for_interest" class="form-control number" type="text" >
                  </div>
                </div>
                <div class="form-groupn row">
                  <div class="col-12">
                    <label class="col-form-label">Minimum Balance for Withdrawal</label>
                    <input name="product_minimum_balance_for_withdraw" class="form-control number" type="text" >
                  </div>
                </div>
                <div class="form-groupn row">
                  <div class="col-12">
                    <label class="col-form-label">Product Description</label>
                    <textarea name="product_details" class="form-control" rows="4" cols="80"></textarea>
                  </div>
                </div>
                <div class="form-group row">
                  <label class="col-8 col-form-label"></label>
                  <div class="col-3">
                    <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Register</b></button>
                  </div>
                </div>
              </form>
            </div>
          </div>
          <div class="modal-footer bg-dark">
          <small> &copy <?php echo date('Y') ;?> Lockminds BMS | Register new Product</small>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!--end::Global App Bundle -->

<script>
$(function(){
  $('select').css('width','100%');
  $('select').select2({placeholder: 'select option'});
let height = $(window).innerHeight()  - 250;
  $('.lm_max_height').css({ height: height });
  $(window).resize(function(){
    $('.lm_max_height').css({ height: height });
  });
});


  "use strict";
  // Class definition

var KTDefaultDatatableDemo = function() {
  	// Private functions

  	// basic demo
  var demo = function() {

  		var options = {
  			// datasource definition
  			data: {
  				type: 'remote',
  				source: {
  					read: {
  						url: '<?php echo base_url($auth_role.'/savings/products/datasource');?>',
  					},
  				},
  				pageSize: 10, // display 20 records per page
  				serverPaging: true,
  				serverFiltering: true,
  				serverSorting: true,
  			},

  			// layout definition
  			layout: {
  				scroll: true, // enable/disable datatable scroll both horizontal and vertical when needed.
  				//height: 400, // datatable's body's fixed height
  				footer: false, // display/hide footer
  			},

  			// column sorting
  			sortable: true,

  			pagination: true,

  			search: {
  				input: $('#generalSearch'),
  			},

  			// columns definition
  			columns: [
  				{
  					field: 'id',
  					title: '#',
  					sortable: false,
  					width: 30,
  					type: 'number',
  					selector: {class: 'kt-checkbox--solid'},
  					textAlign: 'center',
  					locked: {left: 'lg'},
  				}, {
  					field: 'product_name',
  					title: 'Product',
  					locked: {left: 'lg'},
            template: function(row){
              return ucfirst(row.product_name);
            }
  				},
          {
  					field: 'product_interest_rate',
  					title: 'Interest Rate',
            template: function(row){
              return row.product_interest_rate;
            }
  				},
          {
  					field: 'product_interest_frequency',
  					title: 'Interest Frequency',
            template: function(row){
              return row.product_interest_frequency;
            }
  				},
          {
  					field: 'product_minimum_balance_for_withdraw',
  					title: 'Min Balance Withdraw',
            template: function(row){
              return to_money(row.product_minimum_balance_for_withdraw).toString('TZS');
            }
  				},
          {
  					field: 'product_minimun_balance_for_interest',
  					title: 'Min Balance Interest',
            template: function(row){
              return to_money(row.product_minimun_balance_for_interest).toString('TZS');
            }
  				},
          {
  					field: 'product_actions',
  					title: 'Actions',
  					sortable: false,
  					width: 80,
  					overflow: 'visible',
  					autoHide: false,
            locked: {right: 'lg'}
  				}],

  		};

  		var datatable = $('.kt-datatable').KTDatatable(options);


  	};

  	return {
  		// public functions
  		init: function() {
  			demo();
  		},
  	};
  }();

  jQuery(document).ready(function() {
  	KTDefaultDatatableDemo.init();
  });


  $('form#newProductForm').submit( function(event){
    let form = $( this );
    event.preventDefault();
    let formdata = form.serialize();
    $.ajax({
     url: '<?php echo base_url($auth_role.'/savings/products/register/')?>',
      type: 'get',
      data: formdata,
      beforeSend: function(){
          KTApp.block("form#newProductForm",{
                  overlayColor:"#000000",
                  type:"loader",
                  state:"success",
                  message:"Creating new Product ...."
              });
        },
       success: function(r){
            var obj = JSON.parse(r);
            if(obj.status == 'ok'){
              $('.kt-datatable').KTDatatable('reload');
              Swal.fire('',obj.message,'success');
              }else{
                  Swal.fire('',obj.message,'warning');
              }
              KTApp.unblock('form#newProductForm');
              $('div#newProduct').modal('hide');
           },
        error: function(){
            KTApp.unblock('form#newProductForm');
            }
    });
  });

  function deleteItem(product){
    Swal.fire({
      title: 'Are you sure?',
      text: "You won't be able to revert this!",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
      if (result.value) {
        $.ajax({
            url: '<?php echo base_url($auth_role.'/savings/products/delete/product')?>/'+product,
            type: 'get',
            beforeSend: function(){
                KTApp.block(".kt-datatable",{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Deleting Product ..."
                    });
              },
             success: function(result){
                 let obj = JSON.parse(result);
                     if( obj.status == 'ok'){
                        Swal.fire('',obj.message,'success');
                        $('.kt-datatable').KTDatatable('reload');
                      }else{
                        Swal.fire('',obj.message,'warning');
                      }
                 KTApp.unblock('.kt-datatable');  KTApp.unblock('.kt-datatable');
                 },
              error: function(xhr){
                  KTApp.unblock('.kt-datatable');
                  Swal.fire('',xhr.statusText,'warning');
                  }
        });
      }
    })
  }

  function details(product){
    alert();
    let $modal =  $('div#details');
    let $div = $modal.find('.modal-body');
    $div.html('');
    $modal.modal('show');
    $.ajax({
      url: '<?php echo base_url($auth_role.'/savings/products/details/');?>' + product,
      type: 'get',
      beforeSend: function(){
      KTApp.block($div,{
              overlayColor:"#000000",
              type:"loader",
              state:"success",
              message:"Loading product details ...."
          });
      },
      success: function (result){
        $div.html(result);
        KTApp.unblock($div);
      },
      error: function (xhr){
        $modal.modal('hide');
        KTApp.unblock($div);
        Swal.fire('',xhr.statusText,'warning');
      }
    })
  }

  function modify(product){
    let $modal =  $('div#details');
    let $div = $modal.find('.modal-body');
    $div.html('');
    $modal.modal('show');
    $.ajax({
      url: '<?php echo base_url($auth_role.'/savings/products/modify/');?>' + product,
      type: 'get',
      beforeSend: function(){
      KTApp.block($div,{
              overlayColor:"#000000",
              type:"loader",
              state:"success",
              message:"Loading product details ...."
          });
      },
      success: function (result){
        $div.html(result);
        KTApp.unblock($div);
      },
      error: function (xhr){
        $modal.modal('hide');
        KTApp.unblock($div);
        Swal.fire('',xhr.statusText,'warning');
      }
    })
  }

  document.querySelector("#print").addEventListener("click", function() {
  	printJS({ printable: 'printArea', type: 'html', header: '<?php echo config_item('application_name');?> - Product Details',css:'<?php echo base_url('resources')?>/assets/demo/default/base/style.bundle.css','style':'link{text-decoration:none;}'});
  });
  </script>

</body>
</body>

<!-- end::Body -->
</html>
